/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIOEMLocCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.TagLocAbstractCommand;

public class TagLocFullTagCommand
extends TagLocAbstractCommand {
    @Override
    public void runCommand() throws Exception {
        int powerType;
        int chassisType;
        int mbType;
        int minorNumber;
        int majorNumber;
        int rack;
        int row;
        int room;
        int dataCenter;
        this.ipmiOEMLocCommand = new IPMIOEMLocCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        if (this.parameters == null || this.parameters.length < 9) {
            MOut.G(this).println("fullTag <dc> <rm> <ro> <rk> <n1> <n2> <m> <c> <p>");
            MOut.G(this).println("dc: Data Center ID    (0 - 65535)");
            MOut.G(this).println("rm: room ID           (0 - 65535)");
            MOut.G(this).println("rw: row ID            (0 - 65535)");
            MOut.G(this).println("rk: rack ID           (0 - 65535)");
            MOut.G(this).println("n1: Number major ID   (0 - 255)");
            MOut.G(this).println("n2: Number minor ID   (0 - 255)");
            MOut.G(this).println("m: MB type ID         (0 - 255)");
            MOut.G(this).println("c: chassis type ID    (0 - 255)");
            MOut.G(this).println("p: Power Type         (0 - 255)");
            MOut.G(this).println("");
            MOut.G(this).println("");
            MOut.G(this).println("");
            MOut.G(this).println("* note: The tag will be stored at UserID=10");
            return;
        }
        try {
            dataCenter = Integer.parseInt(this.parameters[0]);
            room = Integer.parseInt(this.parameters[1]);
            row = Integer.parseInt(this.parameters[2]);
            rack = Integer.parseInt(this.parameters[3]);
            majorNumber = Integer.parseInt(this.parameters[4]);
            minorNumber = Integer.parseInt(this.parameters[5]);
            mbType = Integer.parseInt(this.parameters[6]);
            chassisType = Integer.parseInt(this.parameters[7]);
            powerType = Integer.parseInt(this.parameters[8]);
        }
        catch (NumberFormatException ex) {
            MOut.G(this).print(ex.getMessage());
            return;
        }
        if (dataCenter < 0 || dataCenter > 65535) {
            MOut.G(this).print("Data Center ID out of range");
            return;
        }
        if (room < 0 || room > 65535) {
            MOut.G(this).print("Room ID out of range");
            return;
        }
        if (row < 0 || row > 65535) {
            MOut.G(this).print("Row ID out of range");
            return;
        }
        if (rack < 0 || rack > 65535) {
            MOut.G(this).print("Rack ID out of range");
            return;
        }
        if (majorNumber < 0 || majorNumber > 255) {
            MOut.G(this).print("Number Major ID out of range");
            return;
        }
        if (minorNumber < 0 || minorNumber > 255) {
            MOut.G(this).print("Number Minor ID out of range");
            return;
        }
        if (mbType < 0 || mbType > 255) {
            MOut.G(this).print("MB type ID out of range");
            return;
        }
        if (chassisType < 0 || chassisType > 255) {
            MOut.G(this).print("Chassis type ID out of range");
            return;
        }
        if (powerType < 0 || powerType > 255) {
            MOut.G(this).print("Power type ID out of range");
            return;
        }
        this.createIPMIOEMLocCommandObject();
        this.ipmiOEMLocCommand.setTagLoc(dataCenter, room, row, rack, (byte)majorNumber, (byte)minorNumber, (byte)mbType, (byte)chassisType, (byte)powerType);
        System.out.println("done");
    }
}

