/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.messaging.saaj.soap;

import com.sun.xml.internal.messaging.saaj.SOAPExceptionImpl;
import com.sun.xml.internal.messaging.saaj.soap.ContextClassloaderLocal;
import com.sun.xml.internal.messaging.saaj.soap.Envelope;
import com.sun.xml.internal.messaging.saaj.soap.SOAPPartImpl;
import com.sun.xml.internal.messaging.saaj.soap.SOAPVersionMismatchException;
import com.sun.xml.internal.messaging.saaj.util.JAXMStreamSource;
import com.sun.xml.internal.messaging.saaj.util.ParserPool;
import com.sun.xml.internal.messaging.saaj.util.RejectDoctypeSaxFilter;
import com.sun.xml.internal.messaging.saaj.util.transform.EfficientStreamingTransformer;
import java.io.IOException;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.soap.SOAPException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class EnvelopeFactory {
    protected static final Logger log = Logger.getLogger("com.sun.xml.internal.messaging.saaj.soap", "com.sun.xml.internal.messaging.saaj.soap.LocalStrings");
    private static ContextClassloaderLocal<ParserPool> parserPool = new ContextClassloaderLocal<ParserPool>(){

        @Override
        protected ParserPool initialValue() throws Exception {
            return new ParserPool(5);
        }
    };

    public static Envelope createEnvelope(Source source, SOAPPartImpl sOAPPartImpl) throws SOAPException {
        Object object;
        Object object2;
        SAXParser sAXParser = null;
        if (source instanceof StreamSource) {
            if (source instanceof JAXMStreamSource) {
                try {
                    if (!SOAPPartImpl.lazyContentLength) {
                        ((JAXMStreamSource)source).reset();
                    }
                }
                catch (IOException iOException) {
                    log.severe("SAAJ0515.source.reset.exception");
                    throw new SOAPExceptionImpl(iOException);
                }
            }
            try {
                sAXParser = parserPool.get().get();
            }
            catch (Exception exception) {
                log.severe("SAAJ0601.util.newSAXParser.exception");
                throw new SOAPExceptionImpl("Couldn't get a SAX parser while constructing a envelope", exception);
            }
            object2 = SAXSource.sourceToInputSource(source);
            if (((InputSource)object2).getEncoding() == null && sOAPPartImpl.getSourceCharsetEncoding() != null) {
                ((InputSource)object2).setEncoding(sOAPPartImpl.getSourceCharsetEncoding());
            }
            try {
                object = new RejectDoctypeSaxFilter(sAXParser);
            }
            catch (Exception exception) {
                log.severe("SAAJ0510.soap.cannot.create.envelope");
                throw new SOAPExceptionImpl("Unable to create envelope from given source: ", exception);
            }
            source = new SAXSource((XMLReader)object, (InputSource)object2);
        }
        try {
            Envelope envelope;
            object2 = EfficientStreamingTransformer.newTransformer();
            object = new DOMResult(sOAPPartImpl);
            ((Transformer)object2).transform(source, (Result)object);
            Envelope envelope2 = envelope = (Envelope)sOAPPartImpl.getEnvelope();
            return envelope2;
        }
        catch (Exception exception) {
            if (exception instanceof SOAPVersionMismatchException) {
                throw (SOAPVersionMismatchException)exception;
            }
            log.severe("SAAJ0511.soap.cannot.create.envelope");
            throw new SOAPExceptionImpl("Unable to create envelope from given source: ", exception);
        }
        finally {
            if (sAXParser != null) {
                parserPool.get().returnParser(sAXParser);
            }
        }
    }
}

