/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import javax.management.ListenerNotFoundException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.StandardMBean;

public class StandardEmitterMBean
extends StandardMBean
implements NotificationEmitter {
    private static final MBeanNotificationInfo[] NO_NOTIFICATION_INFO = new MBeanNotificationInfo[0];
    private final NotificationEmitter emitter;
    private final MBeanNotificationInfo[] notificationInfo;

    public <T> StandardEmitterMBean(T t, Class<T> clazz, NotificationEmitter notificationEmitter) {
        this(t, clazz, false, notificationEmitter);
    }

    public <T> StandardEmitterMBean(T t, Class<T> clazz, boolean bl, NotificationEmitter notificationEmitter) {
        super(t, clazz, bl);
        if (notificationEmitter == null) {
            throw new IllegalArgumentException("Null emitter");
        }
        this.emitter = notificationEmitter;
        MBeanNotificationInfo[] mBeanNotificationInfoArray = notificationEmitter.getNotificationInfo();
        this.notificationInfo = mBeanNotificationInfoArray == null || mBeanNotificationInfoArray.length == 0 ? NO_NOTIFICATION_INFO : (MBeanNotificationInfo[])mBeanNotificationInfoArray.clone();
    }

    protected StandardEmitterMBean(Class<?> clazz, NotificationEmitter notificationEmitter) {
        this(clazz, false, notificationEmitter);
    }

    protected StandardEmitterMBean(Class<?> clazz, boolean bl, NotificationEmitter notificationEmitter) {
        super(clazz, bl);
        if (notificationEmitter == null) {
            throw new IllegalArgumentException("Null emitter");
        }
        this.emitter = notificationEmitter;
        MBeanNotificationInfo[] mBeanNotificationInfoArray = notificationEmitter.getNotificationInfo();
        this.notificationInfo = mBeanNotificationInfoArray == null || mBeanNotificationInfoArray.length == 0 ? NO_NOTIFICATION_INFO : (MBeanNotificationInfo[])mBeanNotificationInfoArray.clone();
    }

    @Override
    public void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        this.emitter.removeNotificationListener(notificationListener);
    }

    @Override
    public void removeNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws ListenerNotFoundException {
        this.emitter.removeNotificationListener(notificationListener, notificationFilter, object);
    }

    @Override
    public void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
        this.emitter.addNotificationListener(notificationListener, notificationFilter, object);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        if (this.notificationInfo == null) {
            return NO_NOTIFICATION_INFO;
        }
        if (this.notificationInfo.length == 0) {
            return this.notificationInfo;
        }
        return (MBeanNotificationInfo[])this.notificationInfo.clone();
    }

    public void sendNotification(Notification notification) {
        if (!(this.emitter instanceof NotificationBroadcasterSupport)) {
            String string = "Cannot sendNotification when emitter is not an instance of NotificationBroadcasterSupport: " + this.emitter.getClass().getName();
            throw new ClassCastException(string);
        }
        ((NotificationBroadcasterSupport)this.emitter).sendNotification(notification);
    }

    @Override
    MBeanNotificationInfo[] getNotifications(MBeanInfo mBeanInfo) {
        return this.getNotificationInfo();
    }
}

