/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMIOEMCommand;
import com.supermicro.ipmi.SensorTypeCodeSingleton;
import com.supermicro.ipmi.lang.L;
import java.util.HashMap;

public class GlobalDefine {
    public static String FRU1_EDIT_Password = "Supermicro82265990";
    public static boolean OOB_PROJECT = false;
    public static boolean OOB_PROJECT_TOOLD = false;
    public static boolean OOB_PROJECT_TWITTER_BYPASS = false;
    public static boolean THERMAL_TEAM_SCRIPT = false;
    public static boolean OEM_RAKP_FLAG = false;
    public static boolean PAUSE_DEBUG = false;
    public static int SMCIPMITOOL_DEBUG_LEVEL = 0;
    public static boolean DEBUG_TRACE = false;
    public static final byte ASFMessage = 6;
    public static final byte IPMIMessage = 7;
    public static final byte CHASSIS_REQUEST = 0;
    public static final byte CHASSIS_RESPONSE = 4;
    public static final byte BRIDGE_REQUEST = 8;
    public static final byte BRIDGE_RESPONSE = 12;
    public static final byte SENSOR_EVENT_REQUEST = 16;
    public static final byte SENSOR_EVENT_RESPONSE = 20;
    public static final byte APP_REQUEST = 24;
    public static final byte APP_RESPONSE = 28;
    public static final byte FW_REQUEST = 32;
    public static final byte FW_RESPONSE = 36;
    public static final byte STORAGE_REQUEST = 40;
    public static final byte STORAGE_RESPONSE = 44;
    public static final byte TRANSPORT_REQUEST = 48;
    public static final byte TRANSPORT_RESPONSE = 52;
    public static final byte OEM_REQUEST = -64;
    public static final byte OEM_RESPONSE = -60;
    public static final byte RARITAN_OEM_REQUEST = -16;
    public static final byte RARITAN_OEM_RESPONSE = -12;
    public static final byte AMI_YAFU_REQUEST = -56;
    public static final byte DCM_SDK_GA_REQUEST = -64;
    public static final byte DCM_OEM_REQUEST = -72;
    public static final byte DCMI_REQUEST = -80;
    public static final byte GET_DEVICE_ID = 1;
    public static final byte COLD_RESET = 2;
    public static final byte WARM_RESET = 3;
    public static final byte GET_SELF_TEST_RESULTS = 4;
    public static final byte SET_ACPI_POWER_STATE = 6;
    public static final byte GET_ACPI_POWER_STATE = 7;
    public static final byte GET_DEVICE_GUID = 8;
    public static final byte RESET_WATCHDOG_TIMER = 34;
    public static final byte SET_WATCHDOG_TIMER = 36;
    public static final byte GET_WATCHDOG_TIMER = 37;
    public static final byte SET_BMC_GLOBAL_ENABLES = 46;
    public static final byte GET_BMC_GLOBAL_ENABLES = 47;
    public static final byte CLEAR_MESSAGE_FLAGS = 48;
    public static final byte GET_MESSAGE_FLAGS = 49;
    public static final byte ENABLE_MESSAGE_CHANNEL_RECEIVE = 50;
    public static final byte GET_MESSAGE = 51;
    public static final byte SEND_MESSAGE = 52;
    public static final byte READ_EVENT_MESSAGE_BUFFER = 53;
    public static final byte GET_SYSTEM_GUID = 55;
    public static final byte GET_CHANNEL_AUTH_CAP = 56;
    public static final byte GET_SESSION_CHALLENGE = 57;
    public static final byte ACTIVATE_SESSION = 58;
    public static final byte SET_SESSION_PRIVILEGE = 59;
    public static final byte CLOSE_SESSION = 60;
    public static final byte GET_SESSION_INFO = 61;
    public static final byte SET_USER_ACCESS = 67;
    public static final byte GET_USER_ACCESS = 68;
    public static final byte SET_USER_NAME = 69;
    public static final byte GET_USER_NAME = 70;
    public static final byte SET_USER_PASSWORD = 71;
    public static final byte ACTIVATE_PAYLOAD = 72;
    public static final byte DEACTIVATE_PAYLOAD = 73;
    public static final byte GET_CHANNEL_CIPHER_SUITES = 84;
    public static final byte MASTER_WRITE_I2C = 80;
    public static final byte MASTER_READ_I2C = 81;
    public static final byte MASTER_WRITE_READ_I2C = 82;
    public static final byte GET_SYSTEM_INTERFACE_CAPABILITIES = 87;
    public static final byte DUMP_TASK = 93;
    public static final byte SET_USER_PAYLOAD_ACCESS = 76;
    public static final byte GET_USER_PAYLOAD_ACCESS = 77;
    public static final byte SET_SYSTEM_INFO_PARAMETERS = 88;
    public static final byte GET_SYSTEM_INFO_PARAMETERS = 89;
    public static final byte PLATFORM_EVENT_MESSAGE = 2;
    public static final byte GET_DEVICE_SDR_INFO = 32;
    public static final byte GET_DEVICE_SDR = 33;
    public static final byte GET_SENSOR_HISTERISIS = 37;
    public static final byte GET_SENSOR_THRESHOLD = 39;
    public static final byte SET_SENSOR_EVENT_ENABLE = 40;
    public static final byte GET_SENSOR_EVENT_STATUS = 43;
    public static final byte GET_SENSOR_READING = 45;
    public static final byte GET_SENSOR_TYPE = 47;
    public static final byte GET_FRU_INVENTORY_AREA_INFO = 16;
    public static final byte READ_FRU_INVENTORY_DATA = 17;
    public static final byte WRITE_FRU_INVENTORY_DATA = 18;
    public static final byte READ_BMC_MEMORY = 27;
    public static final byte GET_SDR_REPOSITORY_INFO = 32;
    public static final byte RESERVE_SDR_REPOSITORY = 34;
    public static final byte GET_SDR = 35;
    public static final byte ADD_SDR = 36;
    public static final byte PARTIAL_ADD_SDR = 37;
    public static final byte DELETE_SDR = 38;
    public static final byte CLEAR_SDR = 39;
    public static final byte CLEAR_SDR_REPOSITORY = 39;
    public static final byte GET_SDR_REPOSITORY_TIME = 40;
    public static final byte GET_SEL_INFO = 64;
    public static final byte RESERVE_SEL_REPOSITORY = 66;
    public static final byte GET_SEL = 67;
    public static final byte ADD_SEL_ENTRY = 68;
    public static final byte PARTIAL_ADD_SEL = 69;
    public static final byte DELETE_SEL = 70;
    public static final byte CLEAR_SEL = 71;
    public static final byte GET_SEL_TIME = 72;
    public static final byte SET_SEL_TIME = 73;
    public static final byte GET_SEL_TIME_UTC_OFFISET = 92;
    public static final byte SET_SEL_TIME_UTC_OFFISET = 93;
    public static final byte SET_LAN_CONFIGURATION = 1;
    public static final byte GET_LAN_CONFIGURATION = 2;
    public static final byte SET_LAN_STATISTICS = 3;
    public static final byte GET_LAN_STATISTICS = 4;
    public static final byte SET_SOL_CONFIGURATION_PARAMETERS = 33;
    public static final byte GET_SOL_CONFIGURATION_PARAMETERS = 34;
    public static final byte ENTER_FW_TRANSFER = 0;
    public static final byte FW_PROGRAM_MEMORY = 1;
    public static final byte FW_READ_MEMORY = 2;
    public static final byte GET_FW_CHECKSUM = 3;
    public static final byte EXIT_FW_TRANSFER = 4;
    public static final byte SET_SEGMENT = 5;
    public static final byte GET_CHASSIS_STATUS = 1;
    public static final byte CHASSIS_CONTROL = 2;
    public static final byte CHASSIS_IDENTIFY = 4;
    public static final byte GET_SYSTEM_RESTART_CAUSE = 7;
    public static final byte SET_SYSTEM_BOOT_OPTION = 8;
    public static final byte GET_SYSTEM_BOOT_OPTION = 9;
    public static final byte SET_POWER_CYCLE_INTERVAL = 11;
    public static final byte GET_PEF_CAPABILITIES = 16;
    public static final byte ARM_PEF_POSTPONE_TIMER = 17;
    public static final byte SET_PEF_CONFIGURATION_PARAMETER = 18;
    public static final byte GET_PEF_CONFIGURATION_PARAMETER = 19;
    public static final byte SET_LAST_PROCESSED_EVENT_ID = 20;
    public static final byte GET_LAST_PROCESSED_EVENT_ID = 21;
    public static final byte ALERT_IMMEDIATE = 22;
    public static final byte PET_ACKNOWLEDGE = 23;
    public static final byte CLEAR_CHASSIS_INTRUSION = 3;
    public static final byte GRACEFUL_POWER_CONTROL = 4;
    public static final byte GET_BMC_MANUFACTORY = 11;
    public static final byte GET_BIOS_TYPE = 12;
    public static final byte ENABLE_UID_LED = 13;
    public static final byte DISABLE_UID_LED = 14;
    public static final byte GET_UID_STATUS = 12;
    public static final byte IS_UID_LED_PRESENT = 16;
    public static final byte SET_PRODUCT_ID = 32;
    public static final byte GET_PRODUCT_ID = 33;
    public static final byte GET_COMPACT_SENSOR = 17;
    public static final byte GET_LAN_DRIVER = 20;
    public static final byte IS_SUPPORT_STANDARD_GRACEFUL_SHUTDOWN_FOR_OSA = -120;
    public static final byte CHECK_NO_VM_AND_WEB = 39;
    public static final byte IS_OFFICE_BLADE = 65;
    public static final byte IS_BACKUP_RESTORE_FUNC_EXIST = 40;
    public static final byte GET_BIOS_FW_STATE = 102;
    public static final byte SET_BIOS_FW_STATE = 103;
    public static final byte IS_OEM_COMMAND_SUPPORTED = 41;
    public static final byte AMI_OEM_COMMAND = 112;
    public static final byte ALL_NETWORK_COMMAND = 43;
    public static final byte OEM_COMMAND_68H = 104;
    public static final byte OEM_COMMAND_70H = 112;
    public static final byte OEM_COMMAND_71H = 113;
    public static final byte OEM_COMMAND_ACH = -84;
    public static final byte RARITAN_GET_FIRMWARE_VERSION = 32;
    public static final byte RARITAN_START_FIRMWARE_UPGRADE = 33;
    public static final byte RARITAN_UPLOAD_FIRMWARE = 34;
    public static final byte RARITAN_FLASH_FIRMWARE = 35;
    public static final byte RARITAN_CANCEL_FIRMWARE_UPGRADE = 36;
    public static final byte RARITAN_FINALIZE_FIRMWARE_UPGRADE = 37;
    public static final byte RARITAN_RESET_TO_FACTORY_DEFAULTS = 64;
    public static final byte RARITAN_GET_SERIAL_NUMBER = 65;
    public static final byte RARITAN_SET_SERIAL_NUMBER = 66;
    public static final byte RARITAN_GET_VIRTUAL_MEDIA_STATUS = 80;
    public static final byte RARITAN_CLOSE_VIRTUAL_MEDIA_SESSION = 81;
    public static final byte RARITAN_START_FLOPPY_IMAGE_UPLOAD = 82;
    public static final byte RARITAN_UPLOAD_FLOPPY_IMAGE = 83;
    public static final byte RARITAN_FINALIZE_FLOPPY_IMAGE_UPLOAD = 84;
    public static final byte RARITAN_START_SMB_IMAGE_MOUNT = 85;
    public static final byte RARITAN_SET_SMB_IMAGE_PARAMETER = 86;
    public static final byte RARITAN_FINALIZE_SMB_IMAGE_MOUNT = 87;
    public static final byte KIRA_START_CONFIG_BACKUP = 96;
    public static final byte KIRA_BACKUP_CONFIG = 97;
    public static final byte KIRA_FINISH_CONFIG_BACKUP = 98;
    public static final byte KIRA_START_CONFIG_RESTORE = 99;
    public static final byte KIRA_RESTORE_CONFIG = 100;
    public static final byte KIRA_FINISH_CONFIG_RESTORE = 101;
    public static final byte KIRA_SYNC_CMM_CONFIG = 52;
    public static final byte CMM_SERVER_BLADE_COMMAND = 48;
    public static final byte CMM_POWER_SUPPLY_COMMAND = 49;
    public static final byte CMM_TEST_POWER_SUPPLY_COMMAND = 55;
    public static final byte CMM_INFINIBAND_COMMAND = 50;
    public static final byte CMM_GIGABIT_SWITCH_COMMAND = 51;
    public static final byte CMM_CMM_COMMAND = 52;
    public static final byte CMM_CMMMISC_COMMAND = 54;
    public static final byte CMM_TEST_COMMAND = 55;
    public static final byte CMM_KM_COMMAND = 56;
    public static final byte CMM_IPMB_OEM_COMMAND = 66;
    public static final byte CMM_MIDDLE_PLANE_FRU_COMMAND = 55;
    public static final byte CMM_BLADE_SUBCMD_DETECT_SIM = 1;
    public static final byte CMM_BLADE_SUBCMD_3_DOT_3V_POWER_GOOD = 2;
    public static final byte CMM_BLADE_SUBCMD_P12V_ENABLE = 3;
    public static final byte CMM_BLADE_SUBCMD_POWER_REQUEST = 4;
    public static final byte CMM_BLADE_SUBCMD_CLEAR_POWER_REQUEST = 5;
    public static final byte CMM_BLADE_SUBCMD_KVM_REQUEST = 6;
    public static final byte CMM_BLADE_SUBCMD_CLEAR_KVM_REQUEST = 7;
    public static final byte CMM_BLADE_SUBCMD_M1_KVM_ENABLE = 8;
    public static final byte CMM_BLADE_SUBCMD_M2_KVM_ENABLE = 9;
    public static final byte CMM_BLADE_SUBCMD_SERVER_BLADE_RESET = 10;
    public static final byte CMM_BLADE_SUBCMD_IS_POWER_SUPPLY_ON = 11;
    public static final byte CMM_BLADE_SUBCMD_IS_OVERHEAT = 12;
    public static final byte CMM_BLADE_SUBCMD_SERVER_BLADE_UID = 13;
    public static final byte CMM_BLADE_SUBCMD_REMOTE_KVM_REQUEST = 14;
    public static final byte CMM_BLADE_SUBCMD_GET_ADDRESS = 15;
    public static final byte CMM_BLADE_SUBCMD_GRACEFUL_POWER_DOWN = 16;
    public static final byte CMM_BLADE_SUBCMD_SET_POWER = 18;
    public static final byte CMM_BLADE_SUBCMD_CHECK_IF_ENOUGH_POWER_FOR_BLADES = 19;
    public static final byte CMM_BLADE_SUBCMD_READ_POWER_CONSUMPTION_STATUS = 20;
    public static final byte CMM_BLADE_SUBCMD_READ_BLADE_HW_INFO = 21;
    public static final byte CMM_BLADE_SUBCMD_SET_BLADENAME = 23;
    public static final byte CMM_BLADE_SUBCMD_GET_BLADENAME = 24;
    public static final byte CMM_BLADE_SUBCMD_BURST_POWER = 28;
    public static final byte CMM_POWER_SUBCMD_DETECT_POWER_SUPPLY = 1;
    public static final byte CMM_POWER_SUBCMD_POWER_SUPPLY_STATUS = 2;
    public static final byte CMM_POWER_SUBCMD_POWER_SUPPLY_FAN_SPEED = 3;
    public static final byte CMM_POWER_SUBCMD_TEST_POWER_SUPPLY_FAN_SPEED = 2;
    public static final byte CMM_POWER_SUBCMD_POWER_SUPPLY_ON_OFF = 4;
    public static final byte CMM_POWER_SUBCMD_GET_ADDRESS = 5;
    public static final byte CMM_POWER_SUBCMD_GET_TOTAL_REMAINING_POWER = 6;
    public static final byte CMM_POWER_SUBCMD_SET_ALL_FAN_SPEED = 7;
    public static final byte CMM_POWER_SUBCMD_SET_FAN_CONTROL_MODE = 9;
    public static final byte CMM_POWER_SUBCMD_GET_FAN_CONTROL_MODE = 10;
    public static final byte CMM_POWER_SUBCMD_SET_POWER_POLICY = 13;
    public static final byte CMM_POWER_SUBCMD_GET_POWER_POLICY = 14;
    public static final byte CMM_INFINIBAND_SUBCMD_POWER_SUPPLY_ON_OFF = 1;
    public static final byte CMM_INFINIBAND_SUBCMD_RESET = 2;
    public static final byte CMM_INFINIBAND_SUBCMD_PRESENT = 3;
    public static final byte CMM_INFINIBAND_SUBCMD_GET_ALL_SENSORS = 4;
    public static final byte CMM_INFINIBAND_SUBCMD_GET_ADDRESS = 5;
    public static final byte CMM_GIGABIT_SUBCMD_RESET = 1;
    public static final byte CMM_GIGABIT_SUBCMD_POWER_ON_OFF = 2;
    public static final byte CMM_GIGABIT_SUBCMD_STATUS = 3;
    public static final byte CMM_GIGABIT_SUBCMD_GET_ADDRESS = 4;
    public static final byte CMM_GIGABIT_SUBCMD_SET_IP = 5;
    public static final byte CMM_GIGABIT_SUBCMD_SET_NETMASK = 6;
    public static final byte CMM_GIGABIT_SUBCMD_SET_GATEWAY = 7;
    public static final byte CMM_GIGABIT_SUBCMD_SET_USERNAME = 8;
    public static final byte CMM_GIGABIT_SUBCMD_SET_PASSWORD = 9;
    public static final byte CMM_GIGABIT_SUBCMD_SET_TIME = 10;
    public static final byte CMM_GIGABIT_SUBCMD_GET_IP = 11;
    public static final byte CMM_GIGABIT_SUBCMD_GET_NETMASK = 12;
    public static final byte CMM_GIGABIT_SUBCMD_GET_GATEWAY = 13;
    public static final byte CMM_GIGABIT_SUBCMD_GET_USERNAME = 14;
    public static final byte CMM_GIGABIT_SUBCMD_GET_PASSWORD = 15;
    public static final byte CMM_GIGABIT_SUBCMD_GET_TIME = 16;
    public static final byte CMM_GIGABIT_SUBCMD_SET_COMMIT = 17;
    public static final byte CMM_GIGABIT_SUBCMD_SET_IP_ADDRESS_MODE = 19;
    public static final byte CMM_GIGABIT_SUBCMD_RESET_TO_DEFAULT = 20;
    public static final byte CMM_GIGABIT_SUBCMD_SET_BOOT_UP_IMAGE = 21;
    public static final byte CMM_GIGABIT_SUBCMD_RESTART = 22;
    public static final byte CMM_GIGABIT_SUBCMD_GET_IP_ADDRESS_MODE = 23;
    public static final byte CMM_GIGABIT_SUBCMD_GET_BOOT_UP_IMAGE = 24;
    public static final byte CMM_CMM_GET_CMM_SLOT = 1;
    public static final byte CMM_CMM_SET_CMM_TIME = 2;
    public static final byte CMM_CMM_GET_CMM_TIME = 3;
    public static final byte CMM_CMM_GET_OTHER_CMM_IP = 6;
    public static final byte CMM_CMM_GET_MY_IP = 7;
    public static final byte CMM_CMM_RESET_OTHER_CMM = 8;
    public static final byte CMM_CMM_GET_LOCAL_TIME_OR_NTP = 9;
    public static final byte CMM_CMM_IS_SUPPORT_IPMB = 10;
    public static final byte CMM_CMM_GET_UTC_OFFSET = 12;
    public static final byte CMM_CMM_SET_UTC_OFFSET = 13;
    public static final byte CMM_CMM_GET_NTP_SERVER_PRIMARY = 14;
    public static final byte CMM_CMM_GET_NTP_SERVER_SECONDARY = 15;
    public static final byte CMM_CMM_SET_NTP_SERVER_PRIMARY = 16;
    public static final byte CMM_CMM_SET_NTP_SERVER_SECONDARY = 17;
    public static final byte CMM_CMM_CLEAR_BUSY_FLAG_FOR_TIME = 18;
    public static final byte CMM_CMM_GET_BUSY_FLAG_FOR_TIME = 19;
    public static final byte CMM_CMM_SET_TO_NTP_MODE = 20;
    public static final byte CMM_CMM_SET_NTP1_AND_NTP2 = 21;
    public static final byte CMM_CMM_SET_BLADE_MODE = 25;
    public static final byte CMM_CMM_GET_BLADE_MODE = 26;
    public static final byte CMM_TEST_SET_BLADE_ERROR_LED = 1;
    public static final byte CMM_TEST_REPLY_TEST = 8;
    public static final byte CMM_MISC_GET_STRUCTURE_LENGTH = -16;
    public static final byte CMM_MISC_GET_STRUCTURE = -15;
    public static final byte GET_KVM_SESSION_TOKEN = 1;
    public static final byte GET_AMI_MOUSE_MODE = 3;
    public static final byte SET_AMI_MOUSE_MODE = 4;
    public static final byte GET_SET_LAN_MODE = 12;
    public static final byte SET_VIRTUAL_MEDIA_ATTACH_MODE = 11;
    public static final byte GET_KVM_SESSION_TOKEN_SH7757 = 72;
    public static final byte IF_REMOVE_CLEAR_CHASSIS_INTRUSION = 74;
    public static final byte AMI_OEM2_REQUEST = -56;
    public static final byte AMI_GET_DNS_SERVER = 67;
    public static final byte AMI_SET_DNS_SERVER = 68;
    public static final byte AMI_GET_UID_STATUS = 28;
    public static final byte AMI_ENABLE_UID = 29;
    public static final byte AMI_DISABLE_UID = 30;
    public static final byte AMI_YAFU_GET_FLASH_INFO = 1;
    public static final byte AMI_YAFU_GET_FIRMWARE_INFO = 2;
    public static final byte AMI_YAFU_GET_FMH_INFO = 3;
    public static final byte AMI_YAFU_GET_STATUS = 4;
    public static final byte AMI_YAFU_ACTIVATE_FLASHMODE = 16;
    public static final byte AMI_YAFU_ALLOCATE_MEMORY = 32;
    public static final byte AMI_YAFU_FREE_MEMORY = 33;
    public static final byte AMI_YAFU_READ_FLASH = 34;
    public static final byte AMI_YAFU_WRITE_FLASH = 35;
    public static final byte AMI_YAFU_ERASE_FLASH = 36;
    public static final byte AMI_YAFU_PROTECT_FLASH = 37;
    public static final byte AMI_YAFU_ERASE_COPYFLASH = 38;
    public static final byte AMI_YAFU_VERIFY_FLASH = 39;
    public static final byte AMI_YAFU_GET_ECF_STATUS = 40;
    public static final byte AMI_YAFU_GET_VERIFY_STATUS = 41;
    public static final byte AMI_YAFU_READ_MEMORY = 48;
    public static final byte AMI_YAFU_WRITE_MEMORY = 49;
    public static final byte AMI_YAFU_COPY_MEMORY = 50;
    public static final byte AMI_YAFU_COMPARE_MEMOR = 51;
    public static final byte AMI_YAFU_CLEAR_MEMOR = 52;
    public static final byte AMI_YAFU_GET_BOOTCONFIG = 64;
    public static final byte AMI_YAFU_SET_BOOTCONFIG = 65;
    public static final byte AMI_YAFU_GET_BOOTVARS = 66;
    public static final byte AMI_YAFU_DEACTIVATE_FLASH = 80;
    public static final byte AMI_YAFU_RESET_DEVICE = 81;
    public static final byte DCM_ONLINE_UPDATE_PREPARE_FOR_UPDATE = -96;
    public static final byte DCM_ONLINE_UPDATE_OPEN_AREA = -95;
    public static final byte DCM_ONLINE_UPDATE_WRITE_AREA = -94;
    public static final byte DCM_ONLINE_UPDATE_CLOSE_AREA = -93;
    public static final byte DCM_ONLINE_UPDATE_REGISTER_UPDATE = -92;
    public static final byte DCM_ONLINE_UPDATE_GET_STATUS = -90;
    public static final byte DCM_ONLINE_UPDATE_GET_CAPABILITIES = -89;
    public static final byte DCM_ONLINE_UPDATE_GET_IMAGE_INVENTORY = -88;
    public static final byte DCM_FORCE_ME_RESET = -33;
    public static final byte DCM_ENABLE_DISABLE_NODE_MANAGER_POLICY_CONTROL = -64;
    public static final byte DCM_SET_NODE_MANAGER_POLICY = -63;
    public static final byte DCM_GET_NODE_MANAGER_POLICY = -62;
    public static final byte DCM_SET_NODE_MANAGER_ALERT_THRESHOLDS = -61;
    public static final byte DCM_GET_NODE_MANAGER_ALERT_THRESHOLDS = -60;
    public static final byte DCM_SET_NODE_MANAGER_POLICY_SUSPEND_PERIODS = -59;
    public static final byte DCM_GET_NODE_MANAGER_POLICY_SUSPEND_PERIODS = -58;
    public static final byte DCM_RESET_NODE_MANAGER_STATISTICS = -57;
    public static final byte DCM_GET_NODE_MANAGER_STATISTICS = -56;
    public static final byte DCM_GET_NODE_MANAGER_CAPABILITIES = -55;
    public static final byte DCM_GET_NODE_MANAGER_VERSION = -54;
    public static final byte DCM_SET_NODE_MANAGER_POWER_DRAW_RANGE = -53;
    public static final byte DCM_SET_NODE_MANAGER_ALERT_DESTINATION = -50;
    public static final byte DCM_GET_NODE_MANAGER_ALERT_DESTINATION = -49;
    public static final byte DCM_SET_TOTAL_POWER_BUDGET_REQUEST = -48;
    public static final byte DCM_GET_TOTAL_POWER_BUDGET_REQUEST = -47;
    public static final byte DCM_SET_MAX_ALLOWED_CPU_P_T_STATE = -46;
    public static final byte DCM_GET_MAX_ALLOWED_CPU_P_T_STATE = -45;
    public static final byte DCM_GET_NUMBER_OF_P_T_STATE_REQUEST = -44;
    public static final byte DCM_SET_HOST_CPU_DATA = -42;
    public static final byte DCM_SET_PSU_CONFIG_REQEUST = -41;
    public static final byte DCM_GET_PSU_CONFIG_REQEUST = -40;
    public static final byte DCM_SEND_RAW_PMBUS = -39;
    public static final byte DCM_GET_HOST_CPU_DATA = -22;
    public static final byte DCM_SET_ME_POWER_STATE = -36;
    public static final byte DCM_FORCE_ME_RECOVERY = -33;
    public static final byte NM30_GET_CUPS_CAPABILITIES = 100;
    public static final byte NM30_GET_CUPS_DATA = 101;
    public static final byte NM30_SET_CUPS_CONFIG = 102;
    public static final byte NM30_GET_CUPS_CONFIG = 103;
    public static final byte NM30_SET_CUPS_POLICIES = 104;
    public static final byte NM30_GET_CUPS_POLICIES = 105;
    public static final byte DCM_PECI_SEND_RAW_PECI = 64;
    public static final byte DCM_PECI_AGG_SEND_RAE_PECI = 65;
    public static final byte DCM_PECI_CPU_PKG_CONF_READ = 66;
    public static final byte DCM_PECI_CPU_PKG_CONF_WRITE = 67;
    public static final byte DCM_PECI_CPU_PCI_CONF_READ = 68;
    public static final byte DCM_PECI_CPU_PCI_CONF_WRITE = 69;
    public static final byte DCM_PECI_CPU_IA_MSR_READ = 70;
    public static final byte DCM_PECI_GET_CPU_AND_MEM_TEMP = 75;
    public static final byte ITANIUM_CPU_COMMAND = 80;
    public static final byte ITANIUM_IO_COMMAND = 81;
    public static final byte ITANIUM_POWER_COMMAND = 82;
    public static final byte ITANIUM_MISC_COMMAND = 83;
    public static final byte ITANIUM_READ_I2C_COMMAND = -15;
    public static final byte ITANIUM_WRITE_I2C_COMMAND = -14;
    public static final byte ITANIUM_CPU_GET_DATA_SUB_COMMAND = 1;
    public static final byte ITANIUM_CPU_TURN_OFF_LINE_SUB_COMMAND = 16;
    public static final byte ITANIUM_CPU_TURN_ON_LINE_SUB_COMMAND = 17;
    public static final byte ITANIUM_CPU_READ_ROM_SUB_COMMAND = 32;
    public static final byte ITANIUM_IO_GET_DATA_SUB_COMMAND = 1;
    public static final byte ITANIUM_IO_TURN_OFF_LINE_SUB_COMMAND = 16;
    public static final byte ITANIUM_IO_TURN_ON_LINE_SUB_COMMAND = 17;
    public static final byte ITANIUM_POWER_GET_DATA_SUB_COMMAND = 1;
    public static final byte ITANIUM_POWER_TURN_OFF_LINE_SUB_COMMAND = 16;
    public static final byte ITANIUM_POWER_TURN_ON_LINE_SUB_COMMAND = 17;
    public static final byte ITANIUM_MISC_GET_DATA_SUB_COMMAND = 1;
    public static final byte DCMI_GET_DCMI_CAPABILITIES_INFO = 1;
    public static final byte DCMI_GET_ASSET_TAG = 6;
    public static final byte DCMI_SET_ASSET_TAG = 8;
    public static final byte DCMI_GET_MAG_CONTROLLER_ID_STR = 9;
    public static final byte DCMI_SET_MAG_CONTROLLER_ID_STR = 10;
    public static final byte DCMI_GET_DCMI_SENSOR_INFO = 7;
    public static final byte DCMI_GET_POWER_READING = 2;
    public static final byte DCMI_GET_POWER_LIMIT = 3;
    public static final byte DCMI_SET_POWER_LIMIT = 4;
    public static final byte DCMI_ACTIVATE_DEACTIVATE_POWER_LIMIT = 5;
    public static final byte BIOS_UPDATE_GET_FIRMWARE_INFO = 96;
    public static final byte BIOS_UPDATE_START_FIRMWARE_UPGRADE = 97;
    public static final byte BIOS_UPDATE_UPLOAD_FIRMWARE = 98;
    public static final byte BIOS_UPDATE_FLASH_FIRMWARE = 99;
    public static final byte BIOS_UPDATE_CANCEL_FIRMWARE_UPGRADE = 100;
    public static final byte BIOS_UPDATE_FINALIZE_FIRMWARE_UPGRADE = 101;
    public static final byte BIOS_UPDATE_GET_FIRMWARE_PROGRESS = 102;
    public static final byte BIOS_UPDATE_PREPARE = 103;
    public static final byte BIOS_UPDATE_PREPARE_DONE = 104;
    public static final byte BIOS_UPDATE_SET_PRODUCT_KEY = 105;
    public static final byte BIOS_UPDATE_CHECK_PRODUCT_KEY = 106;
    public static final byte FAN_SPEED_MODE = 69;
    public static final byte HOST_NAME_COMMAND = 71;
    public static final byte OEM_SUBCMD_GET_HDD_EXIST_AND_ERR_BITMAP = 76;
    public static final byte OEM_SUBCMD_GET_HDD_INFO_STRUCTURE = 77;
    public static final byte OEM_SUBCMD_GET_ALL_HDD_INFO_STRUCTURE = 78;
    public static final byte OEM_SUBCMD_GET_LOGICAL_HDD_TARGET_ID_MAP = 81;
    public static final byte OEM_SUBCMD_GET_LOGICAL_HDD_INFO_STRUCTURE = 82;
    public static final byte OEM_SUBCMD_GET_LOGICAL_ALL_HDD_INFO_STRUCTURE = 83;
    public static final byte OEM_SUBCMD_GET_TEMPERATURE = 112;
    public static final byte OEM_SUBCMD_GET_SET_PWM_FAN_LEVEL = 113;
    public static final byte OEM_SUBCMD_GET_FIRMWARE_UPDATE_STATUS = 107;
    public static final byte OEM_SUBCMD_GET_PCIE_SSD_PARAMETERS = 108;
    public static final byte OEM_BBP_TIMEOUT_SETTINGS = 98;
    public static final byte BMC_FILE_COMMAND = -96;
    public static final byte BMC_FILE_CONFIGURATION_COMMAND = -101;
    public static final byte BMC_FILE_GET_RESERVATION_ID = 1;
    public static final byte BMC_FILE_START_FILE_UPLOAD = 2;
    public static final byte BMC_FILE_FILE_UPLOAD = 3;
    public static final byte BMC_FILE_APPLY_FILE_COMMAND = 4;
    public static final byte BMC_FILE_PREPARE_FILE_DOWNLOAD = 5;
    public static final byte BMC_FILE_PREPARE_FILE_DOWNLOAD_DONE = 6;
    public static final byte BMC_FILE_FILE_DOWNLOAD = 7;
    public static final byte BMC_FILE_FILE_DOWNLOAD_DONE = 8;
    public static final byte BMC_FILE_BIOS_GET_FILE_STATUS = 9;
    public static final byte BMC_FILE_BIOS_FILE_DOWNLOAD = 10;
    public static final byte BMC_FILE_BIOS_FILE_DOWNLOAD_DONE = 11;
    public static final byte BMC_FILE_GET_BIOS_NV_UPDATE_STATUS = 12;
    public static final byte BMC_FILE_GET_BIOS_CURRENT_SETTING_STATUS = 16;
    public static final byte BMC_FILE_GET_SET_BIOS_OOB_CAPABILITY = 17;
    public static final byte BMC_FILE_GET_BIOS_DAT_FILE_STATUS = 22;
    public static final byte BMC_FILE_GET_POWER_STATUS = 24;
    public static final byte APPEND_RECORD = 0;
    public static final byte REPLACE_RECORD = 1;
    public static final byte PARTIAL_ADD_IN_PROGRESS = 0;
    public static final byte LAST_RECORD_DATA = 1;
    public static final byte OEM_SUBCMD_WEB_CLEAR_CERTIFICATE = 0;
    public static final byte OEM_SUBCMD_WEB_NTP_DATE_TIME = 1;
    public static final byte OEM_SUBCMD_WEB_ACTIVE_DIRECTORY = 2;
    public static final byte OEM_SUBCMD_WEB_SSL_CERTIFICATE = 3;
    public static final byte OEM_SUBCMD_WEB_DDNS = 4;
    public static final byte OEM_SUBCMD_WEB_RADIUS = 5;
    public static final byte OEM_SUBCMD_WEB_SMTP = 6;
    public static final byte OEM_SUBCMD_WEB_RESET_IKVM = 7;
    public static final byte OEM_SUBCMD_WEB_LDAP = 8;
    public static final byte OEM_SUBCMD_WEB_IPV6 = 9;
    public static final byte OEM_SUBCMD_WEB_DNS_SERVER = 10;
    public static final byte OEM_SUBCMD_WEB_ALERT = 11;
    public static final byte OEM_SUBCMD_WEB_GET_VM_DEVICE = 12;
    public static final byte OEM_SUBCMD_WEB_SET_VM_PARAM = 13;
    public static final byte OEM_SUBCMD_WEB_SMB_MOUNT = 14;
    public static final byte OEM_SUBCMD_WEB_SMB_UNMOUNT = 15;
    public static final byte OEM_SUBCMD_WEB_FLOPPY_UNMOUNT = 16;
    public static final byte OEM_SUBCMD_WEB_SMB_STATUS = 23;
    public static final byte I2C_WRITE_STATUS_NORMAL = 0;
    public static final byte I2C_WRITE_STATUS_LOST_ARB = 1;
    public static final byte I2C_WRITE_STATUS_BUS_ERROR = 2;
    public static final byte I2C_WRITE_STATUS_NAK_WRITE = 3;
    public static final byte I2C_WRITE_STATUS_TRUNC_READ = 4;
    public static final byte I2C_WRITE_STATUS_NAK_ADDRESS = 5;
    public static final byte I2C_WRITE_STATUS_BAD_LENGTH = 6;
    public static final byte I2C_READ_STATUS_NORMAL = 0;
    public static final byte REQ_OFFSET_NETFN = 0;
    public static final byte REQ_OFFSET_CMD = 1;
    public static final byte REQ_OFFSET_DATA = 2;
    public static final byte RSP_OFFSET_ADDR = 0;
    public static final byte RSP_OFFSET_NETFN = 1;
    public static final byte RSP_OFFSET_CMD = 2;
    public static final byte RSP_OFFSET_COMPCODE = 3;
    public static final byte RSP_OFFSET_DATA = 4;
    public static final byte IMB_RSP_OFFSET_RQADDR = 0;
    public static final byte IMB_RSP_OFFSET_NETFN = 1;
    public static final byte IMB_RSP_OFFSET_CKSUM = 2;
    public static final byte IMB_RSP_OFFSET_RSADDR = 3;
    public static final byte IMB_RSP_OFFSET_RQSEQRSLUN = 4;
    public static final byte IMB_RSP_OFFSET_CMD = 5;
    public static final byte IMB_RSP_OFFSET_COMPCODE = 6;
    public static final byte IMB_RSP_OFFSET_DATA = 7;
    public static final byte IPMIV20Plus = 2;
    public static final byte IPMIV20 = 1;
    public static final byte IPMIV15 = 0;
    public static final byte IPMIVERSION_UNKNOWN = 121;
    public static final byte PRIVILEGE_HIGHEST = 0;
    public static final byte PRIVILEGE_CALLBACK = 1;
    public static final byte PRIVILEGE_USER = 2;
    public static final byte PRIVILEGE_OPERATOR = 3;
    public static final byte PRIVILEGE_ADMINISTRATOR = 4;
    public static final byte PRIVILEGE_OEM = 5;
    public static final byte BIOS_UNKNOWN = 127;
    public static final byte BIOS_AWARD = 0;
    public static final byte BIOS_PHOENIX = 1;
    public static final byte BIOS_AMI = 2;
    public static final byte BMC_UNKNOWN = 127;
    public static final byte BMC_SUPERMICRO = 1;
    public static final byte NIC_UNKNOWN = 127;
    public static final byte NIC_B5721 = 0;
    public static final byte NIC_B5704 = 1;
    public static final byte NIC_I82546 = 2;
    public static final byte NIC_I82541 = 3;
    public static final byte NIC_I82573 = 4;
    public static int timeout = -1;
    public static int retryCount = -1;
    public static String SixUBlade = "L628";
    public static String ThreeUBlade = "E314";
    public static String[] SensorUnitString = new String[]{"unspecified", "degrees C", "degrees F", "degrees K", "Volts", "Amps", "Watts", "Joules", "Coulombs", "VA", "Nits", "lumen", "lux", "Candela", "kPa", "PSI", "Newton", "CFM", "RPM", "Hz", "microsecond", "millisecond", "second", "minute", "hour", "day", "week", "mil", "inches", "feet", "cu in", "cu feet", "mm", "cm", "m", "cu cm", "cu m", "liters", "fluid ounce", "radians", "steradians", "revolutions", "cycles", "gravities", "ounce", "pound", "ft-lb", "oz-in", "gauss", "gilberts", "henry", "millihenry", "farad", "microfarad", "ohms", "siemens", "mole", "becquerel", "PPM (parts/million)", "reserved", "Decibels", "DbA", "DbC", "gray", "sievert", "color temp deg K", "bit", "kilobit", "megabit", "gigabit", "byte", "kilobyte", "megabyte", "gigabyte", "word (data)", "dword", "qword", "line (re. mem. line)", "hit", "miss", "retry", "reset", "overrun / overflow", "underrun", "collision", "packets", "messages", "characters", "error", "correctable error", "uncorrectable error", "fatal error", "grams"};
    static String[][] EventTypeCodes = new String[][]{{"01", "00", L.t("define.Lower_Non-critical_-_going_low")}, {"01", "01", L.t("define.Lower_Non-critical_-_going_high")}, {"01", "02", L.t("define.Lower_Critical_-_going_low")}, {"01", "03", L.t("define.Lower_Critical_-_going_high")}, {"01", "04", L.t("define.Lower_Non-recoverable_-_going_low")}, {"01", "05", L.t("define.Lower_Non-recoverable_-_going_high")}, {"01", "06", L.t("define.Upper_Non-critical_-_going_low")}, {"01", "07", L.t("define.Upper_Non-critical_-_going_high")}, {"01", "08", L.t("define.Upper_Critical_-_going_low")}, {"01", "09", L.t("define.Upper_Critical_-_going_high")}, {"01", "0A", L.t("define.Upper_Non-recoverable_-_going_low")}, {"01", "0B", L.t("define.Upper_Non-recoverable_-_going_high")}, {"02", "00", "Transition to Idle"}, {"02", "01", "Transition to Active"}, {"02", "02", "Transition to Busy"}, {"03", "00", "State Deasserted"}, {"03", "01", "State Asserted"}, {"04", "00", "Predictive Failure deasserted"}, {"04", "01", "Predictive Failure asserted"}, {"05", "00", "Limit Not Exceeded"}, {"05", "01", "Limit Exceeded"}, {"06", "00", "Performance Met"}, {"06", "01", "Performance Lags"}, {"07", "00", "transition to OK"}, {"07", "01", "transition to Non-Critical from OK"}, {"07", "02", "transition to Critical from less severe"}, {"07", "03", "transition to Non-recoverable from less severe"}, {"07", "04", "transition to Non-Critical from more severe"}, {"07", "05", "transition to Critical from Non-recoverable"}, {"07", "06", "transition to Non-recoverable"}, {"07", "07", "Monitor"}, {"07", "08", "Informational"}, {"08", "00", "Device Removed / Device Absent"}, {"08", "01", "Device Inserted / Device Present"}, {"09", "00", "Device Disabled"}, {"09", "01", "Device Enabled"}, {"0A", "00", "transition to Running"}, {"0A", "01", "transition to In Test"}, {"0A", "02", "transition to Power Off"}, {"0A", "03", "transition to On Line"}, {"0A", "04", "transition to Off Line"}, {"0A", "05", "transition to Off Duty"}, {"0A", "06", "transition to Degraded"}, {"0A", "07", "transition to Power Save"}, {"0A", "08", "Install Error"}, {"0B", "00", "Redundancy Regained"}, {"0B", "01", "Redundancy Lost"}, {"0B", "02", "Redundancy Degraded"}, {"0B", "03", "Non-Redundant"}, {"0B", "04", "Non-Redundant"}, {"0B", "05", "Non-Redundant"}, {"0B", "06", "Redundancy Degraded"}, {"0B", "07", "Redundancy Degraded"}, {"0C", "00", "D0 Power State"}, {"0C", "01", "D1 Power State"}, {"0C", "02", "D2 Power State"}, {"0C", "03", "D3 Power State"}, {"-", "-", "-"}};
    public static String[] MESensorNumber = new String[]{"Memory Throttling Status for CPU 0 /Memory Channel 0", "Memory Throttling Status for CPU 0 /Memory Channel 1", "Memory Throttling Status for CPU 0 /Memory Channel 2", "CPU 0 Temperature", "Memory Throttling Status for CPU 1 /Memory Channel 0", "Memory Throttling Status for CPU 1 /Memory Channel 1", "Memory Throttling Status for CPU 1 /Memory Channel 2", "CPU 1 Temperature", "Reversed", "Reversed", "Reversed", "CPU 2 Temperature", "Reversed", "Reversed", "Reversed", "CPU 3 Temperature", "Reversed", "Reversed", "Reversed", "Reversed", "ICH9 on-die temperature Sensor 0", "ICH9 on-die temperature Sensor 1", "ME Power State", "Server Platform Services Firmware health", "Node Manager event Sensor", "Node Manager Health Sensor", "Node Manager Operational Capabilities Sensor", "Node Manager Alert Threshold Exceeded Sensor"};
    public static HashMap completionCodeString = new HashMap();

    public static String getSensorType(int TypeCode) {
        if (TypeCode == 193) {
            return "Blade";
        }
        if (TypeCode == 194) {
            return "Power Supply";
        }
        if (TypeCode == 195) {
            return "Gigabit Switch";
        }
        if (TypeCode == 196) {
            return "Infiniband";
        }
        if (TypeCode == 197) {
            return "CMM";
        }
        for (int i = 0; i < SensorTypeCodeSingleton.SIZE(); ++i) {
            if (ByteUtility.byteToHex((byte)TypeCode).compareToIgnoreCase(SensorTypeCodeSingleton.E(i, 0)) != 0) continue;
            return SensorTypeCodeSingleton.E(i, 4);
        }
        return "undefined";
    }

    public static String getSensorType(int TypeCode, byte[] guid) {
        if (IPMIMessagingCommand.isCMMGUID(guid)) {
            if (TypeCode == 193) {
                return "Blade";
            }
            if (TypeCode == 194) {
                return "Power Supply";
            }
            if (TypeCode == 195) {
                return "Gigabit Switch";
            }
            if (TypeCode == 196) {
                return "Infiniband";
            }
            if (TypeCode == 197) {
                return "CMM";
            }
        } else {
            if (TypeCode == 194) {
                return "CPLD";
            }
            if (TypeCode == 195) {
                return "CPU";
            }
        }
        for (int i = 0; i < SensorTypeCodeSingleton.SIZE(); ++i) {
            if (ByteUtility.byteToHex((byte)TypeCode).compareToIgnoreCase(SensorTypeCodeSingleton.E(i, 0)) != 0) continue;
            return SensorTypeCodeSingleton.E(i, 4);
        }
        return "undefined";
    }

    public static String getSensorType(int TypeCode, byte eventData1) {
        if (eventData1 == -64 || eventData1 == -63 || eventData1 == -62 || eventData1 == -61) {
            if (TypeCode == 193) {
                return "Blade";
            }
            if (TypeCode == 194) {
                return "Power Supply";
            }
            if (TypeCode == 195) {
                return "Gigabit Switch";
            }
            if (TypeCode == 196) {
                return "Infiniband";
            }
            if (TypeCode == 197) {
                return "CMM";
            }
        } else {
            if (TypeCode == 194) {
                return "CPLD";
            }
            if (TypeCode == 195) {
                return "CPU";
            }
        }
        for (int i = 0; i < SensorTypeCodeSingleton.SIZE(); ++i) {
            if (ByteUtility.byteToHex((byte)TypeCode).compareToIgnoreCase(SensorTypeCodeSingleton.E(i, 0)) != 0) continue;
            return SensorTypeCodeSingleton.E(i, 4);
        }
        return "undefined";
    }

    public static String LookupEventType(byte TypeCode, byte Offset) {
        int i = 0;
        while (EventTypeCodes[i][0] != "-") {
            if (ByteUtility.byteToHex(TypeCode).compareToIgnoreCase(EventTypeCodes[i][0]) == 0 && ByteUtility.byteToHex(Offset).compareToIgnoreCase(EventTypeCodes[i][1]) == 0) {
                return EventTypeCodes[i][2];
            }
            ++i;
        }
        return "undefined";
    }

    public static String LookupSensorType(byte SensorType, byte eData1, byte eData2, byte eData3) {
        byte[] productID = new byte[2];
        return GlobalDefine.LookupSensorType(SensorType, eData1, eData2, eData3, productID);
    }

    public static String LookupSensorType(byte SensorType, byte eData1, byte eData2, byte eData3, byte[] productID) {
        return GlobalDefine.LookupSensorType(SensorType, eData1, eData2, eData3, productID, (byte)-1);
    }

    public static String LookupSensorType(byte SensorType, byte eData1, byte eData2, byte eData3, byte[] productID, byte sensorNumber) {
        int i = 0;
        while (SensorTypeCodeSingleton.E(i, 0) != "-") {
            if (ByteUtility.byteToHex(SensorType).compareToIgnoreCase(SensorTypeCodeSingleton.E(i, 0)) == 0) {
                while (ByteUtility.byteToHex(SensorType).compareToIgnoreCase(SensorTypeCodeSingleton.E(i, 0)) == 0) {
                    if (SensorTypeCodeSingleton.E(i, 1).equals("-")) {
                        if (SensorType == -53) {
                            String msg = " (" + ByteUtility.byteToHex(eData1) + " " + ByteUtility.byteToHex(eData2) + " " + ByteUtility.byteToHex(eData3) + ")";
                            return SensorTypeCodeSingleton.E(i, 5) + msg;
                        }
                        if (SensorType == -52) {
                            return SensorTypeCodeSingleton.getInstance().getMRCDesc(sensorNumber, eData1, eData2, eData3);
                        }
                        return SensorTypeCodeSingleton.E(i, 5);
                    }
                    if (eData1 == -64 || eData1 == -63 || eData1 == -62 || eData1 == -61 || SensorType == -62 && (byte)(eData1 & 0xA0) == -96 ? ByteUtility.byteToHex(eData1).compareToIgnoreCase(SensorTypeCodeSingleton.E(i, 1)) == 0 && ByteUtility.byteToHex(eData2).compareToIgnoreCase(SensorTypeCodeSingleton.E(i, 2)) == 0 : (SensorType == -21 || SensorType == -20 || SensorType == -19) && ByteUtility.byteToHex(eData1).compareToIgnoreCase(SensorTypeCodeSingleton.E(i, 1)) == 0 && ByteUtility.byteToHex(eData2).compareToIgnoreCase(SensorTypeCodeSingleton.E(i, 2)) == 0 && ByteUtility.byteToHex(eData3).compareToIgnoreCase(SensorTypeCodeSingleton.E(i, 3)) == 0) {
                        return SensorTypeCodeSingleton.E(i, 4) + "| Event = " + SensorTypeCodeSingleton.E(i, 5);
                    }
                    if (ByteUtility.byteToHex((byte)(eData1 & 0xF)).compareToIgnoreCase(SensorTypeCodeSingleton.E(i, 1)) == 0 && (SensorTypeCodeSingleton.E(i, 2).equals("-") || ByteUtility.byteToHex(eData2).compareToIgnoreCase(SensorTypeCodeSingleton.E(i, 2)) == 0)) {
                        return SensorTypeCodeSingleton.E(i, 4) + "| Event = " + SensorTypeCodeSingleton.E(i, 5) + GlobalDefine.LookupOEMSensorType(SensorType, eData1, eData2, eData3, productID);
                    }
                    ++i;
                }
                return "undefined";
            }
            ++i;
        }
        return "undefined";
    }

    public static String LookupSensorType2(byte SensorType, byte eData1, byte eData2, byte eData3, byte[] productID, byte sensorNumber) {
        int i = 0;
        while (SensorTypeCodeSingleton.E(i, 0) != "-") {
            if (ByteUtility.byteToHex(SensorType).compareToIgnoreCase(SensorTypeCodeSingleton.E(i, 0)) == 0) {
                while (ByteUtility.byteToHex(SensorType).compareToIgnoreCase(SensorTypeCodeSingleton.E(i, 0)) == 0) {
                    if (SensorTypeCodeSingleton.E(i, 1).equals("-")) {
                        if (SensorType == -53) {
                            String msg = " (" + ByteUtility.byteToHex(eData1) + " " + ByteUtility.byteToHex(eData2) + " " + ByteUtility.byteToHex(eData3) + ")";
                            return SensorTypeCodeSingleton.E(i, 5) + msg;
                        }
                        if (SensorType == -52) {
                            return SensorTypeCodeSingleton.getInstance().getMRCDesc(sensorNumber, eData1, eData2, eData3);
                        }
                        return SensorTypeCodeSingleton.E(i, 5);
                    }
                    if (eData1 == -64 || eData1 == -63 || eData1 == -62 || eData1 == -61 ? ByteUtility.byteToHex(eData1).compareToIgnoreCase(SensorTypeCodeSingleton.E(i, 1)) == 0 && ByteUtility.byteToHex(eData2).compareToIgnoreCase(SensorTypeCodeSingleton.E(i, 2)) == 0 : (SensorType == -62 && (byte)(eData1 & 0xA0) == -96 ? ByteUtility.byteToHex(eData1).compareToIgnoreCase(SensorTypeCodeSingleton.E(i, 1)) == 0 && ByteUtility.byteToHex(eData2).compareToIgnoreCase(SensorTypeCodeSingleton.E(i, 2)) == 0 : (SensorType == -21 || SensorType == -20 || SensorType == -19) && ByteUtility.byteToHex(eData1).compareToIgnoreCase(SensorTypeCodeSingleton.E(i, 1)) == 0 && ByteUtility.byteToHex(eData2).compareToIgnoreCase(SensorTypeCodeSingleton.E(i, 2)) == 0 && ByteUtility.byteToHex(eData3).compareToIgnoreCase(SensorTypeCodeSingleton.E(i, 3)) == 0)) {
                        return SensorTypeCodeSingleton.E(i, 4) + "| Event = " + SensorTypeCodeSingleton.E(i, 5);
                    }
                    if (ByteUtility.byteToHex((byte)(eData1 & 0xF)).compareToIgnoreCase(SensorTypeCodeSingleton.E(i, 1)) == 0 && (SensorTypeCodeSingleton.E(i, 2).equals("-") || ByteUtility.byteToHex(eData2).compareToIgnoreCase(SensorTypeCodeSingleton.E(i, 2)) == 0)) {
                        return SensorTypeCodeSingleton.E(i, 4) + "| Event = " + SensorTypeCodeSingleton.E(i, 5) + GlobalDefine.LookupOEMSensorType(SensorType, eData1, eData2, eData3, productID);
                    }
                    ++i;
                }
                return "undefined";
            }
            ++i;
        }
        return "undefined";
    }

    public static int checkChipSetType(byte[] productID) {
        if (productID[0] == 0 && productID[1] == 0) {
            return 99;
        }
        String boardName = IPMIOEMCommand.getBoardModel(productID);
        if (boardName == null) {
            boardName = "";
        }
        if (boardName.toUpperCase().indexOf("X9D") != -1 || boardName.toUpperCase().indexOf("X9Q") != -1 || boardName.toUpperCase().indexOf("B9D") != -1 || boardName.toUpperCase().indexOf("X9SR") != -1 || boardName.toUpperCase().indexOf("X9SB") != -1 || boardName.toUpperCase().indexOf("X10") != -1 || boardName.toUpperCase().indexOf("B10D") != -1 || boardName.toUpperCase().indexOf("B1D") != -1 || boardName.toUpperCase().indexOf("X11") != -1) {
            if (boardName.toUpperCase().indexOf("X10QRH") != -1) {
                return 4;
            }
            if (boardName.toUpperCase().indexOf("X10QBI") != -1 || boardName.toUpperCase().indexOf("X10DBT") != -1 || boardName.toUpperCase().indexOf("X10QBL") != -1) {
                return 3;
            }
            if (boardName.toUpperCase().indexOf("X9DAL") != -1 || boardName.toUpperCase().indexOf("X9DB") != -1 || boardName.toUpperCase().indexOf("X9SB") != -1) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public static String memoryECCLocation(byte eData2, byte eData3, byte[] productID) {
        String loc = "";
        int type = GlobalDefine.checkChipSetType(productID);
        switch (type) {
            case 0: {
                loc = String.format("@DIMM%2X(CPU%x)", eData2, (eData3 & 3) + 1);
                break;
            }
            case 1: {
                byte bank_high = (byte)((eData2 >> 4) + 64 + (eData3 & 3) * 4);
                byte bank_low = (byte)((eData2 & 0xF) + 39);
                loc = String.format("@DIMM%c%c(CPU%x)", bank_high, bank_low, (eData3 & 3) + 1);
                break;
            }
            case 2: {
                byte bank_high = (byte)((eData2 >> 4) + 64 + (eData3 & 3) * 3);
                byte bank_low = (byte)((eData2 & 0xF) + 39);
                loc = String.format("@DIMM%c%c(CPU%x)", bank_high, bank_low, (eData3 & 3) + 1);
                break;
            }
            case 3: {
                int cpu = (eData3 & 0xF) + 1;
                int module = (eData2 & 0xFF) >> 4 > 4 ? 2 : 1;
                int channel = (eData2 & 0xF) - 9;
                byte value = (byte)((eData2 & 0xFF) >> 4);
                byte number = value > 4 ? (byte)(60 + value) : (byte)(64 + value);
                loc = String.format("@DIMM%c%d(P%dM%d)", number, channel, cpu, module);
                break;
            }
            case 4: {
                byte bank_high = (byte)((eData2 >> 4) + 64);
                byte bank_low = (byte)((eData2 & 0xF) + 39);
                loc = String.format("@DIMM%c%c(CPU%x)", bank_high, bank_low, (eData3 & 3) + 1);
                break;
            }
            case 99: {
                byte bank_high = (byte)((eData2 >> 4) + 64 + (eData3 & 3) * 4);
                byte bank_low = (byte)((eData2 & 0xF) + 39);
                String loc1 = String.format("[@DIMM%c%c(CPU%x)X10,X9 Romley EP,EX]", bank_high, bank_low, (eData3 & 3) + 1);
                bank_high = (byte)((eData2 >> 4) + 64 + (eData3 & 3) * 3);
                bank_low = (byte)((eData2 & 0xF) + 39);
                String loc2 = String.format("[@DIMM%c%c(CPU%x)X9 Romley EN]", bank_high, bank_low, (eData3 & 3) + 1);
                String loc3 = String.format("[@DIMM%2X(CPU%x)X8]", eData2, eData3 & 3);
                loc = loc1 + loc2 + loc3;
                break;
            }
            default: {
                loc = "";
            }
        }
        return loc;
    }

    public static String LookupOEMSensorType(byte SensorType, byte eData1, byte eData2, byte eData3) {
        byte[] boardID = new byte[2];
        return GlobalDefine.LookupOEMSensorType(SensorType, eData1, eData2, eData3, boardID);
    }

    public static String LookupOEMSensorType(byte SensorType, byte eData1, byte eData2, byte eData3, byte[] productID) {
        String msg = "";
        if (SensorType == 12 && ((eData1 & 0xF) == 0 || (eData1 & 0xF) == 1)) {
            if (eData2 == 0 && eData3 == 0) {
                return msg;
            }
            msg = GlobalDefine.memoryECCLocation(eData2, eData3, productID);
        } else if (SensorType == 19 && ((eData1 & 0xF) == 4 || (eData1 & 0xF) == 5 || (eData1 & 0xF) == 7 || (eData1 & 0xF) == 8) || (eData1 & 0xF) == 10) {
            byte busNo = eData2;
            byte device = eData3;
            msg = ", Bus" + ByteUtility.byteToHex(busNo) + "(DevFn" + ByteUtility.byteToHex(device) + ")";
        }
        return msg;
    }

    public static String getEventType(byte TypeCode, byte SType, byte eData1, byte eData2, byte eData3) {
        byte[] productID = new byte[2];
        return GlobalDefine.getEventType(TypeCode, SType, eData1, eData2, eData3, productID);
    }

    public static String getEventType(byte TypeCode, byte SType, byte eData1, byte eData2, byte eData3, byte[] productID) {
        return GlobalDefine.getEventType(TypeCode, SType, eData1, eData2, eData3, productID, (byte)-1);
    }

    public static String getEventType(byte TypeCode, byte SType, byte eData1, byte eData2, byte eData3, byte[] productID, byte sensorNumber) {
        boolean Assertion = (TypeCode & 0x80) == 0;
        byte EventType = (byte)(TypeCode & 0x7F);
        String xString = null;
        xString = Assertion ? L.t("define.Assertion") + ": " : L.t("define.De-assertion") + ": ";
        if (EventType == 0) {
            return L.t("define.unspecified");
        }
        if (EventType >= 1 && EventType <= 11) {
            xString = xString + GlobalDefine.LookupEventType(EventType, (byte)(eData1 & 0xF));
        } else if (EventType == 111 || EventType == 112) {
            xString = xString + GlobalDefine.LookupSensorType(SType, eData1, eData2, eData3, productID, sensorNumber);
        } else {
            if (EventType >= 112 && EventType <= 127) {
                return L.t("define.OEM");
            }
            return L.t("define.reserved");
        }
        return xString;
    }

    public static String getDiscreteSensorReading(byte TypeCode, byte SType, byte eData1) {
        String xString = null;
        byte EventType = (byte)(TypeCode & 0x7F);
        if (EventType == 0) {
            xString = "N/A";
        } else if (EventType >= 1 && EventType <= 11) {
            xString = GlobalDefine.LookupEventType(EventType, (byte)(eData1 & 0xF));
            if (xString.contains("undefined")) {
                xString = "N/A";
            }
        } else if (EventType == 111) {
            xString = GlobalDefine.LookupSensorType(SType, eData1, (byte)0, (byte)0);
            xString = xString.substring(xString.indexOf(61) + 2);
        }
        return xString;
    }

    public static String LookupMESensor(byte sensorNumber) {
        String sensorStr = "";
        sensorStr = sensorNumber <= 27 ? sensorStr + MESensorNumber[sensorNumber] : sensorStr + "undefined";
        return sensorStr;
    }

    public static String LookupMEEventType(byte sensorNumber, byte eventType, byte eventOffset, byte event1, byte event2, byte event3) {
        String eventTypeStr = "Event Type : " + ByteUtility.byteToHex(eventType) + "h";
        String descriptionStr = "";
        if (eventType == 114 && sensorNumber == 24) {
            if ((byte)(event1 & 4) == 4) {
                descriptionStr = descriptionStr + "Policy event : Policy Correction Time Exceeded\n";
            }
            descriptionStr = descriptionStr + "Policy ID = " + ByteUtility.byteToHex(event3);
        } else if (eventType == 115 && sensorNumber == 25) {
            byte errorType = (byte)(event2 >> 4);
            if ((byte)(event1 & 2) == 2) {
                descriptionStr = descriptionStr + "Health Event Type :Sensor Node Manager\n";
            }
            switch (errorType) {
                case 10: {
                    descriptionStr = descriptionStr + "Error Type : Policy Misconfiguration\n";
                    descriptionStr = descriptionStr + "Policy ID : " + event3;
                    break;
                }
                case 11: {
                    descriptionStr = descriptionStr + "Error Type : Power Sensor Reading Fauilure\n";
                    descriptionStr = descriptionStr + "Power Sensor Address : " + ByteUtility.byteToHex(event3) + "h";
                    break;
                }
                case 12: {
                    descriptionStr = descriptionStr + "Error Type : Inlet Temperature Reading Failure\n";
                    descriptionStr = descriptionStr + "Inlet Sensor Address : " + ByteUtility.byteToHex(event3) + "h";
                    break;
                }
                case 13: {
                    descriptionStr = descriptionStr + "Error Type : Host Communication error";
                    break;
                }
                case 14: {
                    descriptionStr = descriptionStr + "Error Type : Reail-time clock synchronization failure";
                    break;
                }
                case 15: {
                    descriptionStr = descriptionStr + "Error Type : Platform shutdown initiated by NM policy due to executeion of action defined by Policy Exception Action\n";
                    descriptionStr = descriptionStr + "Policy ID : " + event3;
                }
            }
        } else if (eventType == 116 && sensorNumber == 26) {
            String t1 = "";
            String t2 = "";
            String t3 = "";
            t1 = (byte)(event1 & 1) == 1 ? "Policy interface capability : Available" : "Policy interface capability : Not Available";
            t2 = (byte)(event1 & 2) == 2 ? "Monitoring capability : Available" : "Monitoring capability : Not Available";
            t3 = (byte)(event1 & 4) == 4 ? "Power limiting capability : Available" : "Power limiting capability : Not Available";
            descriptionStr = descriptionStr + t1 + "\n" + t2 + "\n" + t3;
        } else if (eventType == 114 && sensorNumber == 27) {
            if ((byte)(event1 & 4) == 4) {
                descriptionStr = descriptionStr + "Policy event : Policy Correction Time Exceeded\n";
            } else {
                descriptionStr = descriptionStr + "Policy event : Threshold exceeded\n";
                descriptionStr = descriptionStr + "Threshold Index : " + (event1 & 0x11) + "\n";
            }
            descriptionStr = descriptionStr + "Policy ID = " + event3 + "\n";
        } else {
            descriptionStr = "undefined";
        }
        String retStr = eventTypeStr + "\n" + descriptionStr;
        return retStr;
    }

    public static String getCompletionCodeString(byte key) {
        Object msg = completionCodeString.get(ByteUtility.byteToHex(key));
        if (msg == null) {
            msg = "Undefined completion code = " + ByteUtility.byteToHex(key) + "h";
        }
        return msg.toString();
    }

    public static void main(String[] args) {
        System.out.println(GlobalDefine.LookupSensorType((byte)-64, (byte)0, (byte)5, (byte)0));
        System.out.println(GlobalDefine.LookupSensorType((byte)-61, (byte)-64, (byte)7, (byte)0));
        System.out.println(GlobalDefine.LookupSensorType((byte)-61, (byte)0, (byte)0, (byte)0));
        System.out.println(GlobalDefine.LookupSensorType((byte)-60, (byte)-64, (byte)1, (byte)0));
        System.out.println(GlobalDefine.LookupSensorType((byte)-64, (byte)2, (byte)-1, (byte)-1));
        System.out.println(GlobalDefine.LookupSensorType((byte)-64, (byte)4, (byte)-1, (byte)-1));
        System.out.println(GlobalDefine.LookupSensorType((byte)-54, (byte)1, (byte)0, (byte)-1));
        System.out.println(GlobalDefine.LookupSensorType((byte)-54, (byte)8, (byte)0, (byte)-1));
        System.out.println(GlobalDefine.LookupSensorType((byte)-53, (byte)8, (byte)0, (byte)-1));
        System.out.println(GlobalDefine.LookupSensorType((byte)-52, (byte)8, (byte)0, (byte)-1));
        System.out.println(GlobalDefine.LookupSensorType((byte)-51, (byte)0, (byte)1, (byte)-1));
        System.out.println(GlobalDefine.LookupSensorType((byte)-21, (byte)-94, (byte)4, (byte)1));
        System.out.println(GlobalDefine.LookupSensorType((byte)-19, (byte)-121, (byte)8, (byte)-1));
        System.out.println(GlobalDefine.LookupSensorType((byte)-63, (byte)-61, (byte)56, (byte)0));
        System.out.println(GlobalDefine.LookupSensorType((byte)-63, (byte)-64, (byte)0, (byte)0));
        System.out.println(GlobalDefine.LookupSensorType((byte)44, (byte)7, (byte)0, (byte)0));
        System.out.println(GlobalDefine.LookupSensorType((byte)13, (byte)8, (byte)0, (byte)0));
        System.out.println(GlobalDefine.LookupSensorType((byte)1, (byte)8, (byte)0, (byte)0));
        System.out.println(GlobalDefine.LookupSensorType((byte)-22, (byte)1, (byte)-1, (byte)-6));
        System.out.println(GlobalDefine.LookupSensorType((byte)-62, (byte)-96, (byte)24, (byte)0));
    }

    public static boolean isDisplayRaw() {
        return SMCIPMITOOL_DEBUG_LEVEL > 0 && !PAUSE_DEBUG;
    }

    public static void createCMM_MIB() {
        for (int i = 0; i < SensorTypeCodeSingleton.SIZE(); ++i) {
            if (!SensorTypeCodeSingleton.E(i, 0).equals("C1") && !SensorTypeCodeSingleton.E(i, 0).equals("C2") && !SensorTypeCodeSingleton.E(i, 0).equals("C3") && !SensorTypeCodeSingleton.E(i, 0).equals("C4")) continue;
            String typeString = "";
            if (SensorTypeCodeSingleton.E(i, 0).equals("C1")) {
                typeString = "Blade";
            } else if (SensorTypeCodeSingleton.E(i, 0).equals("C2")) {
                typeString = "Power Supply";
            } else if (SensorTypeCodeSingleton.E(i, 0).equals("C3")) {
                typeString = "Switch";
            } else if (SensorTypeCodeSingleton.E(i, 0).equals("C4")) {
                typeString = "Infinit Band";
            }
            byte[] specificTrap = new byte[4];
            try {
                specificTrap[0] = (byte)(Integer.parseInt(SensorTypeCodeSingleton.E(i, 1), 16) & 0xF);
                specificTrap[1] = 111;
                specificTrap[2] = (byte)Integer.parseInt(SensorTypeCodeSingleton.E(i, 0), 16);
                specificTrap[3] = (byte)Integer.parseInt(SensorTypeCodeSingleton.E(i, 2), 16);
            }
            catch (NumberFormatException e) {
                continue;
            }
            long number = ByteUtility.fourBytesToUnsignedLongByLSBFirst(specificTrap);
            String mib = "-- CMM " + SensorTypeCodeSingleton.E(i, 4) + " " + SensorTypeCodeSingleton.E(i, 5) + "\r\n";
            mib = mib + "trapOverCMM_0x" + SensorTypeCodeSingleton.E(i, 0) + SensorTypeCodeSingleton.E(i, 1) + SensorTypeCodeSingleton.E(i, 2) + " TRAP-TYPE" + "\r\n";
            mib = mib + "ENTERPRISE petevts\r\n";
            mib = mib + "DESCRIPTION\r\n";
            mib = mib + "\"" + SensorTypeCodeSingleton.E(i, 4) + " " + SensorTypeCodeSingleton.E(i, 5) + "\"" + "\r\n\r\n";
            mib = mib + "--#TYPE       \"" + typeString + "\"" + "\r\n";
            mib = mib + "--#SUMMARY    \"" + SensorTypeCodeSingleton.E(i, 4) + " " + SensorTypeCodeSingleton.E(i, 5) + "\"" + "\r\n";
            mib = mib + "--#ARGUMENTS  {}\n";
            mib = mib + "--#SEVERITY   CRITICAL\r\n\r\n";
            mib = mib + "::=" + number + "\r\n\r\n\r\n";
            System.out.println(mib);
        }
    }

    public static String spaceToDash(String s) {
        return s.replace(' ', '-');
    }

    static {
        completionCodeString.put("0", "Command Completed Normally.");
        completionCodeString.put("C0", "Node Busy. Command could not be processed because command processing resources are temporarily unavailable.");
        completionCodeString.put("C1", "Invalid Command. Used to indicate an unrecognized or unsupported command.");
        completionCodeString.put("C2", "Command invalid for given LUN.");
        completionCodeString.put("C3", "Timeout while processing command. Response unavailable.");
        completionCodeString.put("C4", "Out of space. Command could not be completed because of a lack of storage space required to execute the given command operation.");
        completionCodeString.put("C5", "Reservation Canceled or Invalid Reservation ID.");
        completionCodeString.put("C6", "Request data truncated.");
        completionCodeString.put("C7", "Request data length invalid.");
        completionCodeString.put("C8", "Request data field length limit exceeded.");
        completionCodeString.put("C9", "Parameter out of range. One or more parametders in the data field of the Request are out of range. This is different from \u2018Invalid data field\u2019 (CCh) code in that it indicates that the erroneous field(s) has a contiguous range of possible values.");
        completionCodeString.put("CA", "Cannot return number of requested data bytes.");
        completionCodeString.put("CB", "Requested Sensor, data, or record not present.");
        completionCodeString.put("CC", "Invalid data field in Request");
        completionCodeString.put("CD", "Command illegal for specified sensor or record type.");
        completionCodeString.put("CE", "Command response could not be provided.");
        completionCodeString.put("CF", "Cannot execute duplicated request. This completion code is for devices which cannot return the response that was returned for the original instance of the request. Such devices should provide separate commands that allow the completion status of the original request to be determined. An Event Receiver does not use this completion code, but returns the 00h completion code in the response to (valid) duplicated requests.");
        completionCodeString.put("D0", "Command response could not be provided. SDR Repository in update mode.");
        completionCodeString.put("D1", "Command response could not be provided. Device in firmware update mode.");
        completionCodeString.put("D2", "Command response could not be provided. BMC initialization or initialization agent in progress.");
        completionCodeString.put("D3", "Destination unavailable. Cannot deliver request to selected destination. E.g. this code can be returned if a request message is targeted to SMS, but receive message queue reception is disabled for the particular channel.");
        completionCodeString.put("D4", "Cannot execute command due to insufficient privilege level or other securitybased restriction (e.g. disabled for \u2018firmware firewall\u2019).");
        completionCodeString.put("D5", "Cannot execute command. Command, or request parameter(s), not supported in present state.");
        completionCodeString.put("D6", "Cannot execute command. Parameter is illegal because command sub-function has been disabled or is unavailable (e.g. disabled for \u2018firmware firewall\u2019). ");
    }

    public static enum BootDevice {
        PXE,
        HD_DEFAULT,
        HD_SAFEMODE,
        DIAGNOSTIC_PARTITION,
        CD_DVD,
        BIOS,
        FLOPPY_REMOVABLE_MEDIA,
        USB_KEY,
        USB_HDD,
        USB_FLOPPY,
        USB_CD_DVD,
        UEFI_USB_KEY,
        UEFI_CD_DVD,
        UEFI_HD,
        UEFI_USB_HDD,
        UEFI_USB_CDDVD;

    }
}

