/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;

public class SELInfo {
    private byte SELVersion;
    private int logEntries;
    private int freeSpace;
    private byte[] mostRecentAdditionTimeStamp;
    private byte[] mostRecentEraseTimeStamp;
    private byte operationSupport;
    private byte[] raw;

    public static SELInfo fromRaw(byte[] raw) {
        SELInfo selInfo = new SELInfo();
        if (raw.length != 14) {
            return null;
        }
        selInfo.SELVersion = raw[0];
        selInfo.logEntries = (raw[1] & 0xFF) + ((raw[2] & 0xFF) << 8);
        selInfo.freeSpace = (raw[3] & 0xFF) + ((raw[4] & 0xFF) << 8);
        selInfo.mostRecentAdditionTimeStamp = new byte[4];
        System.arraycopy(raw, 5, selInfo.mostRecentAdditionTimeStamp, 0, 4);
        selInfo.mostRecentEraseTimeStamp = new byte[4];
        System.arraycopy(raw, 9, selInfo.mostRecentEraseTimeStamp, 0, 4);
        selInfo.operationSupport = raw[13];
        selInfo.raw = new byte[14];
        System.arraycopy(raw, 0, selInfo.raw, 0, 14);
        return selInfo;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("SEL Version        = " + ByteUtility.byteToHex(this.SELVersion) + "h \n");
        sb.append("Log Entries        = " + this.logEntries + "\n");
        sb.append("Free Space         = " + this.freeSpace + "\n");
        sb.append("most Add Time      = " + ByteUtility.fourByteToDateFormat2(this.mostRecentAdditionTimeStamp) + "\n");
        sb.append("most Era Time      = " + ByteUtility.fourByteToDateFormat2(this.mostRecentEraseTimeStamp) + "\n");
        sb.append("Operation Support  = " + ByteUtility.byteToHex(this.operationSupport) + "h");
        return sb.toString();
    }

    public void setSELVersion(byte SELVersion) {
        this.SELVersion = SELVersion;
    }

    public byte getSELVersion() {
        return this.SELVersion;
    }

    public String getSELVersionString() {
        return (this.SELVersion & 0xF) + "." + ((this.SELVersion & 0xF0) >> 4);
    }

    public void setLogEntries(int logEntries) {
        this.logEntries = logEntries;
    }

    public void setFreeSpace(int freeSpace) {
        this.freeSpace = freeSpace;
    }

    public void setMostRecentAdditionTimeStamp(byte[] mostRecentAdditionTimeStamp) {
        this.mostRecentAdditionTimeStamp = mostRecentAdditionTimeStamp;
    }

    public void setMostRecentEraseTimeStamp(byte[] mostRecentEraseTimeStamp) {
        this.mostRecentEraseTimeStamp = mostRecentEraseTimeStamp;
    }

    public void setOperationSupport(byte operationSupport) {
        this.operationSupport = operationSupport;
    }

    public void setRaw(byte[] raw) {
        this.raw = raw;
    }

    public int getLogEntries() {
        return this.logEntries;
    }

    public int getFreeSpace() {
        return this.freeSpace;
    }

    public byte[] getMostRecentAdditionTimeStamp() {
        return this.mostRecentAdditionTimeStamp;
    }

    public byte[] getMostRecentEraseTimeStamp() {
        return this.mostRecentEraseTimeStamp;
    }

    public byte getOperationSupport() {
        return this.operationSupport;
    }

    public byte[] getRaw() {
        return this.raw;
    }
}

