/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.task.mbtauto;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.DeviceInfo;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIGlobalCommand;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMIOEMCommand;
import com.supermicro.ipmi.IPMIX9BIOSOEMCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.task.BTaskFactory;
import com.supermicro.ipmi.task.BTaskManager;
import com.supermicro.ipmi.task.BTaskVariable;
import com.supermicro.ipmi.task.flow.TaskTarget;
import com.supermicro.ipmi.task.mbtauto.BatchCommand;
import com.supermicro.ipmi.task.mbtauto.ECOInfo;
import com.supermicro.ipmi.task.mbtauto.ECOInfoList;
import com.supermicro.ipmi.task.mbtauto.MBTConfig;
import com.supermicro.ipmi.task.mbtauto.MBTTaskFlow;
import com.supermicro.ipmi.text.MOut;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.StringTokenizer;

public class InitialTask {
    boolean isDebug = false;
    TaskTarget target;
    MBTConfig mbtConfig;
    ECOInfoList ecoInfoList;
    String bmcMACAddress;
    byte[] bmcGUID;
    String bmcBoardID;
    String bmcVer;
    String bmcProductKey;
    String bmcIP;
    ISessionController sessionController = null;
    IPMIInterfaceConfig ipmiInterfaceConfig = new IPMIInterfaceConfig();
    IPMILanCommand ipmiLanCommand;
    MOut out;

    public InitialTask(String ip, TaskTarget target, ECOInfoList ecoInfoList, MBTConfig mbtConfig) {
        this.bmcIP = ip;
        this.target = target;
        this.ecoInfoList = ecoInfoList;
        this.mbtConfig = mbtConfig;
    }

    public boolean login() throws Exception {
        for (int i = 0; i < this.mbtConfig.ipmiAccounts.size(); ++i) {
            this.ipmiInterfaceConfig.setIp(this.bmcIP);
            this.ipmiInterfaceConfig.setUserName(this.mbtConfig.ipmiAccounts.get((int)i).username);
            this.ipmiInterfaceConfig.setPassword(this.mbtConfig.ipmiAccounts.get((int)i).password);
            this.ipmiInterfaceConfig.setRetry(0);
            this.ipmiInterfaceConfig.setTimeout(10);
            this.ipmiLanCommand = new IPMILanCommand(null);
            try {
                this.sessionController = SessionControllerFactory.createSessionControllerWithAutomaticllyCheckPrivilegeEx(this.ipmiInterfaceConfig, this.ipmiLanCommand);
                return true;
            }
            catch (IPMIException iPMIException) {
                continue;
            }
        }
        return false;
    }

    public void logout() throws Exception {
        this.sessionController.closeSession();
    }

    public void doInitialTask() throws Exception {
        boolean isConnect = this.login();
        if (!isConnect) {
            throw new Exception("IP = " + this.bmcIP + " login failed");
        }
        IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(this.ipmiLanCommand.getIPMIInterface());
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(this.ipmiLanCommand.getIPMIInterface());
        IPMIX9BIOSOEMCommand biosOEMCommand = new IPMIX9BIOSOEMCommand(this.ipmiLanCommand.getIPMIInterface());
        IPMIGlobalCommand ipmiGlobalCommand = new IPMIGlobalCommand(this.ipmiLanCommand.getIPMIInterface());
        if (!this.checkIfSupportBIOSUpdate()) {
            this.logout();
            throw new Exception("OOB is not supported");
        }
        this.bmcMACAddress = this.ipmiLanCommand.getMAC2Ex();
        this.bmcGUID = ipmiMessagingCommand.getSystemGUID();
        byte[] b = ipmiOEMCommand.getBoardModelByte();
        this.bmcBoardID = "" + ByteUtility.byteToHex(b[0]) + ByteUtility.byteToHex(b[1]);
        ECOInfo ecoInfo = this.ecoInfoList.getECOInfo(this.bmcBoardID);
        if (ecoInfo == null) {
            this.logout();
            throw new Exception("IP = " + this.bmcIP + " (" + this.bmcMACAddress + ") (" + this.bmcBoardID + ") is not in ECO list");
        }
        DeviceInfo deviceInfo = ipmiGlobalCommand.getDevice();
        this.bmcVer = "" + deviceInfo.firmwareRevision1 + "." + ByteUtility.byteToHex(deviceInfo.firmwareRevision2);
        Result result = this.getProductKey(this.mbtConfig.productKeyServer, this.mbtConfig.productKeyUsername, this.mbtConfig.productKeyPassword, "1", this.bmcMACAddress, "NA", 1, "MBT Auto");
        if (result.code != 0) {
            throw new Exception("Get Product Key error");
        }
        this.bmcProductKey = result.result;
        this.logout();
        this.target.ip = this.bmcIP;
        this.target.mac = this.bmcMACAddress;
        String flashCommand = "";
        if (IPMIMessagingCommand.isAMIX9GUID(this.bmcGUID)) {
            flashCommand = "flashr";
        } else if (IPMIMessagingCommand.isATENGUID(this.bmcGUID)) {
            flashCommand = "flashh";
        } else if (IPMIMessagingCommand.isATENAspeedGUID(this.bmcGUID) || IPMIMessagingCommand.isMicroBladeCMMGUID(this.bmcGUID) || IPMIMessagingCommand.isMicroBladeNodeGUID(this.bmcGUID) || IPMIMessagingCommand.isATENSuperBladeGUID(this.bmcGUID) || IPMIMessagingCommand.isSAS3_946E90GUID(this.bmcGUID) || IPMIMessagingCommand.isAST2400GUID(this.bmcGUID) || IPMIMessagingCommand.isAST2500GUID(this.bmcGUID) || IPMIMessagingCommand.isP8DTUGUID(this.bmcGUID)) {
            flashCommand = "flasha";
        }
        BTaskVariable bTaskVariable = new BTaskVariable();
        bTaskVariable.put("$IP_ADDRESS", this.bmcIP);
        bTaskVariable.put("$MAC_ADDRESS", this.bmcMACAddress);
        bTaskVariable.put("$BOARD_ID", this.bmcBoardID);
        bTaskVariable.put("$PRODUCT_KEY", this.bmcProductKey);
        bTaskVariable.put("$BIOS_FILE_NAME", ecoInfo.biosFile);
        bTaskVariable.put("$BMC_FILE_NAME", ecoInfo.bmcFile);
        bTaskVariable.put("$BMC_VER_1", this.bmcVer);
        bTaskVariable.put("$BMC_FLASH_CMD", flashCommand);
        bTaskVariable.put("$BMC_ECO_NUMBER", ecoInfo.ecoNumber);
        bTaskVariable.put("$BMC_ECO_NOTE", ecoInfo.note);
        BatchCommand batchCommand = new BatchCommand();
        try {
            batchCommand.load(ecoInfo.script);
        }
        catch (Exception e) {
            throw new Exception("IP = " + this.bmcIP + " (boardID = " + this.bmcBoardID + ") load command " + ecoInfo.script + " error");
        }
        MBTTaskFlow taskflow = BTaskFactory.createMBTTaskFlow(this.bmcIP, this.ipmiInterfaceConfig.getUserName(), this.ipmiInterfaceConfig.getPassword(), batchCommand.toStringArray());
        BTaskManager.getInstance().putBTaskVariable(taskflow.taskID, bTaskVariable);
        BTaskManager.getInstance().execute(taskflow);
        this.target.setTaskID(taskflow.taskID);
    }

    public boolean checkIfSupportBIOSUpdate() {
        IPMIX9BIOSOEMCommand ipmiX9BIOSOEMCommand = new IPMIX9BIOSOEMCommand(this.ipmiLanCommand.getIPMIInterface());
        try {
            return ipmiX9BIOSOEMCommand.checkIfSupportBIOSUpdate();
        }
        catch (IPMIException ex) {
            return false;
        }
    }

    public Result getProductKey(String ip, String username, String password, String productID, String macAddr, String invoice, int requestType, String note) throws Exception {
        Socket s = new Socket(ip, 8801);
        InputStreamReader from_server = new InputStreamReader(s.getInputStream());
        PrintWriter to_server = new PrintWriter(s.getOutputStream());
        char[] buffer = new char[1024];
        String command = "100~" + productID + "~" + username + "~" + password + "~" + macAddr + "~" + requestType + "~" + invoice + "~" + note;
        to_server.print(command + "\n");
        to_server.flush();
        int chars_read = from_server.read(buffer);
        Result r = new Result();
        r.fromRaw(new String(buffer));
        return r;
    }

    class Result {
        public int code;
        public String result;

        Result() {
        }

        public void fromRaw(String data) throws Exception {
            StringTokenizer st = new StringTokenizer(data, "~");
            this.code = Integer.parseInt(st.nextToken());
            this.result = st.nextToken().trim();
        }
    }
}

