/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMIX9BIOSOEMCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.text.Command;
import com.supermicro.ipmi.text.MOut;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;

public class BIOSGetMACsCommand
extends Command {
    String startIP;
    String endIP;
    String netMask;
    String filename;

    public void usage() {
        MOut.G(this).println("This command is used to collect MAC addresses in a IP range");
        MOut.G(this).println("A file will be generated for node product key activation");
    }

    @Override
    public void execute() throws Exception {
        boolean tempFlag;
        if (this.parameters != null) {
            if (this.parameters.length != 4) {
                MOut.G(this).println("parameter error!");
                MOut.G(this).println("");
                this.usage();
                this.statusCode = 147;
                return;
            }
            this.startIP = this.parameters[0];
            this.endIP = this.parameters[1];
            this.netMask = this.parameters[2];
            this.filename = this.parameters[3];
            tempFlag = GlobalDefine.OOB_PROJECT;
            GlobalDefine.OOB_PROJECT = false;
            try {
                this.collectMACForX9BIOSUpdate(this.startIP, this.endIP, this.netMask, this.filename);
            }
            catch (Exception e) {
                this.statusCode = 147;
                MOut.G(this).println(e.getMessage());
                return;
            }
        } else {
            MOut.G(this).println("parameter error!");
            MOut.G(this).println("");
            this.usage();
            this.statusCode = 147;
            return;
        }
        GlobalDefine.OOB_PROJECT = tempFlag;
        this.statusCode = 0;
    }

    public void collectMACForX9BIOSUpdate(String startIP, String endIP, String netMask, String filename) throws Exception {
        ArrayList<String> list = this.allAddress(startIP, endIP, netMask);
        ArrayList<FindDevice> devices = this.getAllPossibleIPMIDevice(list);
        this.findIPMIDevice(devices);
    }

    public void findIPMIDevice(ArrayList<FindDevice> devices) {
        int i;
        MOut.G(this).println("Finding BIOS update available Devices ...");
        for (int i2 = 0; i2 < devices.size(); ++i2) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            devices.get(i2).start();
        }
        if (devices.size() != 0) {
            try {
                Thread.sleep(18000L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        FileWriter outs = null;
        try {
            outs = new FileWriter(this.filename, true);
        }
        catch (IOException ex1) {
            MOut.G(this).println("Create file error");
            return;
        }
        int deviceCount = 0;
        ArrayList<String> cannotLoginDevice = new ArrayList<String>();
        for (i = 0; i < devices.size(); ++i) {
            if (!devices.get((int)i).doneGet) continue;
            IPMIInterfaceConfig aConfig = new IPMIInterfaceConfig();
            aConfig.setIp(devices.get((int)i).ip);
            aConfig.setUserName(this.config.getUserName());
            aConfig.setPassword(this.config.getPassword());
            String mac = this.getMACAddress(aConfig);
            if (mac == null) continue;
            if (mac.equals("CANNOT_LOGIN")) {
                cannotLoginDevice.add(devices.get((int)i).ip);
                continue;
            }
            try {
                outs.write(mac + ";" + devices.get((int)i).ip + "\n");
                MOut.G(this).println(mac + " ; " + devices.get(i).toString());
                ++deviceCount;
                continue;
            }
            catch (IOException ex) {
                System.out.println("error write to file");
            }
        }
        if (deviceCount == 0) {
            MOut.G(this).println("No Device found!");
        } else {
            MOut.G(this).println("" + deviceCount + " device(s) found. " + this.filename + " was created");
        }
        for (i = 0; i < cannotLoginDevice.size(); ++i) {
            MOut.G(this).println((String)cannotLoginDevice.get(i) + " cannot login by " + this.config.getUserName() + "/" + this.config.getPassword());
        }
        try {
            outs.close();
        }
        catch (IOException ex2) {
            MOut.G(this).println("Error to close file");
        }
    }

    public ArrayList<FindDevice> getAllPossibleIPMIDevice(ArrayList<String> list) {
        ArrayList<FindDevice> devices = new ArrayList<FindDevice>();
        for (int i = 0; i < list.size(); ++i) {
            FindDevice device = new FindDevice(list.get(i), 8, 2);
            devices.add(device);
        }
        return devices;
    }

    public ArrayList<String> allAddress(String startIP, String endIP, String netmask) throws Exception {
        InetAddress maskInet;
        InetAddress endInet;
        InetAddress startInet;
        if (!IPMILanCommand.isIPAddress(startIP)) {
            throw new Exception("Start IP format error!");
        }
        if (!IPMILanCommand.isIPAddress(endIP)) {
            throw new Exception("End IP format error!");
        }
        if (!IPMILanCommand.isIPAddress(netmask)) {
            throw new Exception("NetMask format error!");
        }
        ArrayList<String> list = new ArrayList<String>();
        try {
            startInet = InetAddress.getByName(startIP);
        }
        catch (Exception e) {
            throw new Exception("Start IP invalid!");
        }
        try {
            endInet = InetAddress.getByName(endIP);
        }
        catch (Exception e) {
            throw new Exception("End IP invalid!");
        }
        try {
            maskInet = InetAddress.getByName(netmask);
        }
        catch (Exception e) {
            throw new Exception("NetMask invalid!");
        }
        if ((startInet.hashCode() & maskInet.hashCode()) != (endInet.hashCode() & maskInet.hashCode())) {
            throw new Exception("Start IP and End IP must locate within same network segment");
        }
        for (int i = startInet.hashCode(); i <= endInet.hashCode(); ++i) {
            list.add(this.intToIP(i));
        }
        return list;
    }

    public String intToIP(int intsrc) {
        String x = new String();
        x = "" + ((byte)(intsrc >> 24) & 0xFF);
        x = x + "." + ((byte)(intsrc >> 16) & 0xFF);
        x = x + "." + ((byte)(intsrc >> 8) & 0xFF);
        x = x + "." + ((byte)intsrc & 0xFF);
        return x;
    }

    public String getMACAddress(IPMIInterfaceConfig config) {
        String mac = null;
        Boolean ifSupportBIOSUpdate = false;
        config.setPrivilege((byte)4);
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(config, ipmiLanCommand);
        if (sessionController == null) {
            return "CANNOT_LOGIN";
        }
        IPMIX9BIOSOEMCommand ipmiX9BIOSOEMCommand = new IPMIX9BIOSOEMCommand(ipmiLanCommand.getIPMIInterface());
        try {
            mac = ipmiLanCommand.getMAC2Ex();
            ifSupportBIOSUpdate = ipmiX9BIOSOEMCommand.checkIfSupportBIOSUpdate();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        sessionController.closeSession();
        if (ifSupportBIOSUpdate.booleanValue()) {
            return mac;
        }
        return null;
    }

    class FindDevice
    extends Thread {
        public String ip;
        public String type;
        boolean doneGet = false;
        int timeout;
        int retry;
        IPMIInterfaceConfig config;

        public FindDevice(String ip) {
            this(ip, 5, 1);
        }

        public FindDevice(String ip, int timeout, int retry) {
            this.ip = ip;
            this.timeout = timeout;
            this.retry = retry;
            this.config = new IPMIInterfaceConfig();
            this.config.setIp(ip);
            this.config.setTimeout(timeout);
            this.config.setRetry(retry);
        }

        @Override
        public void run() {
            byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.ip, this.timeout, this.retry);
            if (guid != null) {
                this.type = IPMIMessagingCommand.getFWTypeByGUID(guid);
                this.doneGet = true;
            }
        }

        @Override
        public String toString() {
            String format = "  %-20s \t %-20s";
            String retStr = String.format(format, this.ip, this.type);
            return retStr;
        }
    }
}

