/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMB;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.blade.BladeEntity;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import com.supermicro.ipmi.text.deploy.DeployManager;
import com.supermicro.ipmi.text.deploy.DeployTarget;
import java.io.File;

public class DeployAllCommand
extends SuperBladeCommand {
    String isoFilename = "";

    @Override
    public boolean preValidate() {
        if (this.parameters == null) {
            MOut.G(this).println("ISO filename needed");
            return false;
        }
        this.isoFilename = this.parameters[0];
        File file = new File(this.isoFilename);
        if (!file.isFile()) {
            MOut.G(this).println("ISO filename is not exist");
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        if (!this.isMaster) {
            this.printSlaveCMMUnavailableMessage();
            this.statusCode = 150;
            return;
        }
        MOut.G(this).println("Collecting information for all blades ...");
        BladeSystemEntity bladeSystem = new BladeSystemEntity(this.config);
        bladeSystem.setEnableAllQuery(false);
        bladeSystem.setIsQueryBladeEntity(true);
        bladeSystem.getData();
        if (!bladeSystem.isLoginSuccessful) {
            MOut.G(this).println("Login error!");
            this.statusCode = 146;
            return;
        }
        for (int i = 0; i < bladeSystem.getBlades().length; ++i) {
            String ip = null;
            BladeEntity bladeEntity = bladeSystem.getBlades()[i];
            if (bladeEntity.getPresent() == 0) continue;
            if (bladeEntity.isSimCardDetectPin()) {
                this.ipmiCMMOEMCommand.setEnabledNormalFunction(false);
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                ip = this.getSIMBLIP(i);
                this.ipmiCMMOEMCommand.setEnabledNormalFunction(true);
                if (ip != null) {
                    MOut.G(this).print("Blade " + (i + 1) + ", IP =" + ip);
                }
            }
            if (ip == null) continue;
            String username = this.config.getUserName();
            String password = this.config.getPassword();
            IPMIInterfaceConfig lanConfig = new IPMIInterfaceConfig();
            lanConfig.setUserName(username);
            lanConfig.setPassword(password);
            lanConfig.setIp(ip);
            if (DeployManager.getInstance().getDeployTargets().containsKey(ip)) {
                MOut.G(this).println(", The deploy task of IP:" + ip + " already running");
                continue;
            }
            try {
                DeployTarget dTarget = DeployManager.getInstance().createDeployTarget(lanConfig, "Blade " + (i + 1));
                dTarget.getDeployTask().setIsoFilename(this.isoFilename);
                Thread t = new Thread(dTarget.deployTask);
                t.start();
                MOut.G(this).println(", Task started.");
                continue;
            }
            catch (IPMIException ex) {
                MOut.G(this).println(", Unable to start Task (" + ex.getMessage() + ")");
            }
        }
        this.ipmiCMMOEMCommand.setEnabledNormalFunction(true);
        if (DeployManager.getInstance().getDeployTargets().size() != 0) {
            MOut.G(this).println("Using \"deploy status\" command to check deploy status");
        }
    }

    public String getSIMBLIP(int i) {
        String ip;
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
        ipmiLanCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        IPMB ipmb = new IPMB(ipmiLanCommand.getIPMIInterface());
        ipmb.setIpmbType(1);
        ipmiLanCommand.setIPMIInterface(ipmb);
        ipmb.setChannel((byte)(i + 1));
        if (this.sessionController != null && (ip = ipmiLanCommand.getIP()) != null) {
            return ip;
        }
        return null;
    }
}

