/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIOEMWebSettingCommand;
import com.supermicro.ipmi.text.IPMIX10OEMWebSettingAbstractCommand;
import com.supermicro.ipmi.text.MOut;
import java.nio.ByteBuffer;

public class IPMIOEMADAddCommand
extends IPMIX10OEMWebSettingAbstractCommand {
    private byte groupID;
    private String groupName;
    private String groupDomain;
    private byte privilege;

    @Override
    public boolean preValidate() {
        String usage = "Usage: ipmi oem x10cfg ad add <id> <group name> <group domain> <network privilege> \n\nFor network privilege level:\nAdministrator level : 4\nOperator level      : 3\nUser level          : 2\nNo access           : 15";
        if (this.parameters == null || this.parameters.length != 4) {
            MOut.G(this).println(usage);
            return false;
        }
        try {
            this.groupID = Byte.parseByte(this.parameters[0]);
        }
        catch (NumberFormatException ex) {
            MOut.G(this).println("group id should be number");
            MOut.G(this).println(usage);
            return false;
        }
        if (this.groupID < 1 || this.groupID > 5) {
            MOut.G(this).println("group id should be 1-5");
            MOut.G(this).println(usage);
            return false;
        }
        this.groupName = this.parameters[1];
        if (this.groupName.length() > 20) {
            MOut.G(this).println("group name should less then 20 characters");
            MOut.G(this).println(usage);
            return false;
        }
        this.groupDomain = this.parameters[2];
        if (this.groupDomain.length() > 20) {
            MOut.G(this).println("group domain should less then 20 characters");
            MOut.G(this).println(usage);
            return false;
        }
        try {
            this.privilege = Byte.parseByte(this.parameters[3]);
        }
        catch (NumberFormatException ex) {
            MOut.G(this).println("network privilege should be number");
            MOut.G(this).println(usage);
            return false;
        }
        if (this.privilege < 1 || this.privilege > 4) {
            MOut.G(this).println("Network Privilege level error");
            MOut.G(this).println("Administrator level : 4");
            MOut.G(this).println("operator level      : 3");
            MOut.G(this).println("user level          : 2");
            MOut.G(this).println("No access           : 15");
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        if (!this.isX10CFGSupported()) {
            MOut.G(this).println("This command supports X10 platform only ");
            this.statusCode = 153;
            return;
        }
        if (this.checkIfSWProductKeyNotActivated()) {
            return;
        }
        IPMIOEMWebSettingCommand ipmiOEMWebSettingCommand = new IPMIOEMWebSettingCommand(null);
        ipmiOEMWebSettingCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        ByteBuffer target = ByteBuffer.allocate(2);
        this.groupID = (byte)(this.groupID - 1);
        target.put(this.groupID);
        target.put(this.privilege);
        if (!ipmiOEMWebSettingCommand.setActiveDirectory((byte)3, target.array())) {
            MOut.G(this).println("Set network privilege failed");
            this.statusCode = 149;
            return;
        }
        target = ByteBuffer.allocate(this.groupName.length() + 2);
        target.put(this.groupID);
        target.put(this.groupName.getBytes());
        target.put((byte)0);
        if (!ipmiOEMWebSettingCommand.setActiveDirectory((byte)4, target.array())) {
            MOut.G(this).println("Set group name failed");
            this.statusCode = 149;
            return;
        }
        target = ByteBuffer.allocate(this.groupDomain.length() + 2);
        target.put(this.groupID);
        target.put(this.groupDomain.getBytes());
        target.put((byte)0);
        if (!ipmiOEMWebSettingCommand.setActiveDirectory((byte)5, target.array())) {
            MOut.G(this).println("Set group domain failed");
            this.statusCode = 149;
            return;
        }
        MOut.G(this).println("Done");
        this.statusCode = 0;
    }
}

