/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMITASCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class IPMITASPeriodCommand
extends SuperBladeCommand {
    @Override
    public void runCommand() throws Exception {
        IPMITASCommand ipmiTasCommand = new IPMITASCommand(null);
        ipmiTasCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        int period = 0;
        byte[] key = IPMITASCommand.getModifiedMacAsKey();
        if (this.parameters != null && this.parameters.length == 1) {
            if (ipmiTasCommand.isFlagAvailable()) {
                try {
                    period = Integer.parseInt(this.parameters[0]);
                }
                catch (NumberFormatException e) {
                    MOut.G(this).println("Parameter out of range!");
                    return;
                }
                if (period >= 5 && period <= 60) {
                    boolean result = ipmiTasCommand.setTasPeriodbyKey(key, period);
                    if (result) {
                        byte[] response;
                        int i = 0;
                        while ((response = ipmiTasCommand.getCommandResponse()) == null) {
                            Thread.sleep(1000L);
                            if (++i < 10) continue;
                        }
                        if (response == null) {
                            MOut.G(this).println("Command timeOut, please try again.");
                            this.statusCode = 149;
                            return;
                        }
                        if (IPMITASCommand.compareKeyFromResponse(key, response)) {
                            MOut.G(this).println("Done");
                            this.statusCode = 0;
                        } else {
                            MOut.G(this).println("Command fail, please try again.");
                            this.statusCode = 149;
                        }
                    } else {
                        MOut.G(this).println("Failed");
                        this.statusCode = 149;
                    }
                } else {
                    MOut.G(this).println("Parameter out of range!");
                    this.statusCode = 147;
                }
            } else {
                MOut.G(this).println("TAS command area has been occupied, please resend the command later.");
                this.statusCode = 0;
            }
        } else {
            MOut.G(this).println("Parameter error!");
            this.statusCode = 147;
        }
    }
}

