/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.DeviceInfo;
import com.supermicro.ipmi.IPMIGlobalCommand;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMIOEMCommand;
import com.supermicro.ipmi.IPMIX9BIOSOEMCommand;
import com.supermicro.ipmi.task.BTaskManager;
import com.supermicro.ipmi.task.BTaskVariable;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class MBTOEMCommand
extends SuperBladeCommand {
    String taskID = "";
    public static final int BMC1 = 0;
    public static final int BMC2 = 1;
    public static final int BIOS1 = 2;
    public static final int BIOS2 = 3;
    public static final int NO_COMMAND = 99;
    private int subCommand = -1;

    public void printUsage() {
        MOut.G(this).println("Usage: mbt oem $TASKID <option>");
        MOut.G(this).println("Available commands: bmc1,bmc2,bios1,bios2");
        MOut.G(this).println("   bmc1:  record BMC version (before update)");
        MOut.G(this).println("   bmc2:  record BMC version (after update)");
        MOut.G(this).println("   bios1: record BIOS version (before update)");
        MOut.G(this).println("   bios2: record BIOS version (after update)");
    }

    @Override
    public boolean preValidate() {
        boolean passValidate = false;
        if (this.parameters == null || this.parameters.length < 2) {
            this.printUsage();
            return false;
        }
        this.taskID = this.parameters[0];
        if (this.parameters != null) {
            if (this.parameters[1].equalsIgnoreCase("bmc1")) {
                this.subCommand = 0;
                passValidate = true;
            } else if (this.parameters[1].equalsIgnoreCase("bmc2")) {
                this.subCommand = 1;
                passValidate = true;
            } else if (this.parameters[1].equalsIgnoreCase("bios1")) {
                this.subCommand = 2;
                passValidate = true;
            } else if (this.parameters[1].equalsIgnoreCase("bios2")) {
                this.subCommand = 3;
                passValidate = true;
            }
        } else {
            this.subCommand = 99;
            passValidate = false;
        }
        if (!passValidate) {
            this.printUsage();
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        IPMIX9BIOSOEMCommand biosOEMCommand = new IPMIX9BIOSOEMCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        IPMIGlobalCommand ipmiGlobalCommand = new IPMIGlobalCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        BTaskVariable bTaskVariable = BTaskManager.getInstance().getBTaskVariable(this.taskID);
        if (bTaskVariable == null) {
            MOut.G(this).println("TaskID(" + this.taskID + ") not found");
            this.statusCode = 147;
            return;
        }
        switch (this.subCommand) {
            case 0: {
                DeviceInfo deviceInfo1 = ipmiGlobalCommand.getDevice();
                String bmcVer1 = "" + deviceInfo1.firmwareRevision1 + "." + ByteUtility.byteToHex(deviceInfo1.firmwareRevision2);
                MOut.G(this).println(bmcVer1);
                bTaskVariable.put("$BMC_VER_1", bmcVer1);
                break;
            }
            case 1: {
                DeviceInfo deviceInfo2 = ipmiGlobalCommand.getDevice();
                String bmcVer2 = "" + deviceInfo2.firmwareRevision1 + "." + ByteUtility.byteToHex(deviceInfo2.firmwareRevision2);
                MOut.G(this).println(bmcVer2);
                bTaskVariable.put("$BMC_VER_2", bmcVer2);
                break;
            }
            case 2: {
                IPMIX9BIOSOEMCommand.BIOSInfo biosInfo1 = biosOEMCommand.getBIOSInfo(0x1000000);
                MOut.G(this).println(biosInfo1.toStringFromBMC().trim());
                bTaskVariable.put("$BIOS_VER_1", biosInfo1.toStringFromBMC().trim());
                break;
            }
            case 3: {
                IPMIX9BIOSOEMCommand.BIOSInfo biosInfo2 = biosOEMCommand.getBIOSInfo(0x1000000);
                MOut.G(this).println(biosInfo2.toStringFromBMC().trim());
                bTaskVariable.put("$BIOS_VER_2", biosInfo2.toStringFromBMC().trim());
                break;
            }
        }
        this.statusCode = 0;
    }
}

