/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIMicroBladeOEMCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.microblade.PowerSupplyInfo;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.MicroBladeCommand;

public class MicroBladePSUCommand
extends MicroBladeCommand {
    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void execute() throws Exception {
        if (!this.validateForCMM()) {
            this.statusCode = 153;
            return;
        }
        IPMIMicroBladeOEMCommand ipmiMicroBladeOEMCommand = new IPMIMicroBladeOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.config, ipmiMicroBladeOEMCommand);
        if (sessionController == null) {
            this.statusCode = 145;
            return;
        }
        if (this.getParameters() != null) {
            if (this.getParameters().length != 1) {
                MOut.G(this).println("[psu index] is required");
                this.statusCode = 147;
                sessionController.closeSession();
                return;
            }
            String psuIndex = this.getParameters()[0];
            byte pIndex = (byte)PowerSupplyInfo.getIndex(psuIndex);
            if (pIndex < 0) {
                MOut.G(this).println("The PSU index must be A1-A4 or B1-B4");
                this.statusCode = 147;
                sessionController.closeSession();
                return;
            }
            PowerSupplyInfo powerSupplyInfo = ipmiMicroBladeOEMCommand.getPowerSupply(pIndex, (byte)1);
            if (!powerSupplyInfo.isPresent()) {
                MOut.G(this).println("PSU " + psuIndex + " is not presented");
                this.statusCode = 151;
                sessionController.closeSession();
                return;
            }
            MOut.G(this).print(powerSupplyInfo.toFormatedHeader());
            MOut.G(this).println(powerSupplyInfo.toFormatedString());
        } else {
            for (int i = 0; i < 8; ++i) {
                PowerSupplyInfo powerSupplyInfo = ipmiMicroBladeOEMCommand.getPowerSupply((byte)i, (byte)1);
                if (powerSupplyInfo.isPresent()) {
                    MOut.G(this).print(powerSupplyInfo.toFormatedHeader());
                    MOut.G(this).println(powerSupplyInfo.toFormatedString());
                    continue;
                }
                MOut.G(this).println("PSU " + PowerSupplyInfo.getIndex(i) + " is not presented");
            }
        }
        sessionController.closeSession();
        this.statusCode = 0;
    }
}

