/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.ConfigAccessor;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMIOEMPortServiceCommand;
import com.supermicro.ipmi.lic.SWKeyExpiredException;
import com.supermicro.ipmi.lic.SWLicenseAdapter;
import com.supermicro.ipmi.stunnel.StunnelUtility;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class RemoteScreenCaptureIKVMCommand
extends SuperBladeCommand {
    @Override
    public void runCommand() throws Exception {
        if (!this.isATENKVMSupported()) {
            this.printUnavailableMessage();
            return;
        }
        this.closeSessionIfExist();
        boolean isPassSWKey = false;
        try {
            if (SWLicenseAdapter.isSWFRUSupported(this.config) && SWLicenseAdapter.check_SFT_SUM_LIC_ProductKey(this.config)) {
                isPassSWKey = true;
            }
        }
        catch (SWKeyExpiredException e) {
            MOut.G(this).println("Node product key is expired");
            this.statusCode = 155;
            return;
        }
        this.createSession();
        if (!isPassSWKey && this.checkIfSWProductKeyNotActivated()) {
            MOut.G(this).println("The Node product key needs to be activated for this device");
            this.statusCode = 153;
            return;
        }
        String jarDir = RemoteScreenCaptureIKVMCommand.getJarPath(this.getClass()) + File.separator;
        File f = new File(jarDir + "sc.jar");
        if (!f.exists()) {
            MOut.G(this).println("Cannot find sc.jar");
            this.statusCode = 149;
            return;
        }
        String params = "";
        if (this.getParameters() != null) {
            for (int i = 0; i < this.getParameters().length; ++i) {
                params = params + " " + this.getParameters()[i];
            }
        }
        IPMIOEMPortServiceCommand ipmiOEMPortServiceCommand = new IPMIOEMPortServiceCommand(null);
        ipmiOEMPortServiceCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        boolean isStunnelSupport = ipmiOEMPortServiceCommand.checkStunnelSupport();
        boolean isIPv6 = false;
        ConfigAccessor ca = new ConfigAccessor(".", "SMCIPMITool.properties");
        if (ca.getProperty("bmc_security") == null) {
            ca.setProperty("bmc_security", "on");
        }
        String isUseStunnel = ca.getProperty("bmc_security");
        String ip = this.config.getIp();
        String token = "--token";
        if ("on".equals(isUseStunnel) && isStunnelSupport) {
            String kvmPort = "3520";
            boolean isDynamicPort = ipmiOEMPortServiceCommand.isDynamicStunnelPort();
            if (isDynamicPort) {
                try {
                    kvmPort = String.valueOf(ipmiOEMPortServiceCommand.getPort((byte)2));
                }
                catch (IPMIException e) {
                    kvmPort = "3520";
                }
            }
            MOut.G(this).println("This device support stunnel.");
            String OS = StunnelUtility.checkOS();
            String localIP = "127.0.0.1";
            isIPv6 = StunnelUtility.isIPv6(ip);
            if (isIPv6) {
                localIP = "::1";
            }
            if (OS.indexOf("Windows") == -1 && (localIP = StunnelUtility.getFirstNonLoopbackAddress(!isIPv6, isIPv6).getHostAddress()) == null) {
                localIP = isIPv6 ? "::1" : "127.0.0.1";
            }
            try {
                String port = StunnelUtility.configAndStartStunnel(ip, localIP, "rsc", kvmPort);
                token = token + RemoteScreenCaptureIKVMCommand.getT(localIP);
                this.startRemoteScreenCapture(jarDir, localIP, port, this.config.getUserName(), this.config.getPassword(), params, token);
            }
            catch (Exception e) {
                MOut.G(this).println("Config stunnel or start stunnel fail" + e);
            }
        } else {
            token = token + RemoteScreenCaptureIKVMCommand.getT(this.config.getIp());
            this.startRemoteScreenCapture(jarDir, ip, this.config.getUserName(), this.config.getPassword(), params, token);
        }
    }

    public void startRemoteScreenCapture(String jarDir, String ip, String id, String pw, String params, String token) {
        File jre = new File("jre");
        String execString = jre.isDirectory() ? (System.getProperty("os.name").indexOf("Windows") >= 0 ? ".\\jre\\bin\\java -Djava.library.path=" + jarDir + " -jar " + jarDir + "sc.jar " + ip + " " + id + " " + pw + " " + params + " " + token : "./jre/bin/java -Djava.library.path=" + jarDir + " -jar " + jarDir + "sc.jar " + ip + " " + id + " " + pw + " " + params + " " + token) : "java -Djava.library.path=" + jarDir + " -jar " + jarDir + "sc.jar " + ip + " " + id + " " + pw + " " + params + " " + token;
        try {
            Process p = Runtime.getRuntime().exec(execString);
            InputStream stdin = p.getInputStream();
            InputStreamReader isr = new InputStreamReader(stdin);
            BufferedReader br = new BufferedReader(isr);
            InputStream stderr = p.getErrorStream();
            InputStreamReader isrerr = new InputStreamReader(stderr);
            BufferedReader brerr = new BufferedReader(isrerr);
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.indexOf("Buf") != -1 || line.indexOf("singal") != -1) continue;
                MOut.G(this).println(line);
            }
            while ((line = brerr.readLine()) != null) {
                if (line.indexOf("XOpenDisplay") == -1) continue;
                MOut.G(this).println("If you are running rsc command via ssh, please have following setting");
                MOut.G(this).println("export DISPLAY=:0.0");
                this.statusCode = 149;
                return;
            }
            p.waitFor();
            this.statusCode = p.exitValue();
        }
        catch (IOException ex) {
            MOut.G(this).println(" Failed");
            this.statusCode = 149;
            return;
        }
        catch (Exception e) {
            MOut.G(this).println(" Failed " + e);
            this.statusCode = 149;
            return;
        }
    }

    public void startRemoteScreenCapture(String jarDir, String ip, String port, String id, String pw, String params, String token) {
        File jre = new File("jre");
        String execString = jre.isDirectory() ? (System.getProperty("os.name").indexOf("Windows") >= 0 ? ".\\jre\\bin\\java -Djava.library.path=" + jarDir + " -jar " + jarDir + "sc.jar " + ip + " " + id + " " + pw + " " + params + " " + token + " " + "--port" + port : "./jre/bin/java -Djava.library.path=" + jarDir + " -jar " + jarDir + "sc.jar " + ip + " " + id + " " + pw + " " + params + " " + token + " " + "--port" + port) : "java -Djava.library.path=" + jarDir + " -jar " + jarDir + "sc.jar " + ip + " " + id + " " + pw + " " + params + " " + token + " " + "--port" + port;
        try {
            Process p = Runtime.getRuntime().exec(execString);
            InputStream stdin = p.getInputStream();
            InputStreamReader isr = new InputStreamReader(stdin);
            BufferedReader br = new BufferedReader(isr);
            InputStream stderr = p.getErrorStream();
            InputStreamReader isrerr = new InputStreamReader(stderr);
            BufferedReader brerr = new BufferedReader(isrerr);
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.indexOf("Buf") != -1 || line.indexOf("singal") != -1) continue;
                if (line.indexOf("A fatal error has been detected") > -1 || line.indexOf("Failed to write core dump") > -1) {
                    MOut.G(this).println("iKVM No Signal");
                    break;
                }
                if (line.indexOf("#") > -1) continue;
                MOut.G(this).println(line);
            }
            while ((line = brerr.readLine()) != null) {
                if (line.indexOf("XOpenDisplay") != -1) {
                    MOut.G(this).println("If you are running rsc command via ssh, please have following setting");
                    MOut.G(this).println("export DISPLAY=:0.0");
                    this.statusCode = 149;
                    return;
                }
                if (line.indexOf("Administrator") <= -1) continue;
                MOut.G(this).println(line);
                return;
            }
            p.waitFor();
            this.statusCode = p.exitValue();
        }
        catch (IOException ex) {
            MOut.G(this).println(" Failed");
            this.statusCode = 149;
            return;
        }
        catch (Exception e) {
            MOut.G(this).println(" Failed " + e);
            this.statusCode = 149;
            return;
        }
    }

    public void printUnavailableMessage() {
        MOut.G(this).println("This function is unavailable for this device.");
    }

    public boolean isATENKVMSupported() {
        boolean result = false;
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (guid == null) {
            result = false;
        } else if (IPMIMessagingCommand.isATENGUID(guid) || IPMIMessagingCommand.isATENAspeedGUID(guid) || IPMIMessagingCommand.isMicroBladeNodeGUID(guid) || IPMIMessagingCommand.isATENSuperBladeGUID(guid) || IPMIMessagingCommand.isSAS3_946E90GUID(guid) || IPMIMessagingCommand.isAST2400GUID(guid) || IPMIMessagingCommand.isAST2500GUID(guid) || IPMIMessagingCommand.isP8DTUGUID(guid)) {
            result = true;
        }
        return result;
    }

    public static String getT(String ip) {
        byte[] result = null;
        Date date = Calendar.getInstance().getTime();
        SimpleDateFormat f = new SimpleDateFormat("yyyyMMdd");
        String dateShortString = f.format(date);
        byte[] key = dateShortString.getBytes();
        byte[] plainText = ip.getBytes();
        try {
            Mac hmacMD5 = Mac.getInstance("HmacMD5");
            SecretKeySpec sks = new SecretKeySpec(key, "HmacMD5");
            hmacMD5.init(sks);
            result = hmacMD5.doFinal(plainText);
        }
        catch (IllegalStateException ex) {
        }
        catch (InvalidKeyException ex) {
        }
        catch (NoSuchAlgorithmException ex) {
            // empty catch block
        }
        return ByteUtility.bytesToHexNoSpace(result);
    }
}

