/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ConfigAccessor;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIOEMCommand;
import com.supermicro.ipmi.IPMIOEMLocCommand;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.loc.TagLocSDR;
import com.supermicro.ipmi.task.BTaskManager;
import com.supermicro.ipmi.text.ChangeHostCommand;
import com.supermicro.ipmi.text.Command;
import com.supermicro.ipmi.text.CommandIncompleteException;
import com.supermicro.ipmi.text.FilterProcessor;
import com.supermicro.ipmi.text.HostCenter;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.Parser;
import com.supermicro.ipmi.text.StatusPrompt;
import com.supermicro.ipmi.text.SuperBladeCommand;
import com.supermicro.ipmi.text.SuperBladeTool;
import com.supermicro.ipmi.trap.Receiver;
import com.supermicro.ipmi.trap.Trap;
import com.supermicro.ipmi.trap.TrapReceiverListener;
import com.supermicro.ipmi.util.HTMLUtils;
import com.supermicro.ipmi.util.ImageFrame;
import com.supermicro.ipmi.util.OpenURI;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jline.Completor;
import jline.ConsoleReader;
import jline.History;

public class ShellCommand
extends SuperBladeCommand
implements TrapReceiverListener {
    StatusPrompt statusPrompt;
    Calendar startTime;
    Parser parser;
    ArrayList commandHistory = new ArrayList();
    int commandHistoryIndex = 0;
    boolean isShowPrompt = true;
    ConsoleReader reader = null;

    public ShellCommand() {
        this.startTime = Calendar.getInstance();
        this.statusPrompt = StatusPrompt.getInstance();
        this.statusPrompt.loadProperties();
        ConfigAccessor ca = new ConfigAccessor(".", "SMCIPMITool.properties");
        String temp = ca.getProperty("no_prompt");
        this.isShowPrompt = !"on".equals(temp);
        temp = ca.getProperty("timeout");
        if (temp != null) {
            GlobalDefine.timeout = Integer.parseInt(temp);
        }
        if ((temp = ca.getProperty("retry")) != null) {
            GlobalDefine.retryCount = Integer.parseInt(temp);
        }
    }

    public Parser getParser() {
        return this.parser;
    }

    @Override
    public void runCommand() {
    }

    public void startTrapReceiver() {
        ConfigAccessor ca = new ConfigAccessor(".", "SMCIPMITool.properties");
        String isTrap = ca.getProperty("trap");
        Receiver.getInstance().addTrapReceiverListener(this);
        if ("on".equalsIgnoreCase(isTrap)) {
            boolean result = Receiver.getInstance().startReceiver();
            if (result) {
                MOut.G(this.parser).println("Trap Receiver Started");
            } else {
                MOut.G(this.parser).println("Start Trap Receiver failed");
            }
        }
    }

    @Override
    public void action(Trap trap) {
        MOut.G(this.parser).println("");
        this.printPrompt();
        if (Receiver.getInstance().getTrapCollector().getTraps().size() == 1) {
            MOut.G(this.parser).print("Info: Use \"trap\" command for detail.");
        }
    }

    public String trapStatusForPrompt() {
        ArrayList traps = Receiver.getInstance().getTrapCollector().getTraps();
        if (traps.size() == 0) {
            return "";
        }
        return " [!Trap(" + traps.size() + ")]";
    }

    @Override
    public void execute() throws Exception {
        FilterProcessor fp = FilterProcessor.getInstance();
        SuperBladeTool.ver();
        MOut.G(this.parser).println("Press Ctrl+D or \"exit\" to exit");
        MOut.G(this.parser).println("Press \"?\" or \"help\" for help");
        MOut.G(this.parser).println("Press TAB for command completion");
        MOut.G(this.parser).println("Press UP and DOWN key for command history");
        this.startTrapReceiver();
        HostCenter.getInstance().addHost(this.config);
        this.newParser();
        try {
            this.reader = new ConsoleReader();
            this.reader.addCompletor((Completor)this.parser);
            this.reader.setBellEnabled(false);
            this.reader.addTriggeredAction('<', new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    IPMIInterfaceConfig copyConfig = HostCenter.getInstance().PreviousHost();
                    if (copyConfig == null) {
                        return;
                    }
                    if (!ChangeHostCommand.checkIfConnectable(copyConfig.getIp())) {
                        MOut.G(ShellCommand.this.parser).println("");
                        MOut.G(ShellCommand.this.parser).println("Cannot connect to " + copyConfig.getIp());
                        MOut.G(ShellCommand.this.parser).print(ShellCommand.this.getPrompt());
                        return;
                    }
                    MOut.G(ShellCommand.this.parser).println("");
                    ShellCommand.this.config.setIp(copyConfig.getIp());
                    ShellCommand.this.config.setUserName(copyConfig.getUserName());
                    ShellCommand.this.config.setPassword(copyConfig.getPassword());
                    MOut.G(ShellCommand.this.parser).print(ShellCommand.this.getPrompt());
                }
            });
            this.reader.addTriggeredAction('>', new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    IPMIInterfaceConfig copyConfig = HostCenter.getInstance().nextHost();
                    if (copyConfig == null) {
                        return;
                    }
                    if (!ChangeHostCommand.checkIfConnectable(copyConfig.getIp())) {
                        MOut.G(ShellCommand.this.parser).println("");
                        MOut.G(ShellCommand.this.parser).println("Cannot connect to " + copyConfig.getIp());
                        MOut.G(ShellCommand.this.parser).print(ShellCommand.this.getPrompt());
                        return;
                    }
                    MOut.G(ShellCommand.this.parser).println("");
                    ShellCommand.this.config.setIp(copyConfig.getIp());
                    ShellCommand.this.config.setUserName(copyConfig.getUserName());
                    ShellCommand.this.config.setPassword(copyConfig.getPassword());
                    MOut.G(ShellCommand.this.parser).print(ShellCommand.this.getPrompt());
                }
            });
            this.reader.addTriggeredAction('!', new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MOut.G(ShellCommand.this.parser).println("");
                    MOut.G(ShellCommand.this.parser).println(ShellCommand.this.getTagLoc() + "\n");
                    MOut.G(ShellCommand.this.parser).print(ShellCommand.this.getPrompt());
                }
            });
            this.reader.addTriggeredAction('#', new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MOut.G(ShellCommand.this.parser).println("");
                    MOut.G(ShellCommand.this.parser).println(BTaskManager.getInstance().getTaskStatusDisplay());
                    MOut.G(ShellCommand.this.parser).print(ShellCommand.this.getPrompt());
                }
            });
            this.setCommandHistory(this.reader);
        }
        catch (Exception e) {
            MOut.G(this.parser).println("Create ConsoleReader fail " + e.toString());
            throw e;
        }
        while (true) {
            String line = null;
            try {
                line = this.reader.readLine(this.getPrompt());
                MOut.G((Parser)this.parser).isPrintToScreen = false;
                MOut.G(this.parser).println(line);
                MOut.G((Parser)this.parser).isPrintToScreen = true;
            }
            catch (IOException ex1) {
                // empty catch block
            }
            if (line == null || line.trim().equalsIgnoreCase("exit")) {
                if (BTaskManager.getInstance().isThereTaskStillRunning()) {
                    MOut.G(this.parser).println("Task(s) are still running. Please wait task(s) end then exit");
                    continue;
                }
                if (Receiver.getInstance().isStart) {
                    Receiver.getInstance().stopReceiver();
                }
                break;
            }
            if (line.trim().equals("/")) {
                this.printCommandHistory();
                continue;
            }
            if (line.trim().startsWith("\\")) {
                line = this.lastCommand(line);
            }
            if (line.trim().equalsIgnoreCase("help") || line.trim().equalsIgnoreCase("?")) {
                this.parser.helpPrintAvailableCommand(this.parser.argumentRoot);
                this.printRuntimeAndHelp();
                continue;
            }
            if (line.trim().startsWith("delay")) {
                this.delay(line);
                continue;
            }
            try {
                if (fp.check(line)) {
                    MOut.G(this.parser).setFilterString(fp.filter);
                    MOut.G(this.parser).setFilterEnabled(true);
                    this.processCommand(fp.command);
                } else {
                    this.processCommand(line);
                }
                MOut.G(this.parser).setFilterEnabled(false);
            }
            catch (Exception ex) {
                MOut.G(this.parser).println(ex.getMessage());
            }
        }
        MOut.G(this.parser).println("bye");
        System.exit(0);
        this.statusCode = 0;
    }

    private void delay(String delay) {
        int msdelay;
        StringTokenizer st = new StringTokenizer(delay, " ");
        st.nextToken();
        String ms = null;
        try {
            ms = st.nextToken();
        }
        catch (Exception ex1) {
            return;
        }
        if (ms == null) {
            return;
        }
        try {
            msdelay = Integer.parseInt(ms);
        }
        catch (NumberFormatException ex) {
            MOut.G(this.parser).println("The parameter must be integer");
            return;
        }
        try {
            Thread.sleep(msdelay);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
    }

    private void setCommandHistory(ConsoleReader reader) throws IOException {
        ConfigAccessor ca = new ConfigAccessor(".", "SMCIPMITool.properties");
        String isHistory = ca.getProperty("history");
        if ("on".equalsIgnoreCase(isHistory)) {
            reader.setHistory(new History(new File("SMCIPMITool.history")));
        }
    }

    public void newParser() {
        this.parser = new Parser(true);
        this.parser.loadPlugInCommands();
    }

    public void printPrompt() {
        MOut.G(this.parser).print(this.getPrompt());
    }

    public String getPrompt() {
        if (!this.isShowPrompt) {
            return ">";
        }
        String prompt = "";
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp(), 3, 0);
        if (guid != null) {
            this.statusPrompt.setIPMIInterfaceConfig(this.config);
            try {
                GlobalDefine.PAUSE_DEBUG = true;
                boolean result = this.statusPrompt.updateStatus();
                GlobalDefine.PAUSE_DEBUG = false;
                if (!result) {
                    MOut.G(this.parser).println("Cannot login to " + this.config.getIp());
                }
            }
            catch (Exception ex) {
                MOut.G(this.parser).println("Cannot login to " + this.config.getIp());
            }
            prompt = this.statusPrompt.getPromptString();
        } else {
            MOut.G(this.parser).println("Cannot connect to " + this.config.getIp());
        }
        return prompt + this.trapStatusForPrompt() + ">";
    }

    public String getTagLoc() {
        String retStr = "";
        ISessionController sessionController = IPMIVersion.getSessionController(this.config);
        IPMIOEMLocCommand ipmiOEMLocCommand = new IPMIOEMLocCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(this.config);
        if (rmcp == null) {
            return "";
        }
        ipmiOEMLocCommand.setIPMIInterface(rmcp);
        try {
            TagLocSDR tagLocSDR = ipmiOEMLocCommand.getTagLocSDR();
            if (tagLocSDR != null) {
                retStr = tagLocSDR.tagLoc.toShortFormatedString();
            } else {
                MOut.G(this.parser).println("No Tag info");
            }
        }
        catch (IPMIException ex) {
            MOut.G(this.parser).println("No Tag info");
        }
        sessionController.closeSession();
        return retStr;
    }

    public String showSpec() {
        String retStr = "";
        ISessionController sessionController = IPMIVersion.getSessionController(this.config);
        IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(this.config);
        if (rmcp == null) {
            return "";
        }
        ipmiOEMCommand.setIPMIInterface(rmcp);
        try {
            String link = ipmiOEMCommand.getBoardModelWebLink();
            if (link != null) {
                OpenURI.openURL(link);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        sessionController.closeSession();
        return retStr;
    }

    public String showPic() {
        String retStr = "";
        ISessionController sessionController = IPMIVersion.getSessionController(this.config);
        IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(this.config);
        if (rmcp == null) {
            return "";
        }
        ipmiOEMCommand.setIPMIInterface(rmcp);
        try {
            String picLink;
            String link = ipmiOEMCommand.getBoardModelWebLink();
            if (link != null && (picLink = HTMLUtils.extractPicLink(link)) != null) {
                ImageFrame frame = new ImageFrame(picLink);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        sessionController.closeSession();
        return retStr;
    }

    private String lastCommand(String line) {
        int numberInt;
        if (this.commandHistory.size() == 0) {
            return "";
        }
        String numberStr = line.substring(1);
        try {
            numberInt = Integer.parseInt(numberStr);
        }
        catch (NumberFormatException ex1) {
            MOut.G(this.parser).println("number parse error!");
            return "";
        }
        this.commandHistoryIndex = numberInt;
        if (this.commandHistoryIndex <= 0) {
            return "";
        }
        if (this.commandHistory.size() - this.commandHistoryIndex < 0) {
            return "";
        }
        line = (String)this.commandHistory.get(this.commandHistory.size() - this.commandHistoryIndex);
        MOut.G(this.parser).println(line);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        return line;
    }

    private void printRuntimeAndHelp() {
        String usedMemory = (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L + "K";
        String freeMemory = Runtime.getRuntime().freeMemory() / 1024L + "K";
        String totalMemory = Runtime.getRuntime().totalMemory() / 1024L + "K";
        String maxMemory = Runtime.getRuntime().maxMemory() / 1024L + "K";
        String maxAvailableMemory = (Runtime.getRuntime().maxMemory() - (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory())) / 1024L + "K";
        SimpleDateFormat f = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        MOut.G(this.parser).println("Runtime Info:");
        MOut.G(this.parser).printf("%-20s \t %-20s \n", "Host IP", this.config.getIp());
        MOut.G(this.parser).printf("%-20s \t %-20s \n", "Username", this.config.getUserName());
        MOut.G(this.parser).printf("%-20s \t %-20s \n", "Java Version", System.getProperty("java.vm.version"));
        MOut.G(this.parser).printf("%-20s \t %-20s \n", "Used Memory", usedMemory);
        MOut.G(this.parser).printf("%-20s \t %-20s \n", "Max Available Memory", maxAvailableMemory);
        MOut.G(this.parser).printf("%-20s \t %-20s \n", "Current Time", f.format(Calendar.getInstance().getTime()));
        MOut.G(this.parser).printf("%-20s \t %-20s \n", "Time Elapsed", ShellCommand.timeDiff(this.startTime, Calendar.getInstance()));
        if (MOut.G((Parser)this.parser).isRecord) {
            MOut.G(this.parser).printf("%-20s \t %-20s \n", "Record File", MOut.G((Parser)this.parser).recordFilename);
        }
        MOut.G(this.parser).printf("%-20s \t %-20s \n", "Trap Receiver", Receiver.getInstance().isStart ? "Running" : "Stopped");
        MOut.G(this.parser).println("");
        MOut.G(this.parser).println("Press Ctrl+D or \"exit\" to exit");
        MOut.G(this.parser).println("Press \"?\" or \"help\" for help");
        MOut.G(this.parser).println("Press TAB for command completion");
        MOut.G(this.parser).println("Press UP and DOWN key for command history");
    }

    public static String timeDiff(Calendar c1, Calendar c2) {
        long diffMillis = c2.getTimeInMillis() - c1.getTimeInMillis();
        long diffSecs = diffMillis / 1000L;
        long diffMins = diffMillis / 60000L;
        long diffHours = diffMillis / 3600000L;
        long diffDays = diffMillis / 86400000L;
        long leafHours = diffMillis % 86400000L / 3600000L;
        long leafMins = diffMillis % 86400000L % 3600000L / 60000L;
        return "" + diffDays + "d" + " " + leafHours + "h" + " " + leafMins + "m";
    }

    public void processCommand(String commandLine) {
        if (commandLine.length() == 0) {
            return;
        }
        if (commandLine.trim().equalsIgnoreCase("help") || commandLine.trim().equalsIgnoreCase("?")) {
            this.parser.helpPrintAvailableCommand(this.parser.argumentRoot);
            this.printRuntimeAndHelp();
            return;
        }
        if (commandLine.trim().startsWith("delay")) {
            this.delay(commandLine);
            return;
        }
        ArrayList<String> string = new ArrayList<String>();
        Pattern p = Pattern.compile("\".*?\"|\\S+");
        Matcher m = p.matcher(commandLine);
        while (m.find()) {
            String token = m.group();
            if (token.startsWith("\"") && token.endsWith("\"")) {
                token = token.substring(1, token.length() - 1);
            }
            string.add(token);
        }
        String[] args = new String[string.size()];
        string.toArray(args);
        this.parser.argumentRoot.clearValue();
        Command command = null;
        try {
            command = this.parser.parse(this.parser.argumentRoot, args);
        }
        catch (CommandIncompleteException e) {
            // empty catch block
        }
        if (command == null) {
            return;
        }
        try {
            command.setConfig(this.config);
            command.setOriginalParser(this.parser);
            command.execute();
            MOut.G(this.parser).println("");
            this.commandHistory.add(commandLine);
        }
        catch (Exception ex) {
            MOut.G(this.parser).println(ex.getMessage());
        }
    }

    public void printCommandHistory() {
        if (this.commandHistory.size() == 0) {
            MOut.G(this.parser).println("Command history empty");
            return;
        }
        MOut.G(this.parser).println("Command History:");
        for (int i = 0; i < this.commandHistory.size(); ++i) {
            MOut.G(this.parser).printf("(%2d) %-20s \t : %s \n", i + 1, "\\" + (i + 1), this.commandHistory.get(this.commandHistory.size() - i - 1));
            if (i == 19) break;
        }
    }

    public static void main(String[] args) {
        String a = "1 2 3 4 \"asdf asd fasdfa sdf\" ";
        Pattern p = Pattern.compile("\".*?\"|\\S+");
        Matcher m = p.matcher(a);
        while (m.find()) {
            String token = m.group();
            if (token.startsWith("\"") && token.endsWith("\"")) {
                token = token.substring(1, token.length() - 1);
            }
            MOut.G().println(token);
        }
    }
}

