/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.drvredir;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintStream;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import nn.pp.drvredir.ConnectionHandler;
import nn.pp.drvredir.ConnectionHandlerDrive;
import nn.pp.drvredir.ConnectionHandlerIso;
import nn.pp.drvredir.DrvRedirNative;
import nn.pp.drvredir.StatusLabel;
import nn.pp.rc.RFBProfile;
import nn.pp.rc.T;

class DrvRedirSettingsPanel
extends JPanel
implements ActionListener {
    DrvRedirNative drvAccess;
    RFBProfile profile;
    ConnectionHandler handler;
    PrintStream logger;
    JLabel drvLabel;
    StatusLabel statusLabel;
    JButton connectDriveButton;
    JButton connectIsoButton;
    JButton disconnectButton;
    int msNo;
    int msIndex;

    void debug(String s) {
    }

    public DrvRedirSettingsPanel(RFBProfile profile, PrintStream logger, int msNo, int msIndex, DrvRedirNative drvAccess) {
        this.profile = profile;
        this.logger = logger;
        this.msNo = msNo;
        this.msIndex = msIndex;
        this.drvAccess = drvAccess;
        this.addLayout();
        this.disconnect(true);
        this.disconnectButton.setVisible(false);
    }

    public void setDisconnectButtonVisible() {
        this.disconnectButton.setVisible(true);
    }

    public void close() {
        this.disconnect(true);
        this.hide();
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (!enabled) {
            this.disconnect(true);
            this.enableControls(true, false);
        }
        super.setEnabled(enabled);
    }

    private void addLayout() {
        this.setLayout(new BorderLayout());
        JPanel p1 = new JPanel(new FlowLayout(0, 0, 1));
        if (this.msNo == 1) {
            this.drvLabel = new JLabel(T._("Drive:"));
            p1.add(this.drvLabel);
        } else {
            this.drvLabel = new JLabel(T._("Drive") + " " + (this.msIndex + 1) + ":");
            p1.add(this.drvLabel);
        }
        p1.add(new JLabel(""));
        if (this.drvAccess != null) {
            this.connectDriveButton = new JButton(T._("Connect Drive"));
            p1.add(this.connectDriveButton);
        }
        this.connectIsoButton = new JButton(T._("Connect ISO"));
        p1.add(this.connectIsoButton);
        this.disconnectButton = new JButton(T._("Disconnect"));
        p1.add(this.disconnectButton);
        p1.add(new JLabel(""));
        this.add((Component)p1, "West");
        this.statusLabel = new StatusLabel();
        this.add((Component)this.statusLabel, "Center");
        if (this.connectDriveButton != null) {
            this.connectDriveButton.addActionListener(this);
        }
        if (this.connectIsoButton != null) {
            this.connectIsoButton.addActionListener(this);
        }
        if (this.disconnectButton != null) {
            this.disconnectButton.addActionListener(this);
        }
        this.enableControls(false, false);
    }

    private void enableControls(boolean disableAll, boolean connected) {
        this.drvLabel.setEnabled(!disableAll);
        this.statusLabel.setEnabled(!disableAll);
        if (this.connectDriveButton != null) {
            this.connectDriveButton.setEnabled(disableAll ? false : !connected);
        }
        if (this.connectIsoButton != null) {
            this.connectIsoButton.setEnabled(disableAll ? false : !connected);
        }
        if (this.disconnectButton != null) {
            this.disconnectButton.setEnabled(disableAll ? false : connected);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.connectDriveButton) {
            new Thread(){

                @Override
                public void run() {
                    DrvRedirSettingsPanel.this.connectDrive();
                }
            }.start();
        } else if (src == this.connectIsoButton) {
            new Thread(){

                @Override
                public void run() {
                    DrvRedirSettingsPanel.this.connectIso();
                }
            }.start();
        } else if (src == this.disconnectButton) {
            this.disconnect(true);
        }
    }

    private JFrame getParentFrame() {
        JFrame frame = null;
        for (Container parent = this; parent != null; parent = parent.getParent()) {
            if (!(parent instanceof JFrame)) continue;
            frame = (JFrame)parent;
            break;
        }
        return frame;
    }

    private void connectDrive() {
        ConnectionHandlerDrive handlerDrive = new ConnectionHandlerDrive(this.profile, this, this.drvAccess, this.logger, this.msIndex);
        this.handler = handlerDrive;
        try {
            handlerDrive.chooseDrive(this.getParentFrame());
            this.handler.connect();
            this.enableControls(false, true);
            this.logger.println(T._("Drive Redirection established (Drive ") + handlerDrive.drive + ").");
            this.statusLabel.setDrive(handlerDrive.drive);
        }
        catch (Exception e) {
            this.logger.println(e.getMessage() == null ? "" : e.getMessage());
            this.disconnect(false);
        }
    }

    private void connectIso() {
        ConnectionHandlerIso handlerIso = new ConnectionHandlerIso(this.profile, this, this.logger, this.msIndex);
        this.handler = handlerIso;
        try {
            handlerIso.chooseIsoFile(this.getParentFrame());
            this.handler.connect();
            this.enableControls(false, true);
            this.logger.println(T._("ISO Drive Redirection established (") + handlerIso.filename + ").");
            this.statusLabel.setIso(handlerIso.filename);
        }
        catch (Exception e) {
            this.logger.println(e.getMessage() == null ? "Error opening file" : e.getMessage());
            this.disconnect(false);
        }
    }

    private void disconnect(boolean showInfo) {
        this.debug("Disconnecting.");
        if (this.handler != null) {
            this.handler.disconnect();
            this.handler = null;
        }
        this.enableControls(false, false);
        if (showInfo) {
            this.logger.println("Drive Redirection disconnected.");
            this.statusLabel.setDisconnected();
        }
    }

    public void disconnected(boolean server) {
        this.debug("Have been disconnected by " + (server ? "Server" : "User"));
        if (server) {
            this.disconnect(false);
            this.logger.println("Disconnected by the device!");
        } else {
            this.logger.println("Successfully disconnected!");
        }
        this.statusLabel.setDisconnected();
    }

    public void setConnectButtonEnabled(boolean isEnabled) {
        this.connectDriveButton.setEnabled(isEnabled);
        this.connectIsoButton.setEnabled(isEnabled);
    }

    public boolean isConnectButtonEnabled() {
        return this.connectDriveButton.isEnabled();
    }

    public void setDisconnectButtonEnabled(boolean isEnabled) {
        this.disconnectButton.setEnabled(isEnabled);
    }

    public boolean isDisconnectButtonEnabled() {
        return this.disconnectButton.isEnabled();
    }
}

