/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.rc;

import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.blade.CMMModuleEntity;
import com.supermicro.ipmi.text.CommandPlugIn;
import com.supermicro.ipmi.text.MOut;
import java.awt.GraphicsEnvironment;
import java.io.IOException;

public class KVMPlugIn
extends CommandPlugIn {
    @Override
    public void execute() throws Exception {
        if (!this.isKVMSupported()) {
            this.printSlaveCMMUnavailableMessage();
            return;
        }
        boolean result = GraphicsEnvironment.isHeadless();
        if (result) {
            MOut.G().print("No graphic environment here !");
            return;
        }
        MOut.G().print("Starting KVM Process...");
        try {
            Process p = Runtime.getRuntime().exec("java -jar KVMPlugIn.jar " + this.config.getIp() + " " + this.config.getUserName() + " " + this.config.getPassword());
        }
        catch (IOException ex) {
            MOut.G().println(" Failed");
            return;
        }
        MOut.G().println("Done");
        MOut.G().println("Please wait for KVM window");
    }

    public boolean isKVMSupported() {
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (guid == null) {
            return false;
        }
        if (IPMIMessagingCommand.isCMMGUID(guid)) {
            return this.isCurrentCMMMaster();
        }
        if (IPMIMessagingCommand.isPepperconGUID(guid)) {
            return true;
        }
        if (IPMIMessagingCommand.isPepperconNoneKVMGUID(guid)) {
            return true;
        }
        if (IPMIMessagingCommand.isSIMBL(guid)) {
            return true;
        }
        if (IPMIMessagingCommand.isOSAGUID(guid)) {
            return false;
        }
        return false;
    }

    public boolean isCurrentCMMMaster() {
        BladeSystemEntity bladeSystem = new BladeSystemEntity(this.config);
        bladeSystem.setEnableAllQuery(false);
        bladeSystem.setIsQueryCMMModuleEntity(true);
        bladeSystem.getData();
        for (int i = 0; i < 2; ++i) {
            CMMModuleEntity cmm = bladeSystem.getCmmModules()[i];
            if (!cmm.isConnected() || cmm.getMasterSlave() != 0) continue;
            return true;
        }
        return false;
    }

    public void printSlaveCMMUnavailableMessage() {
        MOut.G().println("This function is unavailable for this device or slave CMM.");
    }

    @Override
    public String getAlternateValue() {
        return null;
    }

    @Override
    public String getComment() {
        return "Open KVM console (graphic mode)";
    }

    @Override
    public String getName() {
        return "kvm";
    }

    @Override
    public String getValue() {
        return "kvm";
    }

    @Override
    public boolean isSupportCLIMode() {
        return true;
    }

    @Override
    public boolean isSupportShellMode() {
        return true;
    }

    public static void main(String[] args) {
    }
}

