/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.rc;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import nn.pp.rc.FlowText;

public class ToolTip
extends Window
implements MouseListener,
ContainerListener {
    private static final Color lightYellow = new Color(255, 255, 204);
    private static ToolTip currentToolTip;
    private static Object currentToolTipMonitor;
    private Component comp;
    private boolean layedOut;
    private FlowText ft;
    private boolean msjvm;

    public ToolTip(Component comp, FlowText ft, Frame parent, boolean msjvm) {
        super(parent);
        this.msjvm = msjvm;
        this.comp = comp;
        this.setForeground(Color.black);
        this.setBackground(lightYellow);
        this.ft = ft;
        ft.setOptimizeWidth(true);
        this.setLayout(new GridBagLayout());
        this.registerComponent(comp);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Dimension d = this.getSize();
        g.drawRect(0, 0, d.width - 1, d.height - 1);
    }

    @Override
    public void dispose() {
        this.unregisterComponent(this.comp);
        super.dispose();
    }

    private void checkLayout() {
        if (!this.layedOut) {
            Font f = new Font("sansserif", 0, this.getFont().getSize());
            this.setFont(f);
            GridBagConstraints con = new GridBagConstraints();
            int i = this.getFontMetrics(f).getHeight() / 4;
            con.insets = new Insets(i, i * 2, i, i * 2);
            con.fill = 1;
            con.weightx = 1.0;
            con.weighty = 1.0;
            ((GridBagLayout)this.getLayout()).setConstraints(this.ft, con);
            this.add(this.ft);
            if (this.msjvm) {
                this.setSize(this.getPreferredSize().width, this.getPreferredSize().height + 15);
            } else {
                this.setSize(this.getPreferredSize());
            }
            this.layedOut = true;
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseEntered(MouseEvent e) {
        this.checkLayout();
        Point p = this.comp.getLocationOnScreen();
        Dimension cd = this.comp.getSize();
        Dimension sd = this.getToolkit().getScreenSize();
        Dimension td = this.getSize();
        int x = p.x + cd.width / 2;
        int y = p.y + cd.height + 8;
        if (y + td.height > sd.height) {
            y = p.y - td.height - 8;
        }
        if (x + td.width > sd.width) {
            x -= td.width;
        }
        this.setLocation(x, y);
        System.out.println("button: " + p.x + "/" + p.y + " buttonsize: " + cd.width + "/" + cd.height + " screensize: " + sd.width + "/" + sd.height + " getsize: " + td.width + "/" + td.height + " place: " + x + "/" + y);
        Object object = currentToolTipMonitor;
        synchronized (object) {
            if (currentToolTip != null) {
                currentToolTip.hideToolTip();
            }
            currentToolTip = this;
            this.setVisible(true);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        Component src = (Component)e.getSource();
        if (src == this.comp) {
            this.hideToolTip();
        } else {
            int x = e.getX();
            int y = e.getY();
            for (Component c = src; c != this.comp && c != null; c = c.getParent()) {
                Point p = c.getLocation();
                x += p.x;
                y += p.y;
            }
            if (!this.comp.contains(x, y)) {
                this.hideToolTip();
            }
        }
    }

    private void registerComponent(Component comp) {
        comp.addMouseListener(this);
        if (comp instanceof Container) {
            ((Container)comp).addContainerListener(this);
            Component[] comps = ((Container)comp).getComponents();
            if (comps != null) {
                for (int i = 0; i < comps.length; ++i) {
                    this.registerComponent(comps[i]);
                }
            }
        }
    }

    private void unregisterComponent(Component comp) {
        comp.removeMouseListener(this);
        if (comp instanceof Container) {
            ((Container)comp).removeContainerListener(this);
            Component[] comps = ((Container)comp).getComponents();
            if (comps != null) {
                for (int i = 0; i < comps.length; ++i) {
                    this.unregisterComponent(comps[i]);
                }
            }
        }
    }

    @Override
    public void componentAdded(ContainerEvent e) {
        this.registerComponent(e.getChild());
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
        this.unregisterComponent(e.getChild());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hideToolTip() {
        Object object = currentToolTipMonitor;
        synchronized (object) {
            this.setVisible(false);
            currentToolTip = null;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    static {
        currentToolTipMonitor = new Object();
    }
}

