/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.sara;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import nn.pp.rc.FixedLabel;
import nn.pp.rc.GenericTimer;
import nn.pp.rc.SasEvent;
import nn.pp.sara.InfoPanel;
import nn.pp.sara.InfoPanelPart;
import nn.pp.sara.MouseVisual;

class MousePanel
extends InfoPanelPart
implements ActionListener {
    Label sourceLabel;
    boolean hasSource;
    MouseVisual visual = new MouseVisual(this);
    Label pos;
    Label buttons;
    Label wheel;
    Label sync;
    GenericTimer wheelTimer = new GenericTimer(1000, this);
    GenericTimer syncTimer = new GenericTimer(2000, this);
    private int buttonMask = 0;
    private int oldButtonMask = -1;

    MousePanel(InfoPanel info) {
        super(info, true);
    }

    private String getPos(int x, int y, boolean relative) {
        String s = "";
        if (relative) {
            s = s + "R ";
        }
        s = s + "(" + x + ", " + y + ")";
        return s;
    }

    private String getButtons(int mask) {
        String s = "";
        if ((mask & 1) != 0) {
            s = s + "L ";
        }
        if ((mask & 2) != 0) {
            s = s + "M ";
        }
        if ((mask & 4) != 0) {
            s = s + "R ";
        }
        return s;
    }

    private String getButtonChange(int oldMask, int newMask) {
        String[] buttons = new String[]{"Left", "Middle", "Right"};
        String ret = "";
        for (int i = 0; i < buttons.length; ++i) {
            if ((newMask & 1 << i) != 0 && (oldMask & 1 << i) == 0) {
                ret = ret + buttons[i] + " button down ";
                continue;
            }
            if ((newMask & 1 << i) != 0 || (oldMask & 1 << i) == 0) continue;
            ret = ret + buttons[i] + " button up ";
        }
        return ret;
    }

    private String getWheel(int z) {
        String s = "";
        if (z < 0) {
            s = "Up";
        } else if (z > 0) {
            s = "Down";
        }
        return s;
    }

    private void processPos(int x, int y, boolean relative) {
        this.pos.setText(this.getPos(x, y, relative));
    }

    private boolean processButtons(int mask) {
        boolean notify = false;
        if (this.buttonMask != mask) {
            this.visual.processButtons(mask);
            this.buttons.setText(this.getButtons(mask));
            notify = true;
        }
        this.buttonMask = mask;
        return notify;
    }

    private synchronized boolean processWheel(int z) {
        String s;
        boolean notify = false;
        this.wheelTimer.stop();
        if (z != 0) {
            this.wheelTimer.start();
        }
        if ((s = this.getWheel(z)).length() > 0) {
            this.wheel.setText("Wheel: " + s);
            notify = true;
        } else {
            this.wheel.setText("");
        }
        this.visual.processWheel(z);
        return notify;
    }

    private synchronized void processSync(String type) {
        this.syncTimer.stop();
        if (type == null) {
            this.sync.setText("");
            return;
        }
        this.syncTimer.start();
        this.sync.setText("Sync: " + type);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.wheelTimer) {
            this.processWheel(0);
        } else if (e.getSource() == this.syncTimer) {
            this.processSync(null);
        }
    }

    @Override
    String getHeader() {
        return "Mouse Events";
    }

    @Override
    void addPartLayout() {
        Panel p = new Panel(new BorderLayout());
        Panel p1 = new Panel(new BorderLayout());
        Panel p2 = new Panel(new GridLayout(0, 1, 0, 0));
        this.pos = new FixedLabel("  P (8888, 8888)  ", true);
        p2.add(this.pos);
        this.buttons = new FixedLabel("  L M R  ", true);
        p2.add(this.buttons);
        this.wheel = new FixedLabel("  Wheel: Down  ", true);
        p2.add(this.wheel);
        this.sync = new FixedLabel("  Sync: Normal  ", true);
        p2.add(this.sync);
        p1.add((Component)p2, "East");
        p1.add((Component)this.visual, "Center");
        p.add((Component)p1, "West");
        p.add((Component)new Label(), "Center");
        this.add((Component)p, "Center");
        this.processPos(0, 0, false);
        this.processButtons(0);
        this.processWheel(0);
    }

    private void handlePointerEvent(SasEvent evt) {
        int x = evt.inputEvent.x;
        int y = evt.inputEvent.y;
        int z = evt.inputEvent.z;
        int b = evt.inputEvent.buttonMask;
        int t = evt.inputEvent.type;
        if (t == 2) {
            this.processPos(x, y, true);
        } else if (z == 0) {
            this.processPos(x, y, false);
        }
        if (this.processWheel(z)) {
            this.info.newEvent(evt, "Mouse Wheel Event", "Wheel " + this.getWheel(z));
        }
        int oldB = this.buttonMask;
        if (this.processButtons(b)) {
            this.info.newEvent(evt, "Mouse Button Event", this.getButtonChange(oldB, b));
        }
    }

    private void handleSyncEvent(SasEvent evt) {
        this.processSync(evt.inputEvent.syncType);
        this.info.newEvent(evt, "Mouse Sync", evt.inputEvent.syncType + " Sync");
    }

    @Override
    void handlePartSasEvent(SasEvent evt) {
        if (evt.inputEvent.type == 3) {
            this.handleSyncEvent(evt);
        } else {
            this.handlePointerEvent(evt);
        }
    }
}

