/************************************************************************
 *     MultiSound MIDI In/Out Example
 *
 *     Takes MIDI in from the external port, and passes it to the daughter board
 *     synth and the Kurzweil synth.
 *
 *     Copyright 1992  Turtle Beach Systems Inc., All rights reserved.
 *
 *
 * **********************************************************************/

#include <stdio.h>
#include <malloc.h>
#include <memory.h>
#include <stdlib.h>
#include <conio.h>
#include "msnd_dsp.h"
#include "pcontrol.h"


void EvalDSPMessage( WORD wDSPMessage );
void MidiInData( void );

main()
{
    bMem        = HPMEM_D000;
    //bIrq            = HPIRQ_10;
    //nIRQValue       = 10;
    bIrq            = HPIRQ_9;
    nIRQValue       = 9;

    wMPUIO          = 0x330;
    nMPUIRQ         = 5;

    pMEM.dw.h       = 0xD000;
    pMEM.dw.l       = 0x0000;
    wBASEIO         = 0x290;          // DSP base address to program.

                                      // non plug and play jumpers as follows:
    wCFGIO          =0x250;           //     -------------------
                                      //     | /-------------\ |    address x250
                                      //     | |   o     o   | |
                                      //     | \-------------/ |
                                      //     |                 |
                                      //     |     o     o     |
                                      //     |                 |
                                      //     -------------------



    if( ( pwHostQueue = calloc( sizeof(WORD) , HOSTQ_SIZE ) ) == NULL ) 
        exit(0);

    pwHostTail = pwHostQueue;
    pwHostHead = pwHostQueue;

    InitializeSMA();


    if (!UploadDspCode())
    {
        printf("Failed to upload and initialize DSP\n");
        exit(0);
    }


    SetupMsndIRQ();

    if (!EnableMPU())
    {
        printf("Could not setup Kurzweil MPU\n");
    }

    SetMidiOutPort(WAVEHDR_MOP);
    SetMidiInPort( EXTIN_MIP);

    SendDSPCommand( HDEX_MIDI_IN_START );
    SendDSPCommand( HDEX_MIDI_OUT_START );

    while( !kbhit() ) {
        if( pwHostTail != pwHostHead ) 
    {
            if( ++pwHostHead >= ( pwHostQueue + HOSTQ_SIZE ) ) 
        {
                pwHostHead = pwHostQueue;
                printf("Wrapping Host Queue\n");
            }
            EvalDSPMessage( *pwHostHead );
        }
    }

    SendDSPCommand( HDEX_MIDI_IN_STOP );

    DisableMPU();

    ResetMsndIRQ();
    return(0);
}

void MidiInData( void )
{
    WORD wMidiData;
    while( MIDQ->wHead != MIDQ->wTail ) 
    {
        wMidiData = MIDPortRead();
        if( HIBYTE( wMidiData ) == 0x00 ) 
        {
            // send it to the daughter board.
            MODPortWrite( wMidiData );
            // send it to the Kurzweil
            WriteMPU(LOBYTE(wMidiData));
        }
        printf( "%.2X " , LOBYTE( wMidiData ) );
    }
}

void EvalDSPMessage( WORD wMessage )
{
    switch ( HIBYTE( wMessage ) )
    {
        case HIMT_PLAY_DONE:
            break;

        case HIMT_DSP:
            switch ( LOBYTE( wMessage ) )
            {
                case HIDSP_PLAY_UNDER:
                    printf("HIDSP_PLAY_UNDER\n");
                    break;

                case HIDSP_INT_PLAY_UNDER:
                    printf( "HIDSP_INT_PLAY_UNDER\n" );
                    break;

                case HIDSP_SSI_TX_UNDER:
                    printf( "HIDSP_SSI_TX_UNDER\n" );
                    break;
                case HIDSP_RECQ_OVERFLOW:
                    printf( "HIDSP_RECQ_OVERFLOW\n" );
                    break;
                case HIDSP_INT_REC_OVERFLOW:
                    printf( "HIDSP_INT_REC_OVERFLOW\n" );
                    break;
                case HIDSP_SSI_RX_OVERFLOW:
                    printf( "HIDSP_SSI_RX_OVERFLOW\n" );
                    break;
                case HIDSP_MIDI_FRAME_ERR:
                    printf( "HIDSP_MIDI_FRAME_ERR\n" );
                    break;
                case HIDSP_MIDI_PARITY_ERR:
                    printf( "HIDSP_MIDI_PARITY_ERR\n" );
                    break;
                case HIDSP_INPUT_CLIPPING:
                    printf( "HIDSP_INPUT_CLIPPING\n" );
                    break;
                case HIDSP_MIX_CLIPPING:
                    printf( "HIDSP_MIX_CLIPPING\n" );
                    break;
                case HIDSP_DAT_IN_OFF:
                    printf( "HIDSP_DAT_IN_OFF\n" );
                    break;
                case HIDSP_MIDI_IN_OVER:
                    printf( "HIDSP_MIDI_IN_OVER\n" );
                    break;
                case HIDSP_MIDI_OVERRUN_ERR:
                    printf( "HIDSP_MIDI_OVERRUN_ERR\n" );
                    break;
                default:
                    printf("ERROR: UNKNOWN_DSP_MESSAGE %X : %X\n" , HIBYTE( wMessage ) , LOBYTE( wMessage ) );
                    break;
            }
            break;

        case HIMT_RECORD_DONE:
            printf( "HIMT_RECORD_DONE\n" );
            break;

        case HIMT_MIDI_IN_UCHAR:
            printf("\nHIMT_MIDI_IN_BYTE\n");
            MidiInData();
            break;

        default:
            printf("UNKNOWN_MESSAGE %X : %X\n" , HIBYTE( wMessage ) , LOBYTE( wMessage ) );
            break;

    }
}



