/************************************************************************
 *     MultiSound Aux Volume Demo Code
 *
 *     This program demonstrates the adjustment of the auxillary
 *     volume.  Running this with a source on the aux input, you
 *     can adjust the volume using the '+' and '-' keys.  The 'q'
 *     key will stop the program.
 *
 *     Copyright 1992  Turtle Beach Systems Inc., All rights reserved.
 *
 *
 * **********************************************************************/

#include <stdio.h>
#include <conio.h>
#include <msnd_dsp.h>
#include <pcontrol.h>


BYTE bTerminator = 0;

main()
{
	bMem        = HPMEM_D000;
  bIrq        = HPIRQ_10;
  nIRQValue   = 10;
  pMEM.dw.h   = 0xD000;
  pMEM.dw.l   = 0x0000;
  wBASEIO     = 0x290;

  outp( ( wBASEIO + HP_WAIT ) , HPWAITSTATE_0 );
  outp( ( wBASEIO + HP_BITM ) , HPBITMODE_16 );

	ResetProteus();
	InitializeSMA();
	ResetDSP();
	UploadDSPCode();

  while( !*( pMEM.p ) );

	SetAuxVolume( 0x15 , GANG );

	while( !bTerminator ) {
		if( kbhit() ) {
			switch ( getch() ) {
				case 0x2B:
					SetAuxVolume( ++SMA->bAuxPotPosLeft , GANG );
					printf("Aux Volume = 0x%X\n", SMA->bAuxPotPosLeft );
					break;

				case 0x2D:
					SetAuxVolume( --SMA->bAuxPotPosLeft , GANG );
					printf("Aux Volume = 0x%X\n", SMA->bAuxPotPosLeft );
					break;

				case 0x51:
				case 0x71:
					printf("Terminating\n");
					bTerminator = 1;
					break;

			}
		}
  }

  return(0);
}

