/************************************************************************
 *     MultiSound Play Example
 *
 *		 Plays a PCM sound file based on the parameters defined at compile
 *	   time:
 *
 *		 SAMPLE_RATE        44100 / 22050 / 11025
 *		 BITS               16 / 8
 *     CHANNELS           2 / 1
 *
 *		 Command line parameter is the full path of the soundfile to play
 *
 *     Copyright 1992  Turtle Beach Systems Inc., All rights reserved.
 *
 *
 * **********************************************************************/

#include <stdio.h>
#include <malloc.h>
#include <memory.h>
#include <stdlib.h>
#include <msnd_dsp.h>
#include <DOS.H>
#include <pcontrol.h>

#define SAMPLE_RATE 44100
#define BITS        16
#define CHANNELS    2
#define PCM         1

FILE *f_point;

BYTE bTerminator = 0;
long lReadSize;
BYTE far *pbCurPlayBuff;

void EvalDSPMessage( WORD wDSPMessage );
void SetupPlayStruct( BYTE bBank );

main(argc, argv)
int argc;
char *argv[];
{
	WORD wInker;

	bIntFlag      = 0;
	bMem          = HPMEM_D000;
	bIrq          = HPIRQ_10;
	nIRQValue     = 10;
	pMEM.dw.h     = 0xD000;
	pMEM.dw.l     = 0x0000;
	wBASEIO       = 0x290;
	pbCurPlayBuff = pMEM.p;

	if( ( pwHostQueue = calloc( sizeof(WORD) , HOSTQ_SIZE ) ) == NULL ) exit(0);
	pwHostHead = pwHostQueue;
	pwHostTail = pwHostQueue;

  outp( ( wBASEIO + HP_WAIT ) , HPWAITSTATE_0 );
  outp( ( wBASEIO + HP_BITM ) , HPBITMODE_16 );

	ResetProteus();
	InitializeSMA();
	ResetDSP();

  UploadDSPCode();
//  uploadbin( "msndinit.bin" );
//  uploadreb( "msndperm.reb" );

  while( *( pMEM.p ) || *(pMEM.p + 1) );

	SetupMsndIRQ();

	if( ( f_point = fopen( argv[1], "rb" ) ) == NULL ) {
		printf("Unable to open file\n");
		exit(0);
	}

	for( wInker = 0 ; wInker < 3 ; wInker++ ) {
		SetupPlayStruct( (BYTE)wInker );
		CurDAQD++;
		pbCurPlayBuff += DAP_BUFF_SIZE;
	}
	CurDAQD = ( struct DAQueueDataStruct far * )( pMEM.p + DAPQ_DATA_BUFF );

	DAPQ->wTail = PCTODSP_OFFSET( 2 * DAPQ_STRUCT_SIZE );
	SendDSPCommand( HDEX_PLAY_START );

	while( !bTerminator ) {
		if( feof( f_point ) ) bTerminator = 1;
		if( pwHostTail != pwHostHead ) {
			if( ++pwHostHead >= (pwHostQueue + HOSTQ_SIZE ) ) {
				pwHostHead = pwHostQueue;
				printf("Wrapping Host Queue\n");
			}
			EvalDSPMessage( *pwHostHead );
		}
	}

	SendDSPCommand( HDEX_PLAY_STOP );

	ResetMsndIRQ();
	fclose( f_point );

  return (0);
}


void SetupPlayStruct( BYTE bBank )
{

	CurDAQD->wStart      = PCTODSP_BASED( (DWORD)( DAP_BUFF_SIZE * bBank ) );
	CurDAQD->wSize       = DAP_BUFF_SIZE;
	CurDAQD->wFormat     = PCM;
	CurDAQD->wSampleSize = BITS;
	CurDAQD->wChannels   = CHANNELS;
	CurDAQD->wSampleRate = SAMPLE_RATE;
	CurDAQD->wIntMsg     = HIMT_PLAY_DONE * 0x100 + bBank;
	CurDAQD->wFlags      = bBank + 1;

  lReadSize = fread( pbCurPlayBuff , sizeof( BYTE ) , DAP_BUFF_SIZE , f_point );
}



void EvalDSPMessage( WORD wMessage )
{
	switch ( HIBYTE( wMessage ) )
	{
		case HIMT_PLAY_DONE:
      CurDAQD->wSize = (WORD)lReadSize;

      if((DAPQ->wTail += PCTODSP_OFFSET(DAPQ_STRUCT_SIZE)) > DAPQ->wSize ) {
        DAPQ->wTail = 0;
      }

			SendDSPCommand( HDEX_PLAY_START );

      if( ++CurDAQD > (LPDAQD)( pMEM.p + DAPQ_DATA_BUFF + 2*DAPQ_STRUCT_SIZE ) )
					CurDAQD = (LPDAQD)( pMEM.p + DAPQ_DATA_BUFF );
      if( ( pbCurPlayBuff += DAP_BUFF_SIZE ) > (pMEM.p + 2*DAP_BUFF_SIZE))
								pbCurPlayBuff = pMEM.p;
      lReadSize = fread( pbCurPlayBuff , sizeof( BYTE ) , DAP_BUFF_SIZE, f_point );

			switch ( LOBYTE( wMessage ) )
			{
				case 0x00:
					// Bank 0 Done
					break;

				case 0x01:
					// Bank 1 Done
					break;

				case 0x02:
					// Bank 2 Done
					break;

				default:
					// Unknown Message
					break;
			}
			break;

		case HIMT_DSP:
			switch ( LOBYTE( wMessage ) )
			{
				case HIDSP_INT_PLAY_UNDER:
					printf("HIDSP_INT_PLAY_UNDER\n");
					break;

				case HIDSP_INT_RECORD_OVER:
					printf( "HIDSP_INT_RECORD_OVER\n" );
					break;

				case HIDSP_INPUT_CLIPPING:
					printf( "HIDSP_INPUT_CLIPPING\n" );
					break;

				case HIDSP_MIDI_IN_OVER:
					printf( "HIDSP_MIDI_IN_OVER\n" );
					break;

				case HIDSP_MIDI_OVERRUN_ERR:
					printf( "HIDSP_MIDI_OVERRUN_ERR\n" );
					break;

				default:
					printf("UNKNOWN_DSP_MESSAGE %X\n" , LOBYTE( wMessage) );
					break;
			}
			break;

		case HIMT_RECORD_DONE:
			printf( "HIMT_RECORD_DONE\n" );
			break;

		case HIMT_MIDI_EOS:
			printf( "HIMT_MIDI_EOS\n" );
			break;

		case HIMT_MIDI_IN_BYTE:
			printf( "HIMT_MIDI_IN_BYTE\n" );
			break;

		default:
				printf("UNKNOWN_MESSAGE %X : %X\n" , HIBYTE( wMessage ) , LOBYTE( wMessage ) );
				break;

	}
}

