/************************************************************************
 *     MultiSound Proteus Demo Start/Stop Example
 *
 *     Starts the Proteus Demo and then stops it on the users request
 *
 *
 *     Copyright 1992  Turtle Beach Systems Inc., All rights reserved.
 *
 *
 * **********************************************************************/

#include <stdio.h>
#include <msnd_dsp.h>
#include <pcontrol.h>
#include <prodemo.h>
#include <conio.h>
main()
{
	BYTE *szDataString;
	BYTE bMidiOutData;

	bIntFlag    = 0;
	bMem        = HPMEM_D000;
	bIrq        = HPIRQ_10;
	nIRQValue   = 10;
	pMEM.dw.h   = 0xD000;
	pMEM.dw.l   = 0x0000;
	wBASEIO     = 0x290;

  outp( ( wBASEIO + HP_WAIT ) , HPWAITSTATE_0 );
  outp( ( wBASEIO + HP_BITM ) , HPBITMODE_16 );

	ResetProteus();
	InitializeSMA();
	ResetDSP();
	UploadDSPCode();

  while( !*( pMEM.p ) );

	SetupMsndIRQ();

  SetMidiOutPort( MOP_PROTEUS );

	szDataString = ProDemoMidiSequence;
	while ((bMidiOutData = *szDataString++) != 0xFF) {
		MODPortWrite ( MAKEWORD( bMidiOutData , 0x00 ) );
	  if( *szDataString == 0xF7 ) {
			GetDelayTime( TIME_PRO_SYSEX );
		}
	}

	printf("Proteus demo is playing\nHit Any Key To Stop...\n");
	while( !kbhit() );
	getch();

	szDataString = ProDemoStop;
	while ((bMidiOutData = *szDataString++) != 0xFF) {
		MODPortWrite ( MAKEWORD( bMidiOutData , 0x00 ) );
	  if( *szDataString == 0xF7 ) {
			GetDelayTime( TIME_PRO_SYSEX );
		}
	}

	ResetMsndIRQ();
  return(0);
}

