#include <conio.h>
#include <time.h>
#include <dos.h>
#include "mpu.h"



/* Global Variable Definitions */
void interrupt (far *old_vec) ();		/* Saved Vector */
int		       mpu_mask;		/* Int Controller mask status */


/* The mpu functions ... */


int mpu_cmd(unsigned char cmd, long tmout) {
	long	time;

	if(tmout) {
		time = clock() + tmout;
		while(clock() < time)
			if(!(inp(MPU_STAT) & (1 << MPU_TXRDY)))
				break;
		if(inp(MPU_STAT) & (1 << MPU_TXRDY))
			return MPU_ERR_TXTMOUT;
	}
	else
		while(inp(MPU_STAT) & (1 << MPU_TXRDY))
			;

	outp(MPU_CMD, (int) cmd);
	return 0;
}


int mpu_send(unsigned char data, long tmout) {
	long	time;

	if(tmout) {
		time = clock() + tmout;
		while(clock() < time)
			if(!(inp(MPU_STAT) & (1 << MPU_TXRDY)))
				break;
		if(inp(MPU_STAT) & (1 << MPU_TXRDY))
			return MPU_ERR_TXTMOUT;
	}
	else
		while(inp(MPU_STAT) & (1 << MPU_TXRDY))
			;

	outp(MPU_DATA, (int) data);
	return 0;
}


int mpu_recv(unsigned char *datap, long tmout) {
	long	time;

	if(tmout) {
		time = clock() + tmout;
		while(clock() < time)
			if(mpu_windx != mpu_rindx)
				break;
		if(mpu_windx == mpu_rindx)
			return MPU_ERR_RXTMOUT;
	}
	else
		while(mpu_windx == mpu_rindx)
			;
		
	*datap = mpu_buf[mpu_rindx];
	if(mpu_rindx == MPU_BUFSIZ - 1)
		mpu_rindx = 0;
	else
		++mpu_rindx;

	return 0;
}


void mpu_flush(void) {
	long	time;
	int	ictl_msk;

	ictl_msk = (mpu_irq > 7) ? ICTL2_MSK : ICTL1_MSK;

	outp(ictl_msk, inp(ictl_msk) | (1 << (mpu_irq & 0x07)));

	for(;;) {
		time = clock() + CLOCKS_PER_SEC/2;
		while(clock() < time)
			if(!(inp(MPU_STAT) & (1 << MPU_RXRDY)))
				break;
		if(inp(MPU_STAT) & (1 << MPU_RXRDY))
			break;
		inp(MPU_DATA);
	}

	mpu_rindx = mpu_windx;

	outp(ictl_msk, inp(ictl_msk) & ~(1 << (mpu_irq & 0x07)));
	return;
}


int mpu_open(int irq) {
	int		stat;
	int		ictl_msk;
	int		vect_base;
	unsigned char	data;

	mpu_overflow = 0;
	mpu_rindx = 0;
	mpu_windx = 0;
	mpu_mask = 0;

	if(irq != 2 && irq != 3 && irq != 4 && irq != 7 && irq != 9)
		return MPU_ERR_BADIRQ;

	mpu_irq = (irq == 2) ? 9 : irq;

	ictl_msk = (mpu_irq > 7) ? ICTL2_MSK : ICTL1_MSK;
	vect_base = (mpu_irq > 7) ? VECT2_BASE : VECT1_BASE;

	if(inp(ictl_msk) & (1 << (mpu_irq & 0x07)))
		mpu_mask = 1;

	old_vec = _dos_getvect(vect_base + (mpu_irq & 0x07));
	_dos_setvect(vect_base + (mpu_irq & 0x07), mpu_isr);
	outp(ictl_msk, inp(ictl_msk) & ~(1 << (mpu_irq & 0x07)));

	mpu_flush();

	if(stat = mpu_cmd((unsigned char) MPU_RESET, CLOCKS_PER_SEC/2))
		goto error;

	if(!mpu_recv(&data, CLOCKS_PER_SEC/2))
		if(data != MPU_ACK) {
			stat = MPU_ERR_BADACK;
			goto error;
		}

	if(stat = mpu_cmd((unsigned char) MPU_UART, CLOCKS_PER_SEC/2))
		goto error;

	if(stat = mpu_recv(&data, CLOCKS_PER_SEC/2))
		goto error;

	if(data != MPU_ACK) {
		stat = MPU_ERR_BADACK;
		goto error;
	}

	goto exit;

error:	if(mpu_mask)
		outp(ictl_msk, inp(ictl_msk) | (1 << (mpu_irq & 0x07)));

	_dos_setvect(vect_base + (mpu_irq & 0x07), old_vec);

exit:	return stat;
}


void mpu_close() {
	unsigned char	data;
	int		ictl_msk;
	int		vect_base;

	ictl_msk = (mpu_irq > 7) ? ICTL2_MSK : ICTL1_MSK;
	vect_base = (mpu_irq > 7) ? VECT2_BASE : VECT1_BASE;

	mpu_flush();

	mpu_cmd((unsigned char) MPU_RESET, CLOCKS_PER_SEC/2);
	mpu_recv(&data, CLOCKS_PER_SEC/2);

	if(mpu_mask)
		outp(ictl_msk, inp(ictl_msk) | (1 << (mpu_irq & 0x07)));

	_dos_setvect(vect_base + (mpu_irq & 0x07), old_vec);

	return;
}

