/*****************************************************************************\
 * $Id: stat_ast.c 2.0 1994/03/14 03:22:53 dj Exp $
 * $Log: stat_ast.c $
 * Revision 2.0  1994/03/14  03:22:53  dj
 * initial version
 *
\*****************************************************************************/

/* Copyright (C) 1993 by Charles Sandmann (sandmann@clio.rice.edu)
 *
 * This software comes with ABSOLUTELY NO WARRANTY, and may be used and
 * copied freely as long as the copyright is left intact.
 */

#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <time.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <dir.h>
#include <go32.h>
#include <ctype.h>

int stat_assist(const char* filename, struct stat* statbf)
{
  struct ffblk ff;
  int i;
  struct tm tmblk;
  const char *fend = filename + strlen(filename);

  if((i = findfirst(filename, &ff, FA_DIREC|FA_HIDDEN|FA_SYSTEM)))
  {
    if (errno == ENMFILE)
      errno = ENOENT;
    return i;
  }
  memset(statbf, 0, sizeof(struct stat));

  if(ff.ff_attrib & FA_RDONLY)
    i = S_IREAD;
  else
    i = S_IREAD | S_IWRITE;
  if(ff.ff_attrib & 64)		/* Not a file, device driver or special */
    i |= S_IFCHR;
  else if(ff.ff_attrib & FA_DIREC)
    i |= S_IFDIR | S_IEXEC;
  else
  {
    i |= S_IFREG;
    if (stricmp(fend-4, ".bat") == 0
	|| stricmp(fend-4, ".com") == 0)
      i |= S_IEXEC;
    else if (stricmp(fend-2, ".o") == 0
	     || stricmp(fend-2, ".c") == 0
	     || stricmp(fend-3, ".cc") == 0)
      ;
    else
    {
      unsigned char two[2];
      int fd = open(filename, O_RDONLY|O_BINARY);
      if (fd>=0)
	if (read(fd, two, 2) == 2)
	{
	  switch ((two[1] << 8) + two[0])
	  {
	  case 0x010b:		/* a.out */
	  case 0x014c:		/* COFF */
	  case 0x2123:		/* #! script */
	  case 0x5a4d:		/* EXE */
	    i |= S_IEXEC;
	    break;
	  }
	}
      close(fd);
    }
  }
  statbf->st_mode = i | ((i>>3) & 050) | ((i>>6) & 005) ;
  statbf->st_size = ff.ff_fsize;
  statbf->st_uid = getuid();
  statbf->st_gid = getgid();
  statbf->st_ino = 42; /* dummy */
  statbf->st_nlink = 1;
  statbf->st_blksize = _go32_info_block.size_of_transfer_buffer;
  if(ff.ff_attrib & 64)		/* Not a file, device driver or special */
  {
    statbf->st_dev = statbf->st_rdev = -1;
    statbf->st_mtime = statbf->st_atime = statbf->st_ctime = 0;
    return 0;
  }
  if(filename[1] == ':')
    i = tolower(filename[0]) - 'a';
  else
    i = getdisk();		/* current drive */
  statbf->st_dev = statbf->st_rdev = i;
 
  tmblk.tm_sec = 2 * (ff.ff_ftime & 31);
  tmblk.tm_min = (ff.ff_ftime >> 5) & 63;
  tmblk.tm_hour = (ff.ff_ftime >> 11) & 31;
  tmblk.tm_mday = ff.ff_fdate & 31;
  tmblk.tm_mon = ((ff.ff_fdate >> 5) & 15) - 1;
  tmblk.tm_year = ((ff.ff_fdate >> 9) & 127) + 80;
  tmblk.tm_wday = tmblk.tm_yday = tmblk.tm_isdst = tmblk.tm_gmtoff = 0;
  tmblk.tm_zone = NULL;
  tmblk.tm_isdst = -1;

  statbf->st_ctime = mktime(&tmblk);
  statbf->st_mtime = statbf->st_atime = statbf->st_ctime;
  return 0;
}
