/* This is file MOUSE.C */
/*
** Copyright (C) 1993 DJ Delorie, 24 Kirsten Ave, Rochester NH 03867-2954
**
** This file is distributed under the terms listed in the document
** "copying.dj", available from DJ Delorie at the address above.
** A copy of "copying.dj" should accompany this file; if not, a copy
** should be available from where this file was obtained.  This file
** may not be distributed without a verbatim copy of "copying.dj".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include <stdio.h>
#include "mouse.h"
#include "sys/registers.h"
#include "ptr16.h"

static int mouse_initted = 0;
static MouseEvent last_event;
static unsigned char old_pixels[ptr16_height*ptr16_width];
static int lastx, lasty;
static mouse_fg, mouse_bg;

void MouseSetColors(int fg, int bg)
{
  mouse_fg = fg;
  mouse_bg = bg;
}

static paint_mouse(x, y)
{
  int dx, dy, o;
  for (dx=0; dx<ptr16_width; dx++)
    for (dy=0; dy<ptr16_height; dy++)
    {
      o = dx + dy * ptr16_width;
      switch (ptr16_data[o])
      {
        case 1:
          old_pixels[o] = GrPixel(x+dx, y+dy);
          GrPlot(x+dx, y+dy, mouse_bg);
          break;
        case 2:
          old_pixels[o] = GrPixel(x+dx, y+dy);
          GrPlot(x+dx, y+dy, mouse_fg);
          break;
      }
    }
}

static unpaint_mouse()
{
  int dx, dy, o;
  for (dx=0; dx<ptr16_width; dx++)
    for (dy=0; dy<ptr16_height; dy++)
    {
      o = dx + dy * ptr16_width;
      if (ptr16_data[o])
        GrPlot(lastx+dx, lasty+dy, old_pixels[o]);
    }
}

void MouseSetSpeed(int speed)
{
  REGISTERS r;
  r.ax = 15;
  r.cx = speed;
  r.dx = speed;
  int33(&r);
}

void MouseWarp(int x, int y)
{
  REGISTERS r;
  r.ax = 4;
  r.cx = last_event.x = x;
  r.dx = last_event.y = y;
  int33(&r);
}

void MouseGetEvent(int flags, MouseEvent *e)
{
  REGISTERS r;
  if (!mouse_initted)
  {
    mouse_initted = 1;
    r.ax = 0;
    int33(&r);
    r.ax = 7;
    r.cx = 0;
    r.dx = GrMaxX();
    int33(&r);
    r.ax = 8;
    r.cx = 0;
    r.dx = GrMaxY();
    int33(&r);
    MouseWarp(GrMaxX()/2, GrMaxY()/2);
    r.ax = 3;
    int33(&r);
    last_event.x = r.cx;
    last_event.y = r.dx;
    last_event.buttons = r.bx & 7;
    MouseSetSpeed(8);
    MouseSetColors(GrWhite(), GrBlack());
  }
  if (!(flags & M_NOPAINT))
    paint_mouse(last_event.x, last_event.y);
  lastx = last_event.x;
  lasty = last_event.y;
  e->flags = 0;
  while (1)
  {
    r.ax = 3;
    int33(&r);
    e->buttons = r.bx & 7;
    r.ax = 11;
    int33(&r);
    e->x = lastx + (short)r.cx;
    e->y = lasty + (short)r.dx;
    if (e->x < 0) e->x = 0;
    if (e->x > GrMaxX()) e->x = GrMaxX();
    if (e->y < 0) e->y = 0;
    if (e->y > GrMaxY()) e->y = GrMaxY();
    if (flags & M_KEYPRESS)
      if (kbhit())
      {
        e->key = getkey();
        e->flags |= M_KEYPRESS;
      }
    if ((e->x != lastx) || (e->y != lasty))
    {
      if (!(flags & M_NOPAINT))
      {
        unpaint_mouse();
        paint_mouse(e->x, e->y);
        lastx = e->x;
        lasty = e->y;    
      }
      e->flags |= M_MOTION;
    }
    if (e->buttons != last_event.buttons)
    {
      int up = (~e->buttons & last_event.buttons);
      int down = (e->buttons & ~last_event.buttons);
      if (up & M_LEFT)
        e->flags |= M_LEFT_UP;
      if (up & M_MIDDLE)
        e->flags |= M_MIDDLE_UP;
      if (up & M_RIGHT)
        e->flags |= M_RIGHT_UP;
      if (down & M_LEFT)
        e->flags |= M_LEFT_DOWN;
      if (down & M_MIDDLE)
        e->flags |= M_MIDDLE_DOWN;
      if (down & M_RIGHT)
        e->flags |= M_RIGHT_DOWN;
    }
    e->flags |= (flags & M_POLL);
    if (e->flags & flags)
      break;
  }
  e->flags &= flags;
  last_event = *e;
  last_event.flags &= ~M_KEYPRESS;
  if (!(flags & M_NOPAINT))
    unpaint_mouse();
}
