/* This is file LOCK.C */
/*
** Public domain, written by Pasi Eronen (pasi@forum.nullnet.fi).
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include <errno.h>

int _dos_lock(int, long, long);
int _dos_unlock(int, long, long);

int lock(int fd, long offset, long length)
{
  int ret = _dos_lock(fd, offset, length);
  /* change return code because Borland does it this way */
  if (ret == 0x21)
    ret = EACCES;
  if (ret != 0)
  {
    errno = ret;
    return(-1);
  }
  else
    return(0);
}

int unlock(int fd, long offset, long length)
{
  int ret = _dos_unlock(fd, offset, length);
  /* change return code because Borland does it this way */
  if (ret == 0x21)
    ret = EACCES;
  if (ret != 0)
  {
    errno = ret;
    return(-1);
  }
  else
    return(0);
}

