/*
  (c) Copyright 1992 Eric Backus

  This software may be used freely so long as this copyright notice is
  left intact.  There is no warrantee on this software.
*/

#include <pwd.h>
#include <string.h>		/* For strcmp() */
#include <stdlib.h>		/* For getenv(), getuid(), getgid() */

static struct passwd	pw;
static int counter = 0;

static void
fill_in()
{
    char	*p;

    pw.pw_name = getlogin();
    pw.pw_passwd = "*";
    pw.pw_uid = getuid();
    pw.pw_gid = getgid();
    pw.pw_age = "";
    pw.pw_comment = "";
    pw.pw_gecos = "DOS User";

    p = getenv("HOME");
    if (p)
	pw.pw_dir = p;
    else
	pw.pw_dir = "/";

    p = getenv("SHELL");
    if (p)
	pw.pw_shell = p;
    else
	pw.pw_shell = "/bin/sh";

    pw.pw_audid = -1;
    pw.pw_audflg = -1;
}

struct passwd *
getpwent(void)
{
    if (counter == 0)
    {
	counter++;
	fill_in();
	return &pw;
    }
    return NULL;
}

struct passwd *
fgetpwent(FILE *f)
{
    if (counter == 0)
    {
	counter++;
	fill_in();
	return &pw;
    }
    return NULL;
}

struct passwd *
getpwuid(int uid)
{
    fill_in();
    if (pw.pw_uid == uid) return &pw;
    return NULL;
}

struct passwd *
getpwnam(char *name)
{
    fill_in();
    if (strcmp(pw.pw_name, name) == 0) return &pw;
    return NULL;
}

void
setpwent(void)
{
  counter = 0;
}

void
endpwent(void)
{
  counter = 0;
}
