/*
  (c) Copyright 1992 Eric Backus

  This software may be used freely so long as this copyright notice is
  left intact.  There is no warrantee on this software.
*/

#include <errno.h>		/* For EINVAL */
#include <unistd.h>		/* For _SC_* */
#include <limits.h>		/* For *_MAX, etc. */
#include <time.h>		/* For CLOCKS_PER_SEC */

/* The _SC_* values for "name" should be defined in <unistd.h> */
/* The corresponding constants should be defined in <limits.h> */
long
sysconf(int name)
{
    switch (name)
    {
	/* POSIX.1 */
    case _SC_ARG_MAX:		return ARG_MAX;
    case _SC_CHILD_MAX:		return CHILD_MAX;
    case _SC_CLK_TCK:		return CLK_TCK;
    case _SC_NGROUPS_MAX:	return NGROUPS_MAX;
    case _SC_OPEN_MAX:		return OPEN_MAX;
#ifdef	_POSIX_JOB_CONTROL
    case _SC_JOB_CONTROL:	return _POSIX_JOB_CONTROL;
#else
    case _SC_JOB_CONTROL:	return -1;
#endif
#ifdef	_POSIX_SAVED_IDS
    case _SC_SAVED_IDS: 	return _POSIX_SAVED_IDS;
#else
    case _SC_SAVED_IDS:		return -1;
#endif
#ifdef	_POSIX_VERSION
    case _SC_VERSION:		return _POSIX_VERSION;
#else
    case _SC_VERSION:		return -1;
#endif

	/* POSIX.1 + X/Open */
#ifdef	_XOPEN_VERSION
    case _SC_XOPEN_VERSION:	return _XOPEN_VERSION;	/* From <unistd.h> */
#else
    case _SC_XOPEN_VERSION:	return -1;
#endif
    case _SC_PASS_MAX:		return PASS_MAX;

	/* POSIX.1-1990 */
    case _SC_STREAM_MAX:	return _POSIX_STREAM_MAX;
    case _SC_TZNAME_MAX:	return TZNAME_MAX;

	/* POSIX.2 */
    case _SC_BC_BASE_MAX:	return BC_BASE_MAX;
    case _SC_BC_DIM_MAX:	return BC_DIM_MAX;
    case _SC_BC_SCALE_MAX:	return BC_SCALE_MAX;
    case _SC_COLL_ELEM_MAX:	return COLL_ELEM_MAX;
    case _SC_EXPR_NEST_MAX:	return EXPR_NEST_MAX;
    case _SC_LINE_MAX:		return LINE_MAX;
    case _SC_PASTE_FILES_MAX:	return PASTE_FILES_MAX;
    case _SC_RE_DUP_MAX:	return RE_DUP_MAX;
    case _SC_SED_PATTERN_MAX:	return SED_PATTERN_MAX;
    case _SC_SENDTO_MAX:	return SENDTO_MAX;
    case _SC_SORT_LINE_MAX:	return SORT_LINE_MAX;
#ifdef	_POSIX2_VERSION
    case _SC_2_VERSION:		return _POSIX2_VERSION;
    case _SC_2_C_BIND:		return _POSIX2_C_BIND;
    case _SC_2_C_DEV:		return _POSIX2_C_DEV;
    case _SC_2_FORT_DEV:	return _POSIX2_FORT_DEV;
    case _SC_2_SW_DEV:		return _POSIX2_SW_DEV;
#else
    case _SC_2_VERSION:		return -1;
    case _SC_2_C_BIND:		return -1;
    case _SC_2_C_DEV:		return -1;
    case _SC_2_FORT_DEV:	return -1;
    case _SC_2_SW_DEV:		return -1;
#endif

	/* X/Open */
    case _SC_CLOCKS_PER_SEC:	return CLOCKS_PER_SEC;	/* From <time.h>! */

	/* OSF */
#ifdef	_AES_OS_VERSION
    case _SC_AES_OS_VERSION:	return _AES_OS_VERSION;
#else
    case _SC_AES_OS_VERSION:	return -1;
#endif
    case _SC_PAGE_SIZE:		return 4096;		/* From ??? */
    case _SC_ATEXIT_MAX:	return ATEXIT_MAX;

    default:
	errno = EINVAL;
	return -1;
    }
}
