/**********************************************************************
 *  
 *  NAME:           vidbuf.h
 *  
 *  DESCRIPTION:    video buffer class
 *  
 *  copyright (c) 1990 J. Alan Eldridge
 * 
 *  M O D I F I C A T I O N   H I S T O R Y
 *
 *  when        who                 what
 *  -------------------------------------------------------------------
 *  11/09/90    J. Alan Eldridge    created
 *  
 *********************************************************************/

#ifndef __VIDBUF_H
#define __VIDBUF_H

//  buffer for screen image

class vidbuf;   //  establish the name
extern vidbuf   Screen;

class vidbuf {

protected:

    int     state;      //  OK, ERR
    int     rows,       //  dimensions
            cols;
    int     yOrg,       //  origin on screen
            xOrg;
    int     yCur,       //  cursor position
            xCur;     
    vidchr  *pbuf;      //  buffer for image

    //  get ptr to vidchr at row,col
    vidchr  *vidptr(int r, int c)
        { return &pbuf[r*cols+c]; }
        
    //  update to display screen

    void    display(int row, int col, int cnt, int vflag = 1);
    void    setcursor(int vflag = 1);

    //  clear a range of a line to a value
    void    clrline(int r, int left, int right, int chr, int att);
    
    //  clear a rectangular area to a value
    void    clear(int yul, int xul, int ylr, int xlr, int chr, int att);

    //  write one character/attribute
    void    putchr(int row, int col, int chr, int att)
        { vidptr(row, col)->put(chr, att); }

public:

    //  get status
    int status()    { return  state; }
    
    //  get size, position info
    void    getul(int &y, int &x)
        { y = yOrg; x = xOrg; }
    void    getlr(int &y, int &x)
        { y = yOrg + rows - 1; x = xOrg + cols - 1; }
    void    getmaxrc(int &y, int &x)
        { y = rows-1; x = cols-1; }
        
    //  set up buffer, etc.
    void    open(int yUl, int xUl, int yLr, int xLr);

    //  free memory, etc;
    void    close();
    
    //  constructor
    vidbuf()        { state = ERR; };
    vidbuf(int yUl, int xUl, int yLr, int xLr)
        { open(yUl, xUl, yLr, xLr); }
    
    //  destructor
    virtual ~vidbuf()       { close(); }
        
    //  clear a rectangular area to a value
    void    clear()
        { clear(0, 0, rows - 1, cols - 1, ' ', vid_defaultatt); }

    //  set cursor position
    //  these are virtual because a window is derived from
    //  a vidbuf, and has additional stuff to do here
    virtual void    setpos(int y, int x)
        { yCur = y; xCur = x; }
    virtual void    getpos(int &y, int &x)
        { y = yCur; x = xCur; }
        
    //  update to display screen
    //  this is virtual because a vidbuf only knows how to
    //  refresh the entire image; a window has a "dirty
    //  region" and can do a smart refresh
    virtual void    refresh(int vflag = 1);

    // read/write from/to array of video chars
    void    write(int atrow, int atcol, vidchr *pvc, int cnt)
        { memcpy(vidptr(atrow,atcol), pvc, cnt*sizeof(vidchr)); }
    void    read(int atrow, int atcol, vidchr *pvc, int cnt)
        { memcpy(pvc, vidptr(atrow,atcol), cnt*sizeof(vidchr)); }

    //  copy from the Screen video buffer
    void    cpscreen();
        
    //  check if pointing device is in window
    int     inwindow(int &y, int &x);
};

#endif
