#ifndef __DIRENT_H__
#define __DIRENT_H__

#ifdef __GNUC__
/* DESQview/X does not replace GNU's open/read/closedir. POHC */
#include <sys/dirent.h>
#else /* __GNUC__ */
#ifdef __WATCOMC__
/* DESQview/X does not replace WATCOM's open/read/closedir. POHC */
#include <direct.h>
#else /* __WATCOMC__ */

#ifdef __NDPC__
#include <os.h>
#else
#if defined(_MSC_VER) && (_M_IX86 >= 300)
#include <pldos32.h>
#define find_t _find_t
#else
#include <dos.h>
#endif
#endif

#define MAXNAMLEN	12		/* maximum filename length */

struct dirent {
   short d_attr;
#define d_attrib d_attr
   short d_namlen;
   char d_name[MAXNAMLEN + 1];
};


typedef struct _DIR /* Tagged. POHC 90/10/09 */
	{
	unsigned short	dd_nentry;	/* current entry in directory */
	unsigned short	dd_valid;	/* whether entry is valid */
	struct find_t	dd_find_t;	/* directory entry */
	struct dirent	dd_dirent;	/* alternative directory entry */
	}	DIR;			/* stream data from opendir() */

extern DIR		*opendir(char *dirname);
extern struct dirent	*readdir(DIR *dp);
extern int		closedir(DIR *dp);

#endif /* __WATCOMC__ */
#endif /* __GNUC__*/

#ifndef NO_PROTO

#ifdef __cplusplus                      /* for C++ V2.0 */
  extern "C" {   /* do not leave open across includes */
#endif /* __cplusplus */

typedef int (*_Sortfunc) (
#if NeedFunctionPtrPrototypes
    const void *,
    const void *
#endif
);

typedef int (*_Selectfunc) (
#if NeedFunctionPtrPrototypes
    struct dirent *
#endif
);

int scandir(const char *, struct dirent ***, _Selectfunc *, _Sortfunc *);
int alphasort(const void *, const void *);

#ifdef __cplusplus                      /* for C++ V2.0 */
  }
#endif /* __cplusplus */

#else /* NO_PROTO */

int scandir();
int alphasort();

#endif /* NO_PROTO */


#endif /* __DIRENT_H_ */

