/* Project SWORD
   V2.0

   SubSystem : Little usefull graphical objects
   File      : Include/Gadgets/Box.H
   Author    : Eric NICOLAS
   Overview  : TGroupBox, TItemBox, TCheckBox, TRadioBox : Common controls
   UpDate    : Oct 23, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#ifndef _GADGETS_BOX_H_
#define _GADGETS_BOX_H_

// ----- TGroupBox

extern short RegTGroupBox;
extern char *IdentTGroupBox;

struct TGroupBox : TZone
{ int  Value;
  char *Text;
  // Constructors / Destructors
          TGroupBox();
          TGroupBox(int X, int Y, int L, int H, char *_Text=NULL);
          TGroupBox(TRect& R, char *_Text=NULL);
          void     Init(char *_Text=NULL);
  virtual ~TGroupBox(void);
          void     Done(void);
  // Graphics
  virtual void     Draw(TRect& Clip);
  // Data exchange
  virtual long     DataSize(void);
  virtual void     SetData(void *Rec);
  virtual void     GetData(void *Rec);
  // Objects streams
  virtual TAtom*   Duplicate(void);
  virtual void     Read(TDisk *file);
  virtual void     Write(TDisk *file);
};

// ----- TItemBox

extern short RegTItemBox;
extern char *IdentTItemBox;

struct TItemBox : TButton
{ char *Text;
  // Constructors
          TItemBox(int X, int Y, int L, int _Options, char *_Text);
          TItemBox(TRect& R, int _Options, char *_Text);
          TItemBox();
          void     Init(char *_Text=NULL);
  virtual ~TItemBox(void);
          void     Done(void);
  // Events
  virtual boolean   KeyDown(int ScanCode);
  // Graphics
  virtual void      DrawSelect(int Depl);
  virtual void      Draw(TRect &Rect);
  // Linked lists
         TGroupBox* Father(void);
  // Objects streams
  virtual TAtom*   Duplicate(void);
  virtual void     Read(TDisk *file);
  virtual void     Write(TDisk *file);
};

// ----- TCheckBox

extern short RegTCheckBox;
extern char *IdentTCheckBox;

struct TCheckBox : TItemBox
{ int        Mask;
  TSysIcone *Check;
  // Constructors / Destructors
          TCheckBox();
          TCheckBox(int X, int Y, int L, int _Options, int _Mask, char *_Text);
          void     Init(int _Mask=0);
  virtual ~TCheckBox(void);
          void     Done(void);
  // Graphics
  virtual void     DrawInside(int D);
  virtual void     SetColorGroup(char ColorGroup);
  // Action
  virtual void     Action(void);
  // Objects streams
  virtual TAtom*   Duplicate(void);
  virtual void     Read(TDisk *file);
  virtual void     Write(TDisk *file);
};

// ----- TRadioBox

extern short RegTRadioBox;
extern char *IdentTRadioBox;

struct TRadioBox : TItemBox
{ int     Value;
  TSysIcone *I1,*I2,*I3;
  // Constructors / Destructors
          TRadioBox(int X, int Y, int L, int _Options, int _Value, char *_Text);
          TRadioBox();
          void     Init(int _Value=0);
  virtual ~TRadioBox(void);
          void     Done(void);
  // Graphics
  virtual int      DrawFrame(void);
  virtual void     DrawInside(int D);
  virtual void     SetColorGroup(char ColorGroup);
  // Linked lists
        TRadioBox *First();
        TRadioBox *Next();
  // Action
  virtual void     Action(void);
  // Objects streams
  virtual TAtom*   Duplicate(void);
  virtual void     Read(TDisk *file);
  virtual void     Write(TDisk *file);
};

// Inline functions

inline TGroupBox* TItemBox::Father(void)
{ return (TGroupBox*)(TButton::Father());
}

inline TRadioBox* TRadioBox::First()
{ return (TRadioBox*)(TItemBox::First());
}

inline TRadioBox* TRadioBox::Next()
{ return (TRadioBox*)(TItemBox::Next());
}

inline TAtom* TGroupBox::Duplicate(void)
{ return new TGroupBox();
}

inline TAtom* TItemBox::Duplicate(void)
{ return new TItemBox();
}

inline TAtom* TRadioBox::Duplicate(void)
{ return new TRadioBox();
}

inline TAtom* TCheckBox::Duplicate(void)
{ return new TCheckBox();
}

#endif // _GADGETS_BOX_H_
