/* Project SWORD
   V2.0

   SubSystem : Little usefull graphical objects
   File      : Include/Gadgets/Menus.H
   Author    : Eric NICOLAS
   Overview  : TMenu, TMenuChoice objects : Menu Bar
   UpDate    : Nov 12, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#ifndef _GADGETS_MENUS_H_
#define _GADGETS_MENUS_H_

struct TMenu;
struct TMenuChoice;

// ===== Globals Vars =======================================================

extern TMenu *MainMenu;

// ===== TMenu Object =======================================================

extern short RegTMenu;
extern char *IdentTMenu;

struct TMenu : TStdWindow
{ // Datas
  int    wText, wHotText;
  TMenu *FatherMenu;
  // Constructors
          TMenu();
          TMenu(char *Text, int _Options=0);
          void         Init(int _Options=0);
  virtual void         InitAfterInsert();
  virtual ~TMenu(void);
  // Interaction
  virtual boolean      MouseLDown(TPoint& Where, int Buttons);
  virtual boolean      KeyDown(int ScanCode);
          void         CloseMenu(void);
  // Size computation
          void         InitChoices();
          int          CompHeight();
          int          CompWidth();
  // Drawings
  virtual void         Draw(TRect& Clip);
  // Linked lists
          TMenuChoice *FirstChoice();
          TMenuChoice *LastChoice();
          TMenuChoice *ActiveChoice();
  // Objects streams
  virtual TAtom*       Duplicate(void);
};

// ===== TMenuChoice Object =================================================

extern short RegTMenuChoice;
extern char *IdentTMenuChoice;

struct TMenuChoice : TZone
{ // Donnes  initialiser
  char  *Text;
  char  *HotText;
  int    GlobalScanCode;
  int    Command;                  // =0 si choix de sous-menu
  TMenu *SubMenu;                  // =NULL si choix d'action
  // Donnes automatiques
  int    LocalScanCode;
  int    wText, wHotText;
  // Constructeurs
          TMenuChoice();
          TMenuChoice(char *_Text, int _GlobalScanCode,
                      int _Command, int _Status=0, int _Options=0);
          TMenuChoice(char *_Text, TMenu *_SubMenu, int _Status=0);
          void Init(char *_Text, int _GlobalScanCode, int _Command,
                    TMenu *_SubMenu, int _Status, int _Options);
  virtual ~TMenuChoice(void);
          void         Done(void);
  // Graphic aspect
          void         Draw(TRect& Rect);
  virtual void         BecomeActiveZone(void);
  virtual void         LeaveActiveZone(void);
  // User action
  virtual boolean      MouseLDown(TPoint& Where, int Buttons);
          void         Down();
          void         Up();
          void         Activate();
  // Objects streams
  virtual TAtom*       Duplicate(void);
  // Linked lists
          TMenu*       Father(void);
          TMenuChoice* NextChoice();
          TMenuChoice* PrevChoice();
};

// ===== Inline functions ===================================================

inline TAtom* TMenuChoice::Duplicate(void)
{ return new TMenuChoice();
}

inline TAtom* TMenu::Duplicate(void)
{ return new TMenu();
}

inline TMenu* TMenuChoice::Father(void)
{ return (TMenu*)TZone::Father();
}

#endif // _GADGETS_MENUS_H_
