/* Project SWORD
   V2.0

   SubSystem : Basic objects, General use mecanisms
   File      : Include/Mecanism/Keyboard.H
   Author    : Eric NICOLAS
   Overview  : Defines and functions for the keyboard scanning
   UpDate    : Nov 12, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#ifndef _MECANISM_KEYBOARD_H_
#define _MECANISM_KEYBOARD_H_

// Masques Touches Toggle
#define tgRightShift       0x01
#define tgLeftShift        0x02
#define tgShift            0x03
#define tgCtrl             0x04
#define tgAlt              0x08
#define tgScroll           0x10
#define tgNum              0x20
#define tgCaps             0x40
#define tgIns              0x80

// Codes pour les touches tendues
#define ScanF1             0x3B00
#define ScanF2             0x3C00
#define ScanF3             0x3D00
#define ScanF4             0x3E00
#define ScanF5             0x3F00
#define ScanF6             0x4000
#define ScanF7             0x4100
#define ScanF8             0x4200
#define ScanF9             0x4300
#define ScanF10            0x4400
#define ScanShiftF1        0x5400
#define ScanShiftF2        0x5500
#define ScanShiftF3        0x5600
#define ScanShiftF4        0x5700
#define ScanShiftF5        0x5800
#define ScanShiftF6        0x5900
#define ScanShiftF7        0x5A00
#define ScanShiftF8        0x5B00
#define ScanShiftF9        0x5C00
#define ScanShiftF10       0x5D00

#define ScanCtrlF1         0x5E00
#define ScanCtrlF2         0x5F00
#define ScanCtrlF3         0x6000
#define ScanCtrlF4         0x6100
#define ScanCtrlF5         0x6200
#define ScanCtrlF6         0x6300
#define ScanCtrlF7         0x6400
#define ScanCtrlF8         0x6500
#define ScanCtrlF9         0x6600
#define ScanCtrlF10        0x6700

#define ScanAltF1          0x6800
#define ScanAltF2          0x6900
#define ScanAltF3          0x6A00
#define ScanAltF4          0x6B00
#define ScanAltF5          0x6C00
#define ScanAltF6          0x6D00
#define ScanAltF7          0x6E00
#define ScanAltF8          0x6F00
#define ScanAltF9          0x7000
#define ScanAltF10         0x7100

#define ScanHome           0x4700
#define ScanUpArrow        0x4800
#define ScanPageUp         0x4900
#define ScanLeftArrow      0x4B00
#define ScanRightArrow     0x4D00
#define ScanEnd            0x4F00
#define ScanDownArrow      0x5000
#define ScanPageDown       0x5100
#define ScanInsert         0x5200
#define ScanDelete         0x5300

#define ScanCtrlLeftArrow  0x7300
#define ScanCtrlRightArrow 0x7400
#define ScanCtrlEnd        0x7500
#define ScanCtrlPageDown   0x7600
#define ScanCtrlHome       0x7700

#define ScanReturn         0x000D
#define ScanCtrlReturn     0x000A
#define ScanEscape         0x001B
#define ScanTab            0x0009
#define ScanBackSpace      0x0008
#define ScanShiftTab       0x0F00

#define ScanAltQ           0x1000
#define ScanAltW           0x1100
#define ScanAltE           0x1200
#define ScanAltR           0x1300
#define ScanAltT           0x1400
#define ScanAltZ           0x1500
#define ScanAltU           0x1600
#define ScanAltI           0x1700
#define ScanAltO           0x1800
#define ScanAltP           0x1900

#define ScanAltA           0x1E00
#define ScanAltS           0x1F00
#define ScanAltD           0x2000
#define ScanAltF           0x2100
#define ScanAltG           0x2200
#define ScanAltH           0x2300
#define ScanAltJ           0x2400
#define ScanAltK           0x2500
#define ScanAltL           0x2600

#define ScanAltY           0x2C00
#define ScanAltX           0x2D00
#define ScanAltC           0x2E00
#define ScanAltV           0x2F00
#define ScanAltB           0x3000
#define ScanAltN           0x3100
#define ScanAltM           0x3200

#define ScanCtrlA          0x0001
#define ScanCtrlB          0x0002
#define ScanCtrlC          0x0003
#define ScanCtrlD          0x0004
#define ScanCtrlE          0x0005
#define ScanCtrlF          0x0006
#define ScanCtrlG          0x0007
#define ScanCtrlH          0x0008
#define ScanCtrlI          0x0009
#define ScanCtrlJ          0x000A
#define ScanCtrlK          0x000B
#define ScanCtrlL          0x000C
#define ScanCtrlM          0x000D
#define ScanCtrlN          0x000E
#define ScanCtrlO          0x000F
#define ScanCtrlP          0x0010
#define ScanCtrlQ          0x0011
#define ScanCtrlR          0x0012
#define ScanCtrlS          0x0013
#define ScanCtrlT          0x0014
#define ScanCtrlU          0x0015
#define ScanCtrlV          0x0016
#define ScanCtrlW          0x0017
#define ScanCtrlX          0x0018
#define ScanCtrlY          0x0019
#define ScanCtrlZ          0x001A

void ScanCodeUpr(int& ScanCode);
void ScanCodeLwr(int& ScanCode);
int  GetToggleStatus(void);

#endif // _MECANISM_KEYBOARD_H_
