/*
   def_plat.c - Platform DSMs with feature data for pakke
   Copyright (C) 1999-2001 by Richard Dawe

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "common.h"

#include <string.h>

static const char platform_dsm_dosemu[] = 
"# $Id: dosemu.dsm,v 1.4 2002/07/21 18:21:05 richdawe Exp $\n"
"#\n"
"# DSM file for DOSEMU \n"
"# Written by Kalum Somaratna/Grendel \n"
"#\n"
"# TODO: research a bit more about the intricacies of DOSEMU\n"
"#\n"
"\n"
"dsm-file-version: 1.4\n"
"dsm-version: 0.5.0\n"
"dsm-name: dosemu\n"
"\n"
"name: DOSEMU\n"
"version: 1.0.0\n"
"type: virtual\n"
"\n"
"dsm-author: Kalum Somaratna/Grendel\n"
"dsm-author-email: kalum@lintux.cx\n"
"\n"
"# Description\n"
"short-description: DOSEMU \n"
"\n"
"long-description: \\\n"
"A nice program that enables you to bootup a entire DOS session under UNIX.\\n\\\n"
"It still has some problems with DPMI though, you can see it screws up GCC\\n\\\n"
"quite often.... :-(\n"
"\n"
"license: GNU GPL\n"
"\n"
"web-site: http://www.dosemu.org/\n"
"\n"
"#\n"
"# Virtual capabilities provided by DOSEMU\n"
"#\n"
"provides: DPMI 0.9\n"
;

static const char platform_dsm_msdos[] = 
"# $Id: msdos.dsm,v 1.4 2002/07/21 18:21:05 richdawe Exp $\n"
"#\n"
"# DSM file for MS-DOS\n"
"# Written by Richard Dawe <richdawe@bigfoot.com> 2000-04-08\n"
"#\n"
"# TODO: This is pretty lame really - there should be different DSMs for\n"
"# different DOSes.\n"
"#\n"
"\n"
"dsm-file-version: 1.4\n"
"dsm-version: 0.5.0\n"
"dsm-name: msdos\n"
"\n"
"name: MS-DOS\n"
"version: 7\n"
"type: virtual\n"
"\n"
"dsm-author: Richard Dawe\n"
"dsm-author-email: richdawe@bigfoot.com\n"
"\n"
"# Description\n"
"short-description: DOS\n"
"license: Non-free\n"
;

static const char platform_dsm_win2k[] = 
"# $Id: win2k.dsm,v 1.4 2002/07/21 18:21:06 richdawe Exp $\n"
"#\n"
"# DSM file for MS Windows 2000\n"
"# Written by Richard Dawe, inspired by Laurynas Biveinis's Win98 DSM\n"
"#\n"
"\n"
"dsm-file-version: 1.4\n"
"dsm-version: 0.5.0\n"
"dsm-name: win2k\n"
"\n"
"name: Windows\n"
"version: 2000\n"
"type: virtual\n"
"\n"
"dsm-author: Richard Dawe\n"
"dsm-author-email: richdawe@bigfoot.com\n"
"\n"
"# Description\n"
"short-description: Windows 2000\n"
"license: Non-free\n"
"\n"
"web-site: http://www.microsoft.com/windows/\n"
"\n"
"#\n"
"# Virtual capabilities provided by Windows 2000\n"
"#\n"
"provides: DPMI 0.9\n"
"provides: LFN\n"
"provides: web-browser\n"
;

static const char platform_dsm_win3[] = 
"# $Id: win3.dsm,v 1.3 2002/07/21 18:21:06 richdawe Exp $\n"
"#\n"
"# DSM file for MS Windows 3\n"
"# Written by Richard Dawe <richdawe@bigfoot.com> 2001-03-18\n"
"#\n"
"\n"
"dsm-file-version: 1.2\n"
"dsm-version: 0.5.0\n"
"dsm-name: win3\n"
"\n"
"name: Windows\n"
"version: 3\n"
"type: virtual\n"
"\n"
"dsm-author: Richard Dawe\n"
"dsm-author-email: richdawe@bigfoot.com\n"
"\n"
"# Description\n"
"short-description: Windows 3\n"
"license: Non-free\n"
"\n"
"web-site: http://www.microsoft.com/windows/\n"
"\n"
"#\n"
"# Virtual capabilities provided by Windows 3\n"
"#\n"
"provides: DPMI 0.9\n"
;

static const char platform_dsm_win95[] = 
"# $Id: win95.dsm,v 1.4 2002/07/21 18:21:06 richdawe Exp $\n"
"#\n"
"# DSM file for MS Windows '95\n"
"# Written by Richard Dawe, inspired by Laurynas Biveinis's Win98 DSM\n"
"#\n"
"# TODO: Different versions for each version of Win95?\n"
"#\n"
"\n"
"dsm-file-version: 1.4\n"
"dsm-version: 0.5.0\n"
"dsm-name: win95\n"
"\n"
"name: Windows\n"
"version: 95\n"
"type: virtual\n"
"\n"
"dsm-author: Richard Dawe\n"
"dsm-author-email: richdawe@bigfoot.com\n"
"\n"
"# Description\n"
"short-description: Windows '95\n"
"long-description: \\\n"
"A reasonably friendly operating system that is sometimes irritating.\n"
"\n"
"license: Non-free\n"
"\n"
"web-site: http://www.microsoft.com/windows/\n"
"\n"
"#\n"
"# Virtual capabilities provided by Windows '95\n"
"#\n"
"provides: DPMI 0.9\n"
"provides: LFN\n"
"provides: web-browser\n"
;

static const char platform_dsm_win98[] = 
"# $Id: win98.dsm,v 1.5 2002/07/21 18:21:06 richdawe Exp $\n"
"#\n"
"# DSM file for MS Windows 98. Do not laugh nor contact Microsoft\n"
"# Written by Laurynas Biveinis, modifications by Richard Dawe\n"
"#\n"
"\n"
"dsm-file-version: 1.4\n"
"dsm-version: 0.5.0\n"
"dsm-name: win98\n"
"\n"
"dsm-author: Laurynas Biveinis\n"
"\n"
"# What is it?\n"
"#\n"
"name: Windows\n"
"version: 98\n"
"type: virtual\n"
"\n"
"#\n"
"# What MS doesn't say to you:\n"
"# version: 0.0.1 alpha 1\n"
"#\n"
"\n"
"binaries-dsm: win98\n"
"sources-dsm: ms-top-secret\n"
"documentation-dsm: point-n-click\n"
"\n"
"short-description: Windows 98. It pretends to be \"operating system\"\n"
"\n"
"long-description: \\\n"
"Windows 98. For some strange reason some people call it \\\n"
"\"operating system\". Hmm, strange.\n"
"\n"
"license: Non-free\n"
"\n"
"organisation: Microsoft\n"
"\n"
"#\n"
"#author: Bill Gates III\n"
"#\n"
"#author-email: billg@microsoft.com\n"
"#\n"
"#bug-report-email: /dev/null@microsoft.com\n"
"#\n"
"web-site: http://www.microsoft.com/windows/\n"
"\n"
"pre-install-readme: Insurance_For_Your_Computer.txt\n"
"post-install-readme: How_To_Recover_Your_Computer_After_Nuclear_War.txt\n"
"\n"
"builtin-pre-install-script: echo 'Please stop! Just think what are you doing'\n"
"#builtin-post-install-script: echo 'I know better what to do with Windows!'; rm -rf c:/windows\n"
"post-uninstall-script: echo 'Congratulations!!! Now I'll work 5 times faster and better'\n"
"\n"
"#-------------------\n"
"#\n"
"# Here is the reason why I've written this DSM entry file:\n"
"provides: DPMI 0.9\n"
"provides: LFN\n"
"provides: web-browser\n"
"\n"
"#-------------------\n"
"#\n"
"#requires: bugs >= 4.12.15\n"
"#\n"
"#depends-on: much better hardware than you'll ever have\n"
"#\n"
"#conflicts-with: anything_else >= 1.0\n"
"#\n"
"#replaces: every_good_soft >= 1.0\n"
"#\n"
"#duplicate-action: format c: /autotest /u\n"
"#\n"
"#install-before: death_of_your_pc\n"
"#\n"
"#install-after: you_don't_know_how_to_harm_your_pc_anymore\n"
"#\n"
"#install-warning: Please, no, don't doWARNING: system has became unstable or busy. Press an<hang>\n"
;

static const char platform_dsm_winme[] = 
"# $Id: winme.dsm,v 1.2 2002/07/21 18:21:06 richdawe Exp $\n"
"#\n"
"# DSM file for MS Windows ME\n"
"# Written by Richard Dawe, inspired by Laurynas Biveinis's Win98 DSM\n"
"#\n"
"\n"
"dsm-file-version: 1.1\n"
"dsm-version: 0.5.0\n"
"dsm-name: winme\n"
"\n"
"name: Windows-ME\n"
"version: 1\n"
"type: virtual\n"
"\n"
"dsm-author: Richard Dawe\n"
"dsm-author-email: rich@phekda.freeserve.co.uk\n"
"\n"
"# Description\n"
"short-description: Windows ME\n"
"long-description: \\\n"
"A reasonably friendly operating system that is sometimes irritating.\n"
"license: Non-free\n"
"\n"
"web-site: http://www.microsoft.com/windows/\n"
"\n"
"#\n"
"# Virtual capabilities provided by Windows ME\n"
"#\n"
"provides: DPMI 0.9\n"
"provides: LFN\n"
"provides: web-browser\n"
"\n"
"# Windows ME is a Windows platform - do this to support 'requires: Windows'.\n"
"provides: Windows\n"
;

static const char platform_dsm_winnt4[] = 
"# $Id: winnt4.dsm,v 1.4 2002/07/21 18:21:06 richdawe Exp $\n"
"#\n"
"# DSM file for MS Windows NT 4\n"
"# Written by Richard Dawe <richdawe@bigfoot.com> 2000-04-08\n"
"#\n"
"\n"
"dsm-file-version: 1.5\n"
"dsm-version: 0.5.0\n"
"dsm-name: winnt4\n"
"\n"
"name: Windows-NT\n"
"version: 4\n"
"type: virtual\n"
"\n"
"dsm-author: Richard Dawe\n"
"dsm-author-email: richdawe@bigfoot.com\n"
"\n"
"# Description\n"
"short-description: Windows NT 4\n"
"license: Non-free\n"
"\n"
"web-site: http://www.microsoft.com/windows/\n"
"\n"
"#\n"
"# Virtual capabilities provided by Windows NT 4\n"
"#\n"
"provides: DPMI 0.9\n"
"provides: web-browser\n"
"\n"
"# Windows NT is a Windows platform - do this to support 'requires: Windows'.\n"
"provides: Windows\n"
;

static const char platform_dsm_winxp[] = 
"# $Id: winxp.dsm,v 1.2 2002/07/21 18:21:06 richdawe Exp $\n"
"#\n"
"# DSM file for MS Windows XP\n"
"# Written by Richard Dawe, inspired by Laurynas Biveinis's Win98 DSM\n"
"#\n"
"\n"
"dsm-file-version: 1.1\n"
"dsm-version: 0.5.1\n"
"dsm-name: winxp\n"
"\n"
"name: Windows-XP\n"
"version: 1\n"
"type: virtual\n"
"\n"
"dsm-author: Richard Dawe\n"
"dsm-author-email: richdawe@bigfoot.com\n"
"\n"
"# Description\n"
"short-description: Windows XP\n"
"license: Non-free\n"
"\n"
"web-site: http://www.microsoft.com/windows/\n"
"\n"
"#\n"
"# Virtual capabilities provided by Windows XP\n"
"#\n"
"provides: DPMI 0.9\n"
"provides: LFN\n"
"provides: web-browser\n"
;

const char *platform_dsm_table[] = {
	platform_dsm_dosemu,
	platform_dsm_msdos,
	platform_dsm_win2k,
	platform_dsm_win3,
	platform_dsm_win95,
	platform_dsm_win98,
	platform_dsm_winme,
	platform_dsm_winnt4,
	platform_dsm_winxp,
	NULL
};
const char *platform_dsm_name_table[] = {
	"dosemu",
	"msdos",
	"win2k",
	"win3",
	"win95",
	"win98",
	"winme",
	"winnt4",
	"winxp",
	NULL
};
