/* $Id: md5hash.h,v 1.6 2002/06/23 20:28:31 richdawe Exp $ */

/*
 *  md5hash.h - Header for MD5 hash generation from files for pakke
 *  Copyright (C) 2000-2002 by Richard Dawe
 *      
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __pakke_md5hash_h__
#define __pakke_md5hash_h__

#include <libpakke/package.h>

/* --- Constants --- */

/* Size of MD5 hash in chars */
#define MD5_HASH_SIZE 16

/* --- Types --- */

typedef struct {
  char *filename;
  char  md5hash[MD5_HASH_SIZE];
} md5hash_entry;

/* --- Functions --- */

extern int md5hash_calculate (const char *filename, char result[16]);

extern int md5hash (PACKAGE_INFO * /* package */,
		    const char * /* db_path */,
		    const char * /* prefix */,
		    const char ** /* mft_path */);

extern md5hash_entry ** md5hash_get (PACKAGE_INFO *package,
				     const char *db_path);

extern int md5hash_entries_free (md5hash_entry **list);

#endif	/* __pakke_md5hash_h__ */
