/* $Id: ver.c,v 1.8 2003/03/02 18:44:25 richdawe Exp $ */

/*
 * ver.c - Test program for pakke's ver_*() functions
 * Copyright (C) 2000-2003 by Richard Dawe
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <libpakke/package.h>
#include <libpakke/mft.h>

#include "testcase.h"

/* Sanity checks */
#if PACKAGE_VERSION_N_HAS != 14
#error "Need to update test to cope with PACKAGE_VERSION's has_*"
#endif

#if PACKAGE_VERSION_N_DATA != 21
#error "Need to update test to cope with PACKAGE_VERSION's data fields"
#endif

/* Test cases */
testcase_t testcases[] = {
  /* Simple test cases */
  {
    "simp10b simple 1.0 (binaries)",
    {
      1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, /* has_* */
      1, 0, /* major, minor */
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* int version components */
      NULL, NULL, NULL, NULL, /* platform components */
      TYPE_BINARIES
    },    
  },

  /* Kitchen sink cases, i.e. everything */
  /*{
  },*/

  /* Quite unhelpful ones that should work */
  /*{
  },*/

  /* List terminator */
  { NULL }
};

/* --------
 * - main -
 * -------- */

int
main (int argc, char *argv[])
{
  PACKAGE_INFO package;
  int i;
  int verbose = 0;

  /* Verbose operation, for manual testing. */
  if (   (getenv("VERBOSE") != NULL)
      && (strcmp(getenv("VERBOSE"), "n") != 0))
    verbose = 1;

  /* Parse arguments. */
  for (i = 1; i < argc; i++) {
    /* Verbose operation, for manual testing. */
    if (   (strcmp(argv[i], "--verbose") == 0)
	|| (strcmp(argv[i], "-v") == 0))
      verbose = 1;
  }

  /* Run through the test cases. */
  for (i = 0; testcases[i].str != NULL; i++) {
    if (verbose)
      printf("Test case %i: '%s'\n", i + 1, testcases[i].str);

    /* Parse it */
    memset(&package, 0, sizeof(package));

    if (ver_parse(testcases[i].str, &package) != MFT_OK) {
      if (verbose)
	printf("Parsing failed for test case %i\n", i + 1);
      return(EXIT_FAILURE);
    }

    if (memcmp(&package.version, &testcases[i].expected,
	       sizeof(package.version)) != 0) {
      if (verbose)
	printf("Version comparison failed for test case %i\n", i + 1);
      return(EXIT_FAILURE);
    }
  }

  return(EXIT_SUCCESS);
}
