# Makefile for `Wget' utility
# Copyright (C) 1995, 1996, 1997 Free Software Foundation, Inc.

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

RM = del
CP = copy

# flags passed to recursive makes in subdirectories

# subdirectories in the distribution
SUBDIRS = src doc #util

# default target
all: Makefile $(SUBDIRS)

$(SUBDIRS): FORCE
        cd $@
        $(MAKE)
        cd ..

FORCE:

# install everything
install:
        echo Just do it.

clean:		clean-recursive		clean-top
distclean:	distclean-recursive	distclean-top
realclean:	realclean-recursive	realclean-top

clean-top:
        $(RM) *.bak
        $(RM) *.zip

distclean-top: clean-top
        $(RM) Makefile
        $(RM) config.h

realclean-top: distclean-top

clean-recursive distclean-recursive realclean-recursive:
        cd src
        $(MAKE) $(@:-recursive=)
        cd ..\\doc
        $(MAKE) $(@:-recursive=)
        cd ..

bindist: wget.zip

wget.zip: $(SUBDIRS)
        $(RM) wget.zip
        zip -Djl9 wget.zip AUTHORS COPYING INSTALL MACHINES MAILING-LIST NEWS README DOC\\sample.wgetrc
        zip -Dj9 wget.zip SRC\\WGET.EXE DOC\\WGET.HLP

