// global.h - global defines for source files.
//    Copyright (C) 2000, 2001 Laurynas Biveinis <lauras@softhome.net>
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
#ifndef GLOBAL_H_
#define GLOBAL_H_

// What autoconf made for us?
#include <config.h>

// Enable or not enable MSS?
#ifdef HAVE_MSS_H
#  define MSS
#  include <mss.h>
#endif

// Don't forget that DJGPP accepts both / and \ as path separator
inline bool is_path_separator(const char c)
{
   return (c == '/') || (c == '\\');
}

// Local TV command codes
const int cmStartInstallation = 100;
const int cmBrowse            = 101;

// Default log file name
const char * const default_log_name = "install.log";

#endif // #ifndef GLOBAL_H_
