/* $Id: mkplat.c,v 1.4 2001/07/29 18:00:17 richdawe Exp $ */

/*
 *  mkplat.c - Make def_plat.c
 *  Copyright (C) 1999, 2001 by Richard Dawe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>

char platform_copyright[] =
"/*\n"
"   def_plat.c - Platform DSMs with feature data for zippo\n"
"   Copyright (C) 1999-2001 by Richard Dawe\n"
"\n"
"    This program is free software; you can redistribute it and/or modify\n"
"    it under the terms of the GNU General Public License as published by\n"
"    the Free Software Foundation; either version 2 of the License, or\n"
"    (at your option) any later version.\n"
"\n"
"    This program is distributed in the hope that it will be useful,\n"
"    but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
"    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
"    GNU General Public License for more details.\n"
"\n"
"    You should have received a copy of the GNU General Public License\n"
"    along with this program; if not, write to the Free Software\n"
"    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.\n"
"*/\n";

/* ---------
 * - chomp -
 * --------- */

/* New-line removal, taken from ../libzippo/util.c */
void
chomp (char *str)
{
  char *p = NULL;
  if (str == NULL) return;
  for (p = str + strlen(str) - 1; (*p == '\n') || (*p == '\r'); p--) {
    *p = '\0';
  }
}

/* --------
 * - main -
 * -------- */

int
main (int argc, char *argv[])
{
  int i;
  FILE *fp = NULL;
  char buf[1024], path[PATH_MAX], *p = NULL, *q = NULL;
  char **dsms = NULL;

  /* Start a list of DSMs for later */
  dsms = malloc(sizeof(char *) * argc);
  if (dsms == NULL) return(EXIT_FAILURE);
  for (i = 0; i < argc; i++) { dsms[i] = NULL; }

  /* Start the header */
  printf("%s\n"	 
	 "#include \"common.h\"\n\n"
	 "#include <string.h>\n\n",
	 platform_copyright);

  for (i = 1; i < argc; i++) {
    /* Get the DSM stem name */
    strcpy(path, argv[i]);
    p = strrchr(path, '/');
    if (p != NULL) { *p = '\0', p++; } else { p = path; }
    q = strrchr(p, '.');
    if (q != NULL) *q = '\0';

    dsms[i - 1] = strdup(p);
  }

  for (i = 1; i < argc; i++) {
    fp = fopen(argv[i], "rt");
    if (fp == NULL) return(EXIT_FAILURE);

    printf("static const char platform_dsm_%s[] = \n", dsms[i - 1]);
    while (fgets(buf, sizeof(buf), fp) != NULL) {
      /* Fix-up the output - escapes, etc. */
      chomp(buf);

      for (p = buf; (p = strchr(p, '\\')) != NULL; ) {
	memmove(p + 1, p, strlen(p) + 1);
	*p = '\\', p += 2;
      }

      for (p = buf; (p = strchr(p, '"')) != NULL; ) {
	memmove(p + 1, p, strlen(p) + 1);
	*p = '\\', p += 2;
      }

      /* Now output */
      printf("\"%s\\n\"\n", buf);
    }
    printf(";\n\n");
    fclose(fp);
  }

  printf("const char *platform_dsm_table[] = {\n");
  for (i = 0; dsms[i] != NULL; i++) {
    printf("\tplatform_dsm_%s,\n", dsms[i]);
  }
  printf("\tNULL\n};\n");

  printf("const char *platform_dsm_name_table[] = {\n");
  for (i = 0; dsms[i] != NULL; i++) {
    printf("\t\"%s\",\n", dsms[i]);
  }
  printf("\tNULL\n};\n");

  return(EXIT_SUCCESS);
}
