%{
/* $Id: rc.l,v 1.4 2002/01/13 12:46:45 richdawe Exp $ */

#include <stdlib.h>
#include <string.h>
#include <limits.h>

#include "rcfile.h"
#include "rc_tab.h"
%}

%option yylineno
%option noyywrap

%x LOCATION
%x RESOURCE

SUBSTITUTION         @[A-Za-z0-9][A-Za-z0-9_\-]*[A-Za-z0-9]*@

PATH_CHAR            [A-Za-z0-9_\-\.\~\#\$\+]
QUOTED_PATH_CHAR     ({PATH_CHAR}|[ \t])

DRIVE_SPEC           [A-Za-z]:
REL_PATH_COMP        {PATH_CHAR}*
ABS_PATH_COMP        \/{REL_PATH_COMP}
QUOTED_REL_PATH_COMP {QUOTED_PATH_CHAR}*
QUOTED_ABS_PATH_COMP \/{QUOTED_REL_PATH_COMP}
PATH_SPEC            ({SUBSTITUTION}|{REL_PATH_COMP}|{ABS_PATH_COMP})+
QUOTED_PATH_SPEC     ({SUBSTITUTION}|{QUOTED_REL_PATH_COMP}|{QUOTED_ABS_PATH_COMP})+

DOS_PATH             {DRIVE_SPEC}{PATH_SPEC}?
QUOTED_DOS_PATH      \"{DRIVE_SPEC}{QUOTED_PATH_SPEC}?\"
PATH                 {PATH_SPEC}
QUOTED_PATH          \"{QUOTED_PATH_SPEC}\"

URL_SCHEME           [A-Za-z0-9\-]+:\/\/
URL_DOMAIN           \.[A-Za-z0-9\-]+
URL_HOST             [A-Za-z0-9\-]+{URL_DOMAIN}*
URL_PATH             {ABS_PATH_COMP}*

URL                  ({SUBSTITUTION}|{URL_SCHEME}{URL_HOST}{URL_PATH})

COUNTRY_CODE         [A-Za-z]{2}

%%

^#[^\n]*  /* comment */

installed { return(TOK_INSTALLED); }
available { return(TOK_AVAILABLE); }
mft       { return(TOK_MFT); }
dsm       { return(TOK_DSM); }

zip       { return(TOK_ZIP); }
tar-gzip  { return(TOK_TAR_GZIP); }
tar-bzip2 { return(TOK_TAR_BZIP2); }

proxy     { return(TOK_PROXY); }
http      { return(TOK_HTTP); }
ftp       { return(TOK_FTP); }
location  { BEGIN(LOCATION); return(TOK_LOCATION); }

from      { BEGIN(RESOURCE); return(TOK_FROM); }
using     { BEGIN(RESOURCE); return(TOK_USING); }
with      { BEGIN(RESOURCE); return(TOK_WITH); }

<*>,      { return(TOK_OR); }
<*>or     { return(TOK_OR); }

<LOCATION>is { return(TOK_IS); }

<LOCATION>{COUNTRY_CODE} {
rcfile_yylval.str = rcfile_yytext;
return(TOK_COUNTRY_CODE);
}

<RESOURCE>{URL} {
rcfile_yylval.str = rcfile_yytext;
return(TOK_URL);
}

<RESOURCE>{DOS_PATH} {
#ifdef MSDOS
/* Allow on MS-DOS... */
rcfile_yylval.str = rcfile_yytext;
return(TOK_PATH);
#else
/* otherwise consume it. */
#endif
}

<RESOURCE>{QUOTED_DOS_PATH} {
#ifdef MSDOS
/* Allow on MS-DOS... */
static char qdp_buf[PATH_MAX + 1];

/* Nuke quotes */
strncpy(qdp_buf, rcfile_yytext + 1, sizeof(qdp_buf));
qdp_buf[PATH_MAX] = '\0';
qdp_buf[strlen(qdp_buf) - 1] = '\0';

rcfile_yylval.str = qdp_buf;
return(TOK_PATH);
#else
/* otherwise consume it. */
#endif
}

<RESOURCE>{PATH} {
rcfile_yylval.str = rcfile_yytext;
return(TOK_PATH);
}

<RESOURCE>{QUOTED_PATH} {
static char qp_buf[PATH_MAX + 1];

/* Nuke quotes */
strncpy(qp_buf, rcfile_yytext + 1, sizeof(qp_buf));
qp_buf[PATH_MAX] = '\0';
qp_buf[strlen(qp_buf) - 1] = '\0';

rcfile_yylval.str = qp_buf;
return(TOK_PATH);
}

[^ \t\n]+ { return(TOK_UNKNOWN); }

<*>[ \t]+ /* eat whitespace */
<*>\n     { BEGIN(INITIAL); return(TOK_EOL); }

%%
