%{
/* $Id: rc.y,v 1.5 2002/02/13 21:16:34 richdawe Exp $ */

#include <stdlib.h>
#include <string.h>

#include "rcfile.h"

rc_resource_t res = RC_NONE;

#define YYERROR_VERBOSE
%}

%union {
  char *str;
}

%token TOK_INSTALLED
%token TOK_AVAILABLE
%token TOK_MFT
%token TOK_DSM

%token TOK_ZIP
%token TOK_TAR_GZIP
%token TOK_TAR_BZIP2

%token TOK_PROXY
%token TOK_HTTP
%token TOK_FTP

%token TOK_LOCATION

%token TOK_IS

%token TOK_FROM
%token TOK_USING
%token TOK_WITH
%token TOK_OR

%token <str> TOK_PATH
%token <str> TOK_URL
%token <str> TOK_COUNTRY_CODE

%token TOK_UNKNOWN
%token TOK_EOL

%%

DEFINITION:
  /* empty */
| INSTALLED_MFT TOK_EOL DEFINITION
| INSTALLED_DSM TOK_EOL DEFINITION
| AVAILABLE_DSM TOK_EOL DEFINITION
| ZIP           TOK_EOL DEFINITION
| TAR_GZIP      TOK_EOL DEFINITION
| TAR_BZIP2     TOK_EOL DEFINITION
| HTTP_PROXY    TOK_EOL DEFINITION
| FTP_PROXY     TOK_EOL DEFINITION
| HTTP_MIRROR   TOK_EOL DEFINITION
| FTP_MIRROR    TOK_EOL DEFINITION
| LOCATION      TOK_EOL DEFINITION
|               TOK_EOL DEFINITION
| error         TOK_EOL DEFINITION { yyerrok; }
;

USING_OR_WITH: TOK_USING | TOK_WITH;

PATH:         TOK_PATH         { rcfile_add_resource(res, $1); };
URL:          TOK_URL          { rcfile_add_resource(res, $1); };
COUNTRY_CODE: TOK_COUNTRY_CODE { rcfile_add_resource(res, $1); };

PATHS:
  PATH
| PATH TOK_OR PATHS
;

URLS:
  URL
| URL TOK_OR URLS
;

PATHS_OR_URLS:
  PATH
| URL
| PATH TOK_OR PATHS_OR_URLS
| URL  TOK_OR PATHS_OR_URLS
;

/* Preludes, to set 'res' correctly. */
INSTALLED_MFT_PRE: TOK_INSTALLED TOK_MFT  { res = RC_INSTALLED_MFT; };
INSTALLED_DSM_PRE: TOK_INSTALLED TOK_DSM  { res = RC_INSTALLED_DSM; };
AVAILABLE_DSM_PRE: TOK_AVAILABLE TOK_DSM  { res = RC_AVAILABLE_DSM; };
ZIP_PRE:           TOK_ZIP                { res = RC_ZIP; };
TAR_GZIP_PRE:      TOK_TAR_GZIP           { res = RC_TAR_GZIP; };
TAR_BZIP2_PRE:     TOK_TAR_BZIP2          { res = RC_TAR_BZIP2; };
HTTP_PROXY_PRE:    TOK_PROXY     TOK_HTTP { res = RC_HTTP_PROXY; };
FTP_PROXY_PRE:     TOK_PROXY     TOK_FTP  { res = RC_FTP_PROXY; };
HTTP_MIRROR_PRE:   TOK_HTTP               { res = RC_HTTP_MIRROR; }
FTP_MIRROR_PRE:    TOK_FTP                { res = RC_FTP_MIRROR; }
LOCATION_PRE:      TOK_LOCATION           { res = RC_LOCATION; }

INSTALLED_MFT: INSTALLED_MFT_PRE TOK_FROM      PATHS;
INSTALLED_DSM: INSTALLED_DSM_PRE TOK_FROM      PATHS;
AVAILABLE_DSM: AVAILABLE_DSM_PRE TOK_FROM      PATHS ;
ZIP:           ZIP_PRE           TOK_FROM      PATHS_OR_URLS;
TAR_GZIP:      TAR_GZIP_PRE      TOK_FROM      PATHS_OR_URLS;
TAR_BZIP2:     TAR_BZIP2_PRE     TOK_FROM      PATHS_OR_URLS;
HTTP_PROXY:    HTTP_PROXY_PRE    USING_OR_WITH URLS;
FTP_PROXY:     FTP_PROXY_PRE     USING_OR_WITH URLS;
HTTP_MIRROR:   HTTP_MIRROR_PRE   TOK_FROM      URLS;
FTP_MIRROR:    FTP_MIRROR_PRE    TOK_FROM      URLS;
LOCATION:      LOCATION_PRE      TOK_IS        COUNTRY_CODE;

%%
