#!/bin/bash
#
# $Id: tryinst.sh,v 1.2 2002/03/10 21:32:38 richdawe Exp $
# Copyright (C) 2001 by Richard Dawe
#
# Try a DJGPP installation using zippo. This assumes that you have a mirror
# of the DJGPP archive available and specified in the 'share/zippo/zipporc'
# file in you DJGPP directory. The base directory of the the DJGPP archive
# should be given as a command-line argument.
#
# Example:
#
#     <this-script> z:/djgpp-mirror
#
# When prompted whether to overwrite DSMs on installation of djgpp-dsms,
# choose to skip overwriting the already installed files. The DSMs from
# zippo's sources are likely to have bugfixes over the ones in the packages
# on Simtel.NET.
#

# What are we doing?
set -x

TOP=$(pwd)/../..

# Mirror path
MIRRORDIR=$1
shift

if [ "a$MIRRORDIR" = "a" ]; then
    echo "Syntax: $0 <mirror-directory>"
    exit 1
fi

# Assume that we have a 5 digit PID.
TESTDIR=${TMPDIR}/zip$$

# Guess the executable extension, if any.
if [ -f ${TOP}/bin/zippo.exe ]; then
    EXEEXT=.exe
else
    EXEEXT=
fi

# How should we invoke zippo?
SRCZIPPO=${TOP}/bin/zippo${EXEEXT}
ZIPPO=${TESTDIR}/bin/zippo${EXEEXT}
ZIPPOOPTS="--verbose --root ${TESTDIR}"
Z="${ZIPPO} ${ZIPPOOPTS}"

# Create the configuration file. Copy the one from the DJGPP directory,
# because we've probably customised that to point at a mirror
# of the DJGPP archive or part thereof.
mkdir -p ${TESTDIR}/share/zippo
cp -v ${DJDIR}/share/zippo/zipporc ${TESTDIR}/share/zippo

# Create the zippo database.
${SRCZIPPO} ${ZIPPOOPTS} --initdb --with-zippo || exit 1

# Check that we're using the right version.
${SRCZIPPO} ${ZIPPOOPTS} --version > ${TESTDIR}/srczippo.ver
${Z} ${ZIPPOOPTS} --version        > ${TESTDIR}/zippo.ver

diff ${TESTDIR}/srczippo.ver ${TESTDIR}/zippo.ver \
    || ( echo "zippo installation into ${TESTDIR} failed!"; exit 1 )

# Find the latest available DSM package and install it.
DSMPACKAGE=$(find ${MIRRORDIR}/v2 -name 'ds[0-9]*.zip' | sort | tail -n 1)
${Z} --install $DSMPACKAGE || exit 1

# Update the available DSMs from the zippo distribution.
# We may have fixed some bugs in the ones distributed in DJGPP packages.
mkdir -p ${TESTDIR}/share/zippo/db-avail
cp -uv ${TOP}/share/zippo/db-avail/*.dsm ${TESTDIR}/share/zippo/db-avail

# Install DJGPP packages.
${Z} --install ${MIRRORDIR}/v2/djdev203.zip || exit 1

# HACK: Add a provide to the installed djdev, to allow Perl to install.
grep djgpp-dev-env ${TESTDIR}/share/zippo/db/djdev203.dsm \
    || echo "provides: djgpp-dev-env" \
    >> ${TESTDIR}/share/zippo/db/djdev203.dsm

# djdev 2.03's DSM may be stale compared with zippo's djdev 2.03 DSM.
# Synchronise to use the zippo copy.
#${Z} --syncdb || exit 1

${Z} --install ${MIRRORDIR}/v2gnu/bsh204b.zip || exit 1
# TODO: Remove texinfo DSM for share/zippo/db-avail and then try
# to install with zippo guessing the DSM.
#${Z} --install ${MIRRORDIR}/v2gnu/txi40b.zip || exit 1
${Z} --install ${MIRRORDIR}/v2gnu/bnu2112b.zip || exit 1
${Z} --install ${MIRRORDIR}/v2gnu/gcc304b.zip || exit 1
${Z} --install ${MIRRORDIR}/v2gnu/gpp304b.zip || exit 1
${Z} --install ${MIRRORDIR}/v2gnu/fil40b.zip || exit 1
#${Z} --install -A "sed 3.02 (binaries)" || exit 1
${Z} --install ${MIRRORDIR}/v2gnu/sed3028b.zip || exit 1
${Z} --install ${MIRRORDIR}/v2gnu/perl561b.zip || exit 1
${Z} --install -A "m4 1.4 (binaries)" || exit 1
${Z} --install -A "autoconf 2.13 (binaries)" || exit 1
${Z} --install -A "automake 1.4 (binaries)" || exit 1
