.\" Process this file with
.\" groff -man -Tascii setedit.man
.\"
.TH SETEDIT 1 "AUGUST 1999" "v0.4.34"
.SH NAME
setedit \- a friendly text editor
.SH SYNOPSIS
.B setedit [
.I options
.B ] [
.I file_name
.B ...]
.SH DESCRIPTION
.B setedit
is a friendly console text editor with the look and feel of the Borland
editors for DOS. This man page only describes the command line options of
the editor. You can get full help about the editor using the help of the
editor.
.PP
Any number of file names can be specified after the options and they will be
automatically loaded by the editor in the same order you listed them.
.SH OPTIONS
.IP "-s, --no-signal"
Disables the hook of signals to save the modified buffers during a crash.
Could be needed if the editor hangs in an extraordinary way. Usually the
editor dumps to
.B stderr
all the files you didn't save, as the
.B stderr
is redirected by the editor to a temporal file you can recover unsaved data.
This temporal file is stored in your home directory for
.SM Linux
and in
.I %DJDIR%/share/setedit
for
.SM DOS.
.IP "-r, --no-redirect"
Use the alternate system wide
.I config-file
Disables the stderr redirection. Only used during debugging process, if you
don't do it while debugging you won't be able to collect debugging
information sent to the
.B stderr
output.
.IP "-k, --use-rh-52-keys"
.B "[Only for Linux]"
Enables the Red Hat 5.2 style keyboard mapping. That's needed if you are
experimenting some strange function keys behavior. Some keyboard mapping
files redefines the function key numbers in a good way but really
incompatible with the old way. I first found it in Red Hat 5.2.
.IP "-l, --force-no-lfn"
.B "[Only for DOS]"
Avoids the use of long file names under W9x. Even if the
.B LFN
environment variable says the reverse.
.IP "-L, --force-lfn"
.B "[Only for DOS]"
Forces the use of long file names under W9x. Even if the
.B LFN
environment variable says the reverse.
.IP "-m, --no-mouse-hook"
.B "[Only for DOS]"
Don't hook the mouse interrupt. Currently this is done automagically if
.I "Windows NT"
is detected but it could help if you are having serious problems with the
mouse.
.IP "-p, --project file_name"
Loads the indicated project, if the file doesn't exist the editor creates
a new one.
.IP "-h, --help"
Displays the command line options of the editor.
.SH FILES
.I "/usr/share/setedit/*.pmc %DJDIR%/share/setedit/*.pmc"
.RS
Pseudo macro files.
.RE
.I "%DJDIR%/share/setedit/*.sft"
.RS
Editor fonts.
.RE
.I "~/.deflopts.txt %DJDIR%/share/setedit/deflopts.txt"
.RS
Default edition options for each syntax highlight mode.
.RE
.I "/usr/share/setedit/editor.tip %DJDIR%/share/setedit/editor.tip"
.RS
Tip of the day file.
.RE
.I "%DJDIR%/share/setedit/extrscsv.txt"
.RS
External screen savers list.
.RE
.I "/usr/share/setedit/*.frt %DJDIR%/share/setedit/*.frt"
.RS
Format files for the documentation generator module.
.RE
.I "%DJDIR%/share/setedit/install.log"
.RS
Log file created by the installer.
.RE
.I "~/.keybind.dat %DJDIR%/share/setedit/keybind.dat"
.RS
Keyboard bindings configured by the user.
.RE
.I "/usr/share/setedit/macros.slp %DJDIR%/share/setedit/macros.slp"
.RS
sLisp macros file.
.RE
.I "/usr/share/setedit/menubind.smn %DJDIR%/share/setedit/menubind.smn"
.RS
Menu bindings.
.RE
.I "~/.setenvir.dat %DJDIR%/share/setedit/setenvir.dat"
.RS
Environment variables visible only while inside the editor.
.RE
.I "/usr/share/setedit/syntaxhl.shl %DJDIR%/share/setedit/syntaxhl.shl"
.RS
Syntax highlight configuration file.
.RE
.I "~/.userword.txt %DJDIR%/share/setedit/userword.txt"
.RS
User words for each syntax highlight.
.SH ENVIRONMENT
.IP SET_FILES
Indicates where the configuration files are located. If not defined the
editor will guess the location.
.IP INFOPATH
Indicates where help files in info format are located. If not defined the
editor will guess the location.
.SH AUTHOR
Salvador Eduardo Tropea <salvador@inti.gov.ar>
