/* Copyright (C) 1996,1997,1998,1999 by Salvador E. Tropea (SET),
   see copyrigh file for details */
#define Uses_TSListBox
#include <easydia1.h>
#include <tv.h>
#include <easydiag.h>

TSListBox::TSListBox(int width, int height, int scrolls, int cols,
                     tMakeListBox MakeListBox) :
  TSView()
{
 w=width;
 h=height;
 scrollType=scrolls;

 switch (scrolls)
   {
    case tsslbNo:
         view=MakeListBox(TRect(0,0,width,height),cols,0);
         break;

    case tsslbVertical:
         scrollBar=new TScrollBar(TRect(0,0,1,height));
         view=MakeListBox(TRect(0,0,width-1,height),cols,scrollBar);
         break;

    case tsslbHorizontal:
         scrollBar=new TScrollBar(TRect(0,0,width,1));
         view=MakeListBox(TRect(0,0,width,height-1),cols,scrollBar);
         break;
   }
}


void TSListBox::insert(TDialog *d)
{

 switch (scrollType)
   {
    case tsslbNo:
         TSView::insert(d);
         break;

    case tsslbVertical:
        {
         TRect r(x,y,x+w-1,y+h);
         view->locate(r);
         d->insert(view);
         scrollBar->moveTo(x+w-1,y);
         d->insert(scrollBar);
        }
         break;

    case tsslbHorizontal:
        {
         TRect r(x,y,x+w,y+h-1);
         view->locate(r);
         d->insert(view);
         TRect r2(x,y+h-1,x+w,y+h);
         scrollBar->locate(r2);
         d->insert(scrollBar);
        }
         break;
   }
}

// Just a TListBox object
TView *TSListBoxMakeListBox(const TRect& bounds, unsigned aNumCols,
                            TScrollBar *aScrollBar)
{
 return new TListBox(bounds,aNumCols,aScrollBar);
}
