This is Info file rhide.inf, produced by Makeinfo version 1.67 from the
input file rhide.num.

START-INFO-DIR-ENTRY
* RHIDE: (rhide.inf).   Documentation about RHIDE, an IDE for DJGPP or linux.
END-INFO-DIR-ENTRY

This is the documentation for the Integrated Development Environment RHIDE.

Copyright (C) 1996,1997 Robert Hhne

This documentation may be freely distributed with the RHIDE package or any
part thereof, provided this copyright notice is left intact on all copies.


File: rhide.inf,  Node: Cursor moving commands,  Next: Text selecting and searching commands,  Prev: Erasing commands,  Up: How the editor works

4.2.2 Cursor moving commands
----------------------------

   * <Ctrl+S>  or <Arrow left> moves the cursor one character left

   * <Ctrl+D>  or <Arrow right> moves the cusor one character right

   * <Ctrl+E>  or <Arrow up> moves the cursor one line up

   * <Ctrl+X>  or <Arrow down> moves the cursor one line down

   * <Ctrl+A>  moves the cursor one word left

   * <Ctrl+F>  moves the cursor one word right

   * <Ctrl+C>  or <Page down> moves the cursor one page down

   * <Ctrl+R>  or <Page up> moves the cursor one page up

   * <Ctrl+Q+D>  or <End> moves the cursor to the end of the line

   * <Ctrl+Q+S>  or <Home> moves the cursor to the beginning of the line

   * <Ctrl+Q+R>  or <Ctrl+PgUp>

     or <Ctrl+Home> moves the cursor to the beginning of the file

   * <Ctrl+Q+C>  or <Ctrl+PgDown>

     or <Ctrl+End> moves the cursor to the end of the file


File: rhide.inf,  Node: Text selecting and searching commands,  Next: Block commands,  Prev: Cursor moving commands,  Up: How the editor works

4.2.3 Text selecting and searching commands
-------------------------------------------

   * <Shift>  cursor keys select the text like the cursor moves

   * <Ctrl+Ins>  or <Ctrl+K+K>  copy the selected text to the clipboard

   * <Shift+Del>  or <Ctrl+K+Y>  move the selected text to the clipboard

   * <Shift+Ins>  or <Ctrl+K+C>  copy the selected text from the clipboard
     to the current cursor position

   * <Ctrl+Del>  delete the selected text

   * <Ctrl+Q+A>   open the replace dialog

   * <Ctrl+Q+F>  open the find dialog

   * <Ctrl+L>  repeat the last replace or find operation

   * <Ctrl+K+H>  unselect all


File: rhide.inf,  Node: Block commands,  Next: Other commands,  Prev: Text selecting and searching commands,  Up: How the editor works

4.2.4 Block commands
--------------------

   * <Ctrl+K+B>  this sets the start of the selected block

   * <Ctrl+K+K>  this sets the end of the selected block

   * <Ctrl+K+I>  this indents the selected block by inserting a space at
     the beginning of each line inside the block

   * <Ctrl+K+U>  the unindents the selected block by erasing from each
     line inside the block, which starts with a tab or space one character.

   * <Ctrl+K+M>  this converts all alpha characters inside the selected
     block to upper case

   * <Ctrl+K+O>  this converts all alpha characters inside the selected
     block to lower case

   * <Ctrl+K+V>  this moves the selected block to the current cursor
     position

   * <Ctrl+K+Tab>  this is indents the selected block by using the last
     nonselected line as reference for indenting.

   * <Ctrl+K+Shift+Tab>  this unindents the selected block by using the
     last nonselected line as reference for unindenting

   * <Ctrl+K+R>  Inserts the contents of a file at the current cursor
     position

   * <Ctrl+K+W>  Write the selected block to a file


File: rhide.inf,  Node: Other commands,  Prev: Block commands,  Up: How the editor works

4.2.5 Other commands
--------------------

   * <Ctrl+V>  toggle insert-/overwrite-mode

   * <Ctrl+O>  toggle auto-indent-mode on/off

   * <Ctrl+J>  goto to line (will be prompted for)

   * <Ctrl+K+>  a digit (<0> - <9>). Set a marker in the text (up to ten
     different markers)

   * <Ctrl+Q+>  a digit (<0> - <9>). Jump to a marker, which you have
     previously set.

   * <Shift+Space>  this executes a macro, which can be defined external
     by analyzing the last two characters before the cursor (*Note
     Defining macros::)

If you have set some markers, they will be stored, so you can use them
later when restarting RHIDE.


File: rhide.inf,  Node: Some hints and problems,  Next: Project window,  Prev: How the editor works,  Up: Detailed description of some parts of RHIDE

4.3 Some hints and problems
===========================

To compile only a single file, you don't need to include it in a project.
You only have to open it and do a compile. If a file is in your project,
you can compile it, if you are in its editor-window or if you are in the
project-window and this file is selected.

Warnings and errors from compiling a file are listed in the message-window.
If there are warnings or errors, you can jump to the corresponding source
by hitting <ENTER>  on this message. If this file wasn't already opened,
it will be opened.

* Menu:

* Problems with automatic dependencies::


File: rhide.inf,  Node: Problems with automatic dependencies,  Prev: Some hints and problems,  Up: Some hints and problems

4.3.1 Problems with automatic dependencies
------------------------------------------

Most checking of the dependencies works correctly, but there are some few
situations, where this checking gets confused. The first results in the
fact that I implemented a cache function for getting the modification time
of files, that means, most files are 'stat'ed only once, after starting
RHIDE. But if someone modifies one of the files, which are in the cache,
(this can be an other program, when you run RHIDE in a multitasking
environment, such Windows) or if you run your project and it modifies some
of these files, the internal cache is after this not up to date.

Here is an other situation. Your source files are not in the current
directory. You have opened a source file for editing and successfully
built your project. Now you leave RHIDE, because you want to debug your
program with `fsdb', you copy the source file (in this case it is the
file, which you have opened in the IDE) to the current directoy. Now you
debug it and there are some errors. You restart RHIDE to make the changes
in the file. The previously opened file will be opened automatically and
you edit it. If you do now a *Make*, RHIDE tells you, that your project is
up to date, because it searches for source files at first in the current
directory, and there is the unmodified file.

In this chapter I will give you for some special parts a more detailed
description of what they do.


File: rhide.inf,  Node: Project window,  Next: Builtin compiler specs,  Prev: Some hints and problems,  Up: Detailed description of some parts of RHIDE

4.4 Project window
==================

The project window shows you every file, which you have included in your
project. Most time you work with RHIDE this window should be visible, but
you can also close it (*Note Close::).

* Menu:

* Items of your project::
* Open a project item::
* Dependencies of project item::
* Local options for a project item::


File: rhide.inf,  Node: Items of your project,  Next: Open a project item,  Prev: Project window,  Up: Project window

4.4.1 Items of your project
---------------------------

The items in the project window, and therefore also in your project, are
sorted in alphabetical order. This has the effect of faster finding an
item and you can also move the selecting bar to a specified item by typing
the name of this item.

Normally, the alphabetic order of the project items causes no problems
because the linker searches at first *every* object file for unresolved
symbols before any library. The statement, the the GNU linker is a one pass
linker makes sense only for libraries, because they are checked only once
for unresolved references. That means, if you include libraries in your
project you must know about the order, where this library is put on the
command line when linking your program.

If you have problems with that order, or if you really want to have one
object file (or library) before some others, you have to rename them, to
get the right position from the name.


File: rhide.inf,  Node: Open a project item,  Next: Dependencies of project item,  Prev: Items of your project,  Up: Project window

4.4.2 Open a project item
-------------------------

To open an editor window with the selected item press either <SPACE> or
<ENTER> . If here was already a window with this file opened on the
desktop, this window will be selected. This works only if the selected
item has a know suffix (*Note Known suffixes::). If the selected item is a
project file, that project will be opened with the side effect that if you
close this project, the previous one will be reopened.


File: rhide.inf,  Node: Dependencies of project item,  Next: Local options for a project item,  Prev: Open a project item,  Up: Project window

4.4.3 Dependencies of project item
----------------------------------

If you have compiled a file already in RHIDE, you bring up a list with all
dependencies of that file. In this list the files are show by their
basename followed by the directory and they are also sorted in alphabetical
order. From here you can also open an editor window with the selected
dependency by pressing <SPACE> or <ENTER>  on that item.


File: rhide.inf,  Node: Local options for a project item,  Prev: Dependencies of project item,  Up: Project window

4.4.4 Local options for a project item
--------------------------------------

You can change many options for a project item, which are in effect only
for this file. To do this, hit <Ctrl+O>  on the selected item and a dialog
is shown, where you can change the options.

At this time you can change the following options.

* Menu:

* Local comandline options::
* Exclude from link::
* Name of the output file::
* Compiler type::
* Error checking::
* Error program::


File: rhide.inf,  Node: Local comandline options,  Next: Exclude from link,  Prev: Local options for a project item,  Up: Local options for a project item

Local comandline options
........................

Here you can give some additional defines or any other commandline
options, when compiling this item.


File: rhide.inf,  Node: Exclude from link,  Next: Name of the output file,  Prev: Local comandline options,  Up: Local options for a project item

Exclude from link
.................

This is a switch to tell RHIDE, that this file should not linked with your
program, but it is compiled and it is checked to determine if your program
is up to date.


File: rhide.inf,  Node: Name of the output file,  Next: Compiler type,  Prev: Exclude from link,  Up: Local options for a project item

Name of the output file
.......................

Here you can specify an other name as the compiled file. Put here only the
basename of the file (without any directory)


File: rhide.inf,  Node: Compiler type,  Next: Error checking,  Prev: Name of the output file,  Up: Local options for a project item

Compiler type
.............

From that list you can select exactly one type of the compiler, which is
used to create your output file. Possible values are:

`Auto'
     This is the default and should be used in most cases. When this type
     is selected, RHIDE selects the correct compiler depending on the
     suffixes of your source and output file.

`User'
     If you have any special compiler, which is not known to RHIDE, to
     create your output file, you must select this and give RHIDE also the
     calling syntax of that compiler (see below)

`None'
     If you don't want to compile this item select this.

`GNU C compiler'
     Tell RHIDE to compile this file like a normal GNU C source file.

`GNU C++ compiler'
     Tell RHIDE to compile this file like a normal GNU C++ source file.

`GNU assembler'
     Tell RHIDE to compile this file like a normal GNU assembler file.

`GNU Pascal compiler'
     Tell RHIDE to compile this file like a normal GNU Pascal file.

If you have selected the User compiler type, you have to put in the next
inputline the specs how to call the compiler. This specs can use any
variables that are known to RHIDE (*Note Builtin variables::) together
with normal text. As an example I show here, how the builtin C compiler is
defined (the backslashes at the end of the lines are used only here to
show, that the line is continued, they are NOT part of the specs):


$(RHIDE_GCC) $(INCLUDE_DIRS) $(C_DEBUG_FLAGS) $(C_OPT_FLAGS) \
$(C_WARN_FLAGS) $(C_C_LANG_FLAGS) $(C_EXTRA_FLAGS) $(LOCAL_OPT) \
-c $(SOURCE_NAME) -o $(OUTFILE)


File: rhide.inf,  Node: Error checking,  Next: Error program,  Prev: Compiler type,  Up: Local options for a project item

Error checking
..............

Here you can select how  errors or warnings that  are produced by the
compiler, are checked. Possible values are:

`Auto'
     Let RHIDE select the correct way for checking the errors

`User'
     Use your own external program to check the output of the compiler to
     `stderr'

`None'
     Do not check any errors, assume that the compiler does it's job every
     time successfull

`builtin C'
     Check the errors like when compiling a C file

`builtin assembler'
     Check the errors like when copiling an assembler file

`builtin linker'
     Check the errors like when linking

`return value'
     Determine only if the compiling was successfull or not by checking
     the return value of the compiler (zero for success)


File: rhide.inf,  Node: Error program,  Prev: Error checking,  Up: Local options for a project item

Error program
.............

If you have selected above the User error checking, type here the program,
which should check for errors and/or warnings.  What the external error
checking program should do:

   - The program must take a filename as argument, which contain the
     output to stderr from the compiler (Error and warning messages)

   - The program has to write to stdout the Warnings, Errors or messages
     in a special format.

    `Errors'
          A line that starts with the string "!Error" (without the double
          quotes) optionally follwed by "!File" and a filename in single
          quotes and "!Line" and a line number.  The next line contain the
          error text.  Example:


          !Error!File'test.c'!line17
          This is a sample error message

          This means, that in file 'test.c' at line 17 has an error
          occoured with the description 'This is a sample error message'

    `Warnings'
          Warnings have the same format, except that !Error is replaced by
          !Warning.

    `Any other line'
          is treated as a simple message optionally preceeded by !File and
          !Line.


File: rhide.inf,  Node: Builtin compiler specs,  Next: Builtin variables,  Prev: Project window,  Up: Detailed description of some parts of RHIDE

4.5 Builtin compiler specs
==========================

RHIDE uses for compiling, linking, and the other stages of generating a
file also specs, like you can change in the local options for a project
item (*Note Local options::). Here the specs, which are used currently:

$(RHIDE_COMPILE_C)
     For compiling C source files

$(RHIDE_COMPILE_CC)
     For compiling C++ source files

$(RHIDE_COMPILE_ASM)
     For compiling assembler source files

$(RHIDE_COMPILE_PASCAL)
     For compiling pascal source files

$(RHIDE_COMPILE_OBJC)
     For compiling objective C source files

$(RHIDE_COMPILE_LINK)
     For linking

$(RHIDE_COMPILE_LINK_PASCAL)
     For linking when the project contain pascal source files

$(RHIDE_COMPILE_LINK_PASCAL_AUTOMAKE)
     This spec is used only, when you have set the (*Note Primary file::),
     to tell RHIDE, not to check for dependencies but to use the 'automake'
     feature of GPC.

$(RHIDE_COMPILE_ARCHIVE)
     For creating a library

$(RHIDE_FSDB)
     For calling fsdb.

$(RHIDE_GDB)
     For calling gdb.

$(RHIDE_GPROF)
     For calling gprof.

$(RHIDE_GREP)
     For calling grep.

All of these specs have a default contentents in RHIDE, but they can be
overwritten by setting the environment variable with the same name and any
other contents.


File: rhide.inf,  Node: Builtin variables,  Next: Change the defaults of RHIDE,  Prev: Builtin compiler specs,  Up: Detailed description of some parts of RHIDE

4.6 Builtin variables
=====================

This section describe, which variables can be used within RHIDE to get
values from some of the configurations, which you have made inside RHIDE.

All of these variables are refernced by a name enclosed in parantheses
preceeded by a dollar sign. Example: `$(RHIDE_GCC)'. You can overwrite any
of the following variables, if you define in your environment the same
variable with any contents you want.

When RHIDE tries to get the contents of such a variable, it searches at
first if it is found in it's internal database. If it was not found, the
environment is checked for such a variable and if that fails, the
resulting value is the variable itself.

In addition to the use of variables, RHIDE has a limited ability of using
string manipulating functions. I have implemented some of the functions,
which are available with GNU make. They have the same name and should work
exactly like the GNU make counterpart.

`$(strip arg)'
     This function removes any leading and trailing whitespace and converts
     all multispaces to single spaces from the (whitespace separated list)
     `arg'.

`$(addsuffix arg1,arg2)'
     These functions append on each argument from the whitespace separated
     list `arg2' the string `arg1'.

`$(addprefix arg1,arg2)'
     This is the same as `$(addsuffix arg1,arg2)', except that it puts the
     string `arg1' before each argument from `arg2'.

`$(notdir arg)'
     This removes any directory part from the argument `arg'.

`$(dir)'
     This extracts only the directory part from the argument `arg'. If
     there was not directory in `arg', an empty string is returned. (The
     directory contains also the drive letter, if there was one)

`$(subst arg1,arg2,arg3)'
     This replaces every occoureance of `arg1' in `arg3' with `arg2'

The following variables have a special meaning in RHIDE with the default
contents:
$(RHIDE_GCC)
     gcc

$(RHIDE_AS)
     gcc

$(RHIDE_GXX)
     gcc

$(RHIDE_GPC)
     gpc

$(RHIDE_AR)
     ar

$(RHIDE_LD)
     gcc

$(RHIDE_LD_PASCAL)
     gpc

$(RHIDE_ARFLAGS)
     rcs

$(RHIDE_INCLUDES)
     $(SPECIAL_CFLAGS) $(addprefix -I,$(INCLUDE_DIRS))

$(RHIDE_LIBDIRS)
     $(addprefix -L,$(LIB_DIRS))

$(RHIDE_LIBS)
     $(addprefix -l,$(LIBS))

$(RHIDE_LDFLAGS)
     $(SPECIAL_LDFLAGS) $(addprefix -Xlinker ,$(LD_EXTRA_FLAGS))

$(RHIDE_COMPILE_C)
     $(RHIDE_GCC) $(RHIDE_INCLUDES) $(C_DEBUG_FLAGS) \
     $(C_OPT_FLAGS) $(C_WARN_FLAGS) $(C_C_LANG_FLAGS) \
     $(C_EXTRA_FLAGS) $(LOCAL_OPT) -c $(SOURCE_NAME) \
     -o $(OUTFILE)

$(RHIDE_COMPILE_C_FORCE)
     $(RHIDE_GCC) $(RHIDE_INCLUDES) $(C_DEBUG_FLAGS) \
     $(C_OPT_FLAGS) $(C_WARN_FLAGS) $(C_C_LANG_FLAGS) \
     $(C_EXTRA_FLAGS) -x c $(LOCAL_OPT) -c $(SOURCE_NAME) \
     -o $(OUTFILE)

$(RHIDE_COMPILE_CC)
     $(RHIDE_GXX) $(RHIDE_INCLUDES) $(C_DEBUG_FLAGS) \
     $(C_OPT_FLAGS) $(C_WARN_FLAGS) $(C_C_LANG_FLAGS) \
     $(C_CXX_LANG_FLAGS) $(C_EXTRA_FLAGS) $(LOCAL_OPT) \
     -c $(SOURCE_NAME) -o $(OUTFILE)

$(RHIDE_COMPILE_CC_FORCE)
     $(RHIDE_GXX) $(RHIDE_INCLUDES) $(C_DEBUG_FLAGS) \
     $(C_OPT_FLAGS) $(C_WARN_FLAGS) $(C_C_LANG_FLAGS) \
     $(C_CXX_LANG_FLAGS) $(C_EXTRA_FLAGS) -c c++ $(LOCAL_OPT) \
     -c $(SOURCE_NAME) -o $(OUTFILE)

$(RHIDE_COMPILE_ASM)
     $(RHIDE_AS) $(RHIDE_INCLUDES) $(C_DEBUG_FLAGS) \
     $(C_OPT_FLAGS) $(C_WARN_FLAGS) $(C_EXTRA_FLAGS) \
     $(LOCAL_OPT) -c $(SOURCE_NAME) -o $(OUTFILE)

$(RHIDE_COMPILE_ASM_FORCE)
     $(RHIDE_AS) $(RHIDE_INCLUDES) $(C_DEBUG_FLAGS) \
     $(C_OPT_FLAGS) $(C_WARN_FLAGS) $(C_EXTRA_FLAGS) \
     -x assembler $(LOCAL_OPT) -c $(SOURCE_NAME) \
     -o $(OUTFILE)

$(RHIDE_GPC_FLAGS)
     $(RHIDE_INCLUDES) $(C_DEBUG_FLAGS) $(C_OPT_FLAGS) \
     $(C_WARN_FLAGS) $(C_P_LANG_FLAGS) $(C_EXTRA_FLAGS)

$(RHIDE_COMPILE_PASCAL)
     $(RHIDE_GPC) $(RHIDE_GPC_FLAGS) $(LOCAL_OPT) \
     -c $(SOURCE_NAME) -o $(OUTFILE)

$(RHIDE_COMPILE_PASCAL_FORCE)
     $(RHIDE_GPC) $(RHIDE_GPC_FLAGS) -x pascal \
     $(LOCAL_OPT) -c $(SOURCE_NAME) -o $(OUTFILE)

$(RHIDE_COMPILE_LINK)
     $(RHIDE_LD) $(RHIDE_LIBDIRS) $(C_EXTRA_FLAGS) \
     $(RHIDE_LDFLAGS) -o $(OUTFILE) $(OBJFILES) \
     $(LIBRARIES) $(RHIDE_LIBS)

$(RHIDE_COMPILE_LINK_PASCAL)
     $(RHIDE_LD_PASCAL) $(RHIDE_LIBDIRS) $(C_EXTRA_FLAGS) \
     $(RHIDE_LDFLAGS) -o $(OUTFILE) $(OBJFILES) \
     $(LIBRARIES) $(RHIDE_LIBS)

$(RHIDE_COMPILE_LINK_PASCAL_AUTOMAKE)
     $(RHIDE_LD_PASCAL) $(RHIDE_LIBDIRS) $(RHIDE_LDFLAGS) \
     -o $(OUTFILE) \
     --automake=\"$(strip $(RHIDE_GPC_FLAGS))\" \
     $(RHIDE_GPC_FLAGS) $(SOURCE_NAME) $(LIBRARIES) $(RHIDE_LIBS)

$(RHIDE_COMPILE_ARCHIVE)
     $(RHIDE_AR) $(RHIDE_ARFLAGS) $(OUTFILE) $(OBJFILES)

$(RHIDE_FSDB)
     fsdb $(OUTFILE) $(addprefix -p ,$(SRC_DIRS)) $(PROG_ARGS)

$(RHIDE_GDB)
     gdb $(OUTFILE) $(addprefix -d ,$(SRC_DIRS))

$(RHIDE_GREP)
     grep -n $(prompt arguments for GREP)

$(RHIDE_GPROF)
     gprof $(OUTFILE)

The following are not used as real variables, but they are used to get the
contents of options from RHIDE. But you can override them also by setting
them as an environment variable.

$(INCLUDE_DIRS)
     All the include directories

$(LIB_DIRS)
     All the library directories

$(SOURCE_NAME)
     The actual compiled source file

$(OUTFILE)
     The actual created file

$(C_DEBUG_FLAGS)
     All the debugging flags

$(C_OPT_FLAGS)
     All the optimization flags

$(C_WARN_FLAGS)
     All the warning flags

$(C_C_LANG_FLAGS)
     All the C language flags

$(C_CXX_LANG_FLAGS)
     ALL the C++ language flags

$(C_P_LANG_FLAGS)
     All the pascal language flags

$(LIBS)
     All the libraries, which are given in the libraries options

$(LD_EXTRA_FLAGS)
     All the additional linker options

$(LOCAL_OPT)
     All the local options for that project item

$(OBJFILES)
     All the destination files, which are part of the project and which
     are not a library and not excluded from linking

$(LIBRARIES)
     All the libraries, which are explicit included in the project and not
     exlcuded from linking

$(SPECIAL_CFLAGS)
     Some special flags for `gcc'. Currently only the `-nostdlib' switch.

$(SPECIAL_LDFLAGS)
     Some special flags for `gcc' when linking. Currently only the
     switches `-pg' and `-nostdlib'.

$(prompt TITLE)
     RHIDE prompts for arguments which get the title `TITLE' and insert
     the parameters here.


File: rhide.inf,  Node: Change the defaults of RHIDE,  Next: Message window,  Prev: Builtin variables,  Up: Detailed description of some parts of RHIDE

4.7 Change the defaults of RHIDE
================================

If you have special wishes for compiling your source files, you can
configure for RHIDE mostly everything. For adding support for other than
the builtin known file types (*Note Builtin variables::). If you want to
change the behaviour of RHIDE for compiling all the known file types you
should know at first really what you do. If you think, this is a good idea
or if you only want only check if it works you can do it.

Before RHIDE compiles any file (this includes also linking and building a
library) it searches the environment for a variable after the following
scheme: When compiling a file with suffix `.c' to a file with suffix `.o'
RHIDE checks for the variable $(RHIDE_COMPILE.c.o). If this variable is
defined the contents of this variable is taken as the compile spec.

If you want to change the specs for linking you must take as destiniation
suffix `.exe' or `.' and as source suffix the suffix of your object files.
Example:

$(RHIDE_COMPILE.o.)


File: rhide.inf,  Node: Message window,  Next: Syntax highlighting,  Prev: Change the defaults of RHIDE,  Up: Detailed description of some parts of RHIDE

4.8 Message window
==================

This window shows every time you compile a file the resulting messages,
which gcc produces. These messages were converted in a special format to
show them in the window. Some of the messages contain a file eventually
combined with a line number. If you press <ENTER>  on such a message, the
corresponding source line in the file will be highlighted and the window
with this file will be selected. If this file is not already on the
dektop, it will be opened.

If the file, to which the messages refer, is already in the foreground you
can see the selected source line for your messages directly on the screen.


File: rhide.inf,  Node: Syntax highlighting,  Next: Checking the dependencies,  Prev: Message window,  Up: Detailed description of some parts of RHIDE

4.9 Syntax highlighting
=======================

Syntax highlighting is now supported directly by the editor. It should
work in mostly every situation for all the supported types. Currently (in
RHIDE) only the C/C++ style syntax highlight and the Pascal style syntax
highlight are supported.

With which style a file is highlighted is choosen by RHIDE by checking the
suffix of the file and determining the file type from that suffix.  (*Note
Known suffixes::)


File: rhide.inf,  Node: Checking the dependencies,  Next: What is Turbo Vision,  Prev: Syntax highlighting,  Up: Detailed description of some parts of RHIDE

4.10 Checking the dependencies
==============================

This is one of the main parts of RHIDE. To speed up the work, I have added
a cache for checking the modification time of a file and for finding a
file (computing the full name of a file). But sometimes the data in the
cache isn't valid, especialy when running under Windows. If you see this,
you can clear the cache by leaving RHIDE and starting again.

If you didn't any special things but have problems with it, please run
RHIDE with the `-df' switch and try to find out, where the problem is and
post it to me so I can fix it.


File: rhide.inf,  Node: What is Turbo Vision,  Next: How the dialogs work,  Prev: Checking the dependencies,  Up: Detailed description of some parts of RHIDE

4.11 What is Turbo Vision
=========================

The Turbo Vision library is part of Turbo C++ version 3.1. I have ported
this library to use with DJGPP because I think it is the most powerful
text windowing library, which is available for MS-DOS. With the help of
this library you can write front end application which looks very well and
the interface is easy to use.

The Turbo Vision library is not only a window based text user interface,
it is also a very good event handling mechanism. It supports the use of
the mouse and keyboard with the ability of defining and using of hotkeys,
that means, you can assign to some keys or combinations of keys, which
function should be executed.

The main parts of an application, which is using this library, are the
desktop, the menu bar and the statusline. The menu bar is usualy shown as
the topmost line of the screen. There are shown the main parts of the pull
down menus, from where you can select the most functions, which are
implemented in an application.

To use the menu you can use the mouse as well the keyboard. With the mouse
you can click every where on a menu entry and the corresponding function
will be executed. There are some different actions, which a menu entry can
have. At first some of them, these are for example all the entries in the
menu bar, open a submenu with more menu entries which are related to the
name of this main entry. And the others, most in such a submenu, execute a
definite function of the application.

With the keyboard you can walk through the menu very simply. To activate
the menu bar, you have to press <F10> . In the pull down menus you can use
the cursor keys to move the highlighted bar up and down and with the
cursor right and left keys you can switch to next or previous menu. With
the <ENTER>  key you activate the function, which corresponds to this
entry. If this was a submenu, which is indicated with a symbol like a
small right arrow, this will be opened.

If you walk through the menu with the cursor keys or the mouse (hold the
left mouse button down and move the mouse) in the statusline will be shown
for each entry a short hint for the function of this menu entry.


File: rhide.inf,  Node: How the dialogs work,  Next: Defining macros,  Prev: What is Turbo Vision,  Up: Detailed description of some parts of RHIDE

4.12 How the dialogs work
=========================

In a dialog, like the file open dialog, are many things which you can
select or where you can type in some data. At first some general
functions. If you press <ESC> , the dialog will be closed and nothing will
be changed. The same can be done with the mouse by clicking on the close
symbol (this is the small symbol on upper left frame of the dialog).

In the next paragraphs I will describe the most used elements of a dialog.
For selecting each element of a dialog you can use the <Tab> key to select
the next element in the dialog or the <Shift+Tab> key, to select the
previous element.

A button is a rectangle with some text on it. If you activate such a
button a specified action is executed. To select a button you can use the
<Tab> key, until the button is special highlighted and press then <ENTER>
. Or most times a character of the text on this button has a different
color. So you can press <Alt+> this charcter to activate the button. With
the mouse you can simply click on a button to activate it.

A listbox is a collection of some strings in one or more columns and rows
as needed. The project window (*Note Project window::) is such a listbox
with the names of the project items. You can use the cursor keys to move
the focus bar in the list, or if it is a sorted listbox, you can also type
some characters and the focus will moved to the item, which starts with
this characters. To select a item in a list box, press <SPACE> or <ENTER>
or double click with mouse on it.

In an input line you can type some text which can be edited with the usual
editing keys.

A checkbox is a collection of options, which can be turned on or off.
Each option has in front of it a small indicator, if it is turned on (an X
is shown) or not (the X is not shown). To toggle such an option, use the
cursor keys to move the focus to the option you want and press <SPACE> .
If a character in an optionstring is highlighted you can press this key
and the option will be turned on or off or click with the mouse on the
option.

Radiobuttons are similar to checkboxes, but there you can select only one
of all the shown options.


File: rhide.inf,  Node: Defining macros,  Next: The INFO Viewer,  Prev: How the dialogs work,  Up: Detailed description of some parts of RHIDE

4.13 Defining macros
====================

Please look for a detailed documentation here: see *Note Documentation
about Pseudo Macros: (editor)Pseudo Macros,


File: rhide.inf,  Node: The INFO Viewer,  Prev: Defining macros,  Up: Detailed description of some parts of RHIDE

4.14 The INFO Viewer
====================

The integrated helpsystem of RHIDE is based on the INFO Viewer written by
SALVADOR EDUARDO TROPEA (SET) <ice@inti.edu.ar>. It gives you access to
all the INFO files which you have installed in the correct directories like
for `info.exe'.

To get help about the INFO Viewer hit <F1>

when the helpwindow is opened or follow this link see *Note Top:
(infview)Top.

In addition to getting help with this system you can also copy text from
the helpscreen to the clippboard. This is usefull if you want for instance
to copy an example from the libc reference in your program. This feature
is not so powerfull like in the editor, but it is good enough. To mark
some text use the <Shift> and cursor keys and copy the selected text with
<Ctrl+Ins> to the clipboard.

In RHIDE you have also the possiblility to get help about a specific
function. Currently this works only for functions, which are documneted in
the libc reference. For doing this, move the cursor to the function and
hit <Ctrl+F1>  or click with the right button of the mouse on that word.


File: rhide.inf,  Node: Debugging with RHIDE,  Next: Debugging with RHGDB,  Prev: Detailed description of some parts of RHIDE,  Up: Top

5. Debugging with RHIDE
***********************

For debugging your programs you need now no external debugger, because
RHIDE has one integrated. The integrated debugger is not code which I have
written, but it is GDB 4.16, which is linked in RHIDE.

Because RHIDE uses a special method to communicated with GDB it is
currently not possible to use all of the features, which GDB has. I have
implemented at this time the most important functions, which are needed to
debug your program. So it is not possible to give GDB the same commands as
when running GDB standalone. That means, if you need any very special
feature of GDB you have to run GDB.

The integrated debugger is a real source level debugger like GDB. If you
step trough your program you will see every time exactly where in the
sources you are. But to use the aibility to debug your program needs, that
you have compiled your source files with debugging information and this
symbols must not be stripped from the executable.

* Menu:

* Limitations of the integrated debugger::
* Dual display debugging::
* Using the integrated debugger::
* Problems with C++ programs::
* Using Breakpoints::


File: rhide.inf,  Node: Limitations of the integrated debugger,  Next: Dual display debugging,  Prev: Debugging with RHIDE,  Up: Debugging with RHIDE

5.1 Limitations of the integrated debugger
==========================================

Because the integrated debugger is GDB, you will have all the limitations
which GDB has in addition to well known DJGPP and/or MS-DOS limitations.
Here is a (not completely) list of known misfeatures:

   * Signals are not handled every time correct by distinguishing between
     the debuggee and RHIDE

   * Remote debugging is NOT supported

   * Debugging of graphic programs may work or not depending on the
     software you are using. Currently only the VESA modes and the
     standard VGA graphic modes are supported.

   * When using the integrated debugger under Windows 3.1x (in Windows 95
     there is no such limitation) the number of breakpoints is limited to
     3, because you can use there only hardware breakpoints. The i386
     supports only 4 hardware breakpoints and 1 is needed for internal use.
     This is a common problem for all DJGPP debuggers. (Try to use FSDB
     with more than 3 breakpoints under Windows 3.1x)

   * Sometimes the source line, which is shown by RHIDE in assuming that
     the execution is there, is not correct. But this is NOT a bug of
     RHIDE and NOT of GDB. This is a bug in GCC which produces wrong line
     number information in the object files. Here is a very simple test
     program, with which you can see this problem.

          /* This is an example, that gcc produces wrong line number
             information for code which is optimized out. (compile this
             with -O) */
          
          int a = 1;
          int b = 2;
          
          int main()
          {
            if (a == b) return 0;
            if ((a + 1) == b) return 1;
            return 0; /* The debugger should never come here,
                         but it comes */
          }


File: rhide.inf,  Node: Dual display debugging,  Next: Using the integrated debugger,  Prev: Limitations of the integrated debugger,  Up: Debugging with RHIDE

5.2 Dual display debugging
==========================

RHIDE supports now also to use an installed dual display. This is when you
have installed in addition to your VGA card a monochrome display card
together with a monitor. RHIDE checks this by asking the BIOS if it is
present and if this is true and the option is enabled (*Note
Preferences::) then RHIDE switches automatically to the secondary display
when debugging and your program will run on the primary display.

With this debugging technique you will get the best debugging results
especially when debugging graphics programs.

To use the dual display with RHGDB use the `-D' switch for RHGDB.


File: rhide.inf,  Node: Using the integrated debugger,  Next: Problems with C++ programs,  Prev: Dual display debugging,  Up: Debugging with RHIDE

5.3 Using the integrated debugger
=================================

If you are familiar with Borland's debugger, you will see, that most of
the function of that debaugger are implemented in the same or in a similar
way (this includes the key bindings).

* Menu:

* Stepping trough the source code::
* Evaluating the contents of variables::
* Watching the contents of variables::


File: rhide.inf,  Node: Stepping trough the source code,  Next: Evaluating the contents of variables,  Prev: Using the integrated debugger,  Up: Using the integrated debugger

5.3.1 Stepping trough the source code
-------------------------------------

For stepping trough your code, there are three ways. This is at first the
Step-function <F8>. With this you execute a complete source line. If there
is a function call at the current execution point, this function is called
without debugging it. This technique is the same like the `next'-command
from GDB.

The next way is the Trace-function.  It does the same like the
Step-function <f7>, except if there is a function call at the current
execution point, you will go into this function, if there is debugging
information for that function available.  This technique is the same like
the `step'-command from GDB.

And the third way is the Goto-Cursor-function. For this, move the cursor
to the line in yur source code and press <F4>. Now the execution of your
program is continued until it comes to that line. Sometimes you will get
an error message, that for the specified line is no code generated.  This
comes from the optimization of yor code by GCC. In this case try a line
below or above.


File: rhide.inf,  Node: Evaluating the contents of variables,  Next: Watching the contents of variables,  Prev: Stepping trough the source code,  Up: Using the integrated debugger

5.3.2 Evaluating the contents of variables
------------------------------------------

You can evaluate also the the contents of variables, when your program has
been started. For this you can press <Ctrl+F4> and you will see a dialog,
where you can type in the expression to evaluate, a line with the result
and a line, where you can give the expression a new value. If you have
pressed this in an editor window, RHIDE tries to find the a word under the
cursor and copies this as default in the expression-inputline. To get the
contents of this expression you have to press the *Evaluate*-button.

If the expression could not be evaluated so it is shown in the result line.
For the exact syntax of getting the contents of an expression see *Note
Expressions: (gdb)Expressions. You can also show the value of the
expression in several formats see *Note Output Formats: (gdb)Output
Formats.

In addition to the functionallity of the Borland debuggers, GDB (and of
course also RHIDE) can evaluate the result of function calls. If you have
for example in your debugged program a function
     int foo(int arg1)
     {
     /* do something and return a value */
     }
defined, you can type in the expression inputline
foo(16)
and you will get as result, what the function would return, if it is
called with the argument `16'. As arguments you can also use any known
variable or complex expressions.

A known limitation is, that the expressions are NOT checked for validity.
That means, you can produce any exception there, which will terminate your
program. As an example type in the expression inputline
3/0
And, of course, you cannot assign to a function call a new value.

As an special side effect you can use this also as a calculator. You can
evaluate any trivial or complex expression and this is also available, if
you didn't started the integrated debugger.


File: rhide.inf,  Node: Watching the contents of variables,  Prev: Evaluating the contents of variables,  Up: Using the integrated debugger

5.3.3 Watching the contents of variables
----------------------------------------

In addition to a single look at the contents of a variable, you can add
the variable to a list which is updated after each debugger step and is
shown in the watching window. For this function you can use the hotkey
<Ctrl+F7> .

Within the watch window you can press <Enter> on an expression to change
that expression (NOT the contents of that expression) or you can press
<Del>  to remove the variable from the watch window.


File: rhide.inf,  Node: Problems with C++ programs,  Next: Using Breakpoints,  Prev: Using the integrated debugger,  Up: Debugging with RHIDE

5.4 Problems with C++ programs
==============================

Because GDB cannot handle correct C++ debugging information when it is
generated as COFF debugging information (with stabs debugging information
there is no such limitation and you can skip reading more) you will have
many problems when debugging C++ programs to get the contents of a
variable when it is a member of a class. Because GDB does not detect, that
your program is a C++ program, it sees it as a normal C program and so GDB
does nothing know about classes and all what have to do with it.

For accessing the member of a baseclass you must do some tricks. Let me
explain it on an example:

     class A
     {
     public:
       int a;
     };
     
     class B : public A
     {
     public:
       void test();
     };
     
     void B::test()
     {
       fprintf(stdout,"%d\n",a);
     }

If you debug the program in the function `B::test()' and you want to get
the contents of the member `a', you have to access it with `this->A.a' !!!
That means: At first you must access all members with the implicit `this'
variable and at second you must give all baseclasses until that, where the
member was declared.


File: rhide.inf,  Node: Using Breakpoints,  Prev: Problems with C++ programs,  Up: Debugging with RHIDE

5.5 Using Breakpoints
=====================

Breakpoints are a very usefull thing when debugging a program. You can set
a breakpont at any location of your program and run it. It will be
automatically stopped, if the program execution reaches the breakpoint.

* Menu:

* Setting a breakpoint::
* Modifying and setting a breakpoint::
* Problems with breakpoints::


File: rhide.inf,  Node: Setting a breakpoint,  Next: Modifying and setting a breakpoint,  Prev: Using Breakpoints,  Up: Using Breakpoints

5.5.1 Setting a breakpoint
--------------------------

For setting a breakpoint there are two different ways. The first is by
setting a breakpoint at any line by pressing <Ctrk+F8> . You will see,
that there is a breakpoint set, that this line is shown in an other color.
If you hit <Ctrl+F8>  on a line, which has already a breakpoint, the
breakpoint at this line is removed.


File: rhide.inf,  Node: Modifying and setting a breakpoint,  Next: Problems with breakpoints,  Prev: Setting a breakpoint,  Up: Using Breakpoints

5.5.2 Modifying and setting a breakpoint
----------------------------------------

The second way is by setting a breakpoint with the breakpoint dialog which
is selectable only from the menu. There you will see any breakpoint for
your program. These breakpoints can be modified now in many things.  In
this dialog you can enable/disable a breakpoint. This is not the same as
deleting and resetting it. If you disable a brekpoint, it is stored
internal but it is not used. If you enable it again all the sttings for
that breakpoint, which you have already made, are remembered.

In the breakpoint dialog you can also set or delete a breakpoint with the
given buttons. If you want to set a new breakpoint, use the New-Button.
Then you will get a dialog which you also get when you press the
Modify-Button. In this dialog you can change many things of the breakpoint.

In this dialog is the only point for setting a breakpoint at a specified
function. For doing this you must set at first the type of the breakpoint
to Function. Then you can type in the function inputline the name of the
function or hit <Ctrl+F1>

to get a list of functions which are available from where you can select
one with <Enter>.

For setting a breakpoint at a specified line, set the breakpoint type to
Line and type in the filename and the linenumber.

The next what you can modify on a breakpoint is a condition. That means
that the breakpoint should stop your program only, if the condition is
true. Write the condition in the programming language of your source file
and you can use any accessable variable and you can call also functions of
the debugged program. For other information about the syntax see *Note
Conditions: (gdb)Conditions.

And at last you can give your breakpoints also a count. A breakpoint count
is a number, how often this breakpoint is ignored. That means, if you type
there for example 10, then the RHIDE stops the execution of the program
only, if it comes to that point the 10th time. WARNING: This count is set
by RHIDE only once. After the breakpoint is realy hit, from now on the
breakpoint stops your program every time, the breakpoint is reached.


File: rhide.inf,  Node: Problems with breakpoints,  Prev: Modifying and setting a breakpoint,  Up: Using Breakpoints

5.5.3 Problems with breakpoints
-------------------------------

Currently there is a big problem, when you have set a breakpoint at a line
(not at a function) of your program and you edit now the source code. If
you insert or delete some lines the breakpoints, which are set at lines
after or at the modified lines are NOT updated to the correct line number.


File: rhide.inf,  Node: Debugging with RHGDB,  Next: Some FAQs,  Prev: Debugging with RHIDE,  Up: Top

6. Debugging with RHGDB
***********************

In addition to RHIDE, which has an integrated debugger, there is also a
standalone debugger called RHGDB. (The name comes from my initials and GDB)

RHGDB has the same aibilities like RHIDE for debugging your program. But
it has no editor. The source files are shown in read only windows where
you can move the curser and other things (except editing) like in RHIDE.

The menu tree is anolog to RHIDE but (of course) it has not all the menu
entries of RHIDE, becuse RHGDB should be used only for debugging and
nothing else.

I have written it to debug DJGPP programs, for which there is no RHIDE
project file available but the program has debugging information and, if
you are small of memory, it is much smaller than RHIDE.

The syntax for using RHGDB is very simple. Run it with your program as the
first argument followed by any argument, which should be passed to your
program.

RHGDB saves and reads the options from files with the suffix `.rgd'.  This
done automatacly when you run RHGDB with your program as argument by
searching a file with the same basename of your program and the suffix
`.rgd' and in this file the options are also automaticaly stored, when you
exit RHGDB.

Alternatively you can also save/read the options from within RHIDE by
selecting the corresponding menu entries from the Options menu.

To use the the "Dual display debugging" feature of RHGDB you must give on
commandline the `-D' switch.

