/* Copyright (C) 1996,1997 Robert Hhne, see COPYING.RH for details */
/* This file is part of RHIDE. */
#define Uses_tvutilFunctions
#include <libtvuti.h>

#include <libide.h>
#include <rhide.h>
#include <string.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <fcntl.h>

#define STDOUT 1
#define STDERR 2

#define OLD_STDOUT
#define OLD_STDERR

#undef OLD_STDOUT
#undef OLD_STDERR

char *cpp_errname;
char *cpp_outname;
static char *errname = NULL;
static char *outname = NULL;
#ifndef OLD_STDOUT
static int h_out,h_outbak;
#else
static int oldstdout;
#endif
#ifndef OLD_STDERR
static int h_err,h_errbak;
#else
static int oldstderr;
#endif

/* returns a malloced unique tempname in $TMPDIR */
char *unique_name(char *before,char *retval)
{
/* In RHIDE $TMPDIR is set at startup */
  char *name,*tmp = getenv("TMPDIR");
  int fd;
  if (!tmp)
    tmp = "/tmp";
  if (retval)
  {
    strcpy(retval,tmp);
    strcat(retval,"/");
    strcat(retval,before);
    strcat(retval,"XXXXXX");
    name = retval;
  }
  else
  {
    string_dup(name,tmp);
    string_cat(name,"/");
    string_cat(name,before);
    string_cat(name,"XXXXXX");
  }
  /* Use mkstemp instead of mktemp to be sure, that no one else use
     that name (can happen, because it is created later than computed ) */
  fd = mkstemp(name);
  close(fd);
  return name;
}

char *open_stderr(void)
{
  if (errname) free(errname);
  errname = unique_name("er");
  if (debug_tempfiles)
  {
    fprintf(stderr,_("redirecting %s to %s\n"),"stderr",errname);
  }
#ifdef OLD_STDERR
  int nul;
  fflush(stderr);
  nul = creat(errname, S_IREAD | S_IWRITE);
  oldstderr = dup(STDERR);
  dup2(nul, STDERR);
  close(nul);
#else
#ifdef __DJGPP__
  h_err = open (errname,O_WRONLY | O_BINARY | O_CREAT | O_TRUNC,
                        S_IREAD | S_IWRITE);
#else
  h_err = open (errname,O_WRONLY | O_CREAT | O_TRUNC,
                        S_IREAD | S_IWRITE);
#endif
  h_errbak = dup (2);
  fflush(stderr);  /* so any buffered chars will be written out */
  dup2 (h_err, 2);
#endif
  return errname;
}

void close_stderr(void)
{
#ifdef OLD_STDERR
  dup2(oldstderr, STDERR);
  close(oldstderr);
#else
  dup2 (h_errbak, 2);
  close (h_err);
  close (h_errbak);
#endif
}

char *open_stdout(void)
{
  if (outname) free(outname);
  outname = unique_name("ou");
  if (debug_tempfiles)
  {
    fprintf(stderr,_("redirecting %s to %s\n"),"stdout",outname);
  }
#ifdef OLD_STDOUT
  int nul;
  fflush(stdout);
  nul = creat(outname, S_IREAD | S_IWRITE);
  oldstdout = dup(STDOUT);
  dup2(nul, STDOUT);
  close(nul);
#else
#ifdef __DJGPP__
  h_out = open (outname,O_WRONLY | O_BINARY | O_CREAT | O_TRUNC,
                        S_IREAD | S_IWRITE);
#else
  h_out = open (outname,O_WRONLY | O_CREAT | O_TRUNC,
                        S_IREAD | S_IWRITE);
#endif
  h_outbak = dup (1);
  fflush(stdout);  /* so any buffered chars will be written out */
  dup2 (h_out, 1);
#endif
  return outname;
}

void close_stdout(void)
{
#ifdef OLD_STDOUT
  dup2(oldstdout, STDOUT);
  close(oldstdout);
#else
  dup2 (h_outbak, 1);
  close (h_out);
  close (h_outbak);
#endif
}
