#if defined( Uses_TCEditor_External ) && !defined( __TCEditor_External__ )
#define __TCEditor_External__

// ************* General definitions
#define uint16                  unsigned short
#define uint32                  unsigned int
#define UnUsed                  __attribute__ ((unused))

// ************* Redraw commands
const
  ufUpdate = 0x01,
  ufLine   = 0x02,
  ufView   = 0x04,
  ufStatus = 0x08,
  ufFound  = 0x10,
  ufHLChar = 0x20;

// ************* States of the selection
const
  smExtend = 0x01,
  smDouble = 0x02,
  smEndSel = 0x04,
  smStartSel=0x08;

// ************* Old commands
const
  cmSave        = 80,
  cmSaveAs      = 81,
  cmFind        = 82,
  cmReplace     = 83,
  cmSearchAgain = 84,
  cmUpdateTitle = 523;

// ************* Editor dialogs
const
  edOutOfMemory     = 0,
  edReadError       = 1,
  edWriteError      = 2,
  edCreateError     = 3,
  edSaveModify      = 4,
  edSaveUntitled    = 5,
  edSaveAs          = 6,
  edFind            = 7,
  edSearchFailed    = 8,
  edReplace         = 9,
  edReplacePrompt   = 10,
  edLineLenght      = 11,
  edGotoLine        = 12,
  edSetLocalOptions = 13,
  edLineOverflow    = 14,
  edSetGlobalOptions= 15,
  edJumpToFunction  = 16;

// ************* Various flags
const
  efCaseSensitive   = 0x0001,
  efWholeWordsOnly  = 0x0002,
  efPromptOnReplace = 0x0004,
  efReplaceAll      = 0x0008,
  efDoReplace       = 0x0010,
  efInSelection     = 0x0020,
  efBackupFiles     = 0x0100;

// Maximun values allowed
const
  setMaxScreenX = 200,
  setMaxScreenY = 100;

enum shlState { shlNoSyntax=0,shlCSyntax=1,shlPascalSyntax=2,
                shlClipperSyntax=3,shlGenericSyntax=4 };

// ************* Search structure for keywords
struct strSETSE
{
 char *firstLetters;
 int *lenTable;
 int *firstWithLength;
 char **mainTable;
 int *equalCharsInNext;
 int maxLen;
};

// ************* Generic Syntax Highligth structure
class TPMCollection;
struct strSHL
{
 char OpenCom1[4];
 int  lOpenCom1;
 char CloseCom1[4];
 int  lCloseCom1;
 char OpenCom2[4];
 int  lOpenCom2;
 char CloseCom2[4];
 int  lCloseCom2;
 char EOLCom1[4];
 int  lEOLCom1;
 char EOLCom2[4];
 int  lEOLCom2;
 char HexStart[4];
 int  lHexStart;
 char Escape;
 char Preprocessor;
 char Flags1;
 char UseInternal;
 strSETSE   Search;
 stkHandler Extentions;
 stkHandler PMacros;
 TPMCollection *PM;
 ushort     SymbolT[256];
 TNoCaseSOSStringCollection *Keywords;
};
#define FG1_CaseSensitive  1
#define FG1_NoNumbers      2
#define FG1_EOLCInFirstCol 4

/********************************* UNDO types and constants *****************/
#define MAX_UNDO 32
#define UNDO_CHARS_SIZE 100

enum UndoState { undoNoUndo, undoInMov, undoPutChar, undoDelChar, undoInsert,
                 undoDelete, undoPreDelete, undoPreInsert, undoDestroyLine,
                 undoDelCharDel, undoCutInMov, undoIndBlockSp,undoIndBlockTab,
                 undoIndBlock, undoPre1IndBlock, undoPre2IndBlock, undoUnIndBlock,
                 undoToUpper, undoToLower, undoOvrPutChar, undoPreInsertSp,
                 undoRectPaste, undoRectDel, undoRectCopy, undoRectStart,
                 undoRectEnd, undoRectHide, undoDeleteBuf, undoPostCopyInfo,
                 undoPreCopyInfo };

enum UndoDestroy { destBack };

struct BufPlusLen
{
 unsigned len;
 char s[0];
};

struct UndoCell
{
 int X,Y;
 int Xf,Yf;
 char *s;
 union
   {
    char *s;
    int  l;
    unsigned OffSet;
    BufPlusLen *BufL;
   } s2;
 UndoState Type;
 int Length;
 uint32 selStart,selEnd;
 uint32 selStartf,selEndf;
 char Flags;
 char Count;
};

struct stUndoInsert
{
 char *s;
 BufPlusLen *Eated;
 int   l;
};

const undoSelHided=1,
      undoModified=2,
      undoSelHidedF=4,
      undoModifiedF=8,
      undoOverWriteF=16,
      undoOverWrite=32;
/************************* End of UNDO types and constants *****************/

// ***************** Various Structures
struct GlobalOptionsRect {
        uint16 t1;
        char tab[3];
       };

typedef unsigned (*TEditorDialog)( int, ... );
extern unsigned defEditorDialog( int dialog, ... );
extern int InitTCEditor(char *s,Boolean force);
extern int LoadSyntaxHighLightFile(char *name, strSHL *&hl, SOStack &so,
                                   TNoCaseSOSStringCollection *list,int &cant);
extern char *LoadKeyForTCEditorError(void);
extern int LoadKeysForTCEditor(char *file);
extern int PipeTCEditor(unsigned);
#endif
