#include <ceditint.h>
#define Uses_TCEditWindow
#define Uses_TCEditor_Commands
#define Uses_TCEditor_Internal
#define Uses_TApplication
#define Uses_TWindow
#define Uses_TPalette
#define Uses_TDeskTop
#define Uses_TRect
#define Uses_TFileDialog
#define Uses_TChDirDialog
#define Uses_TStringCollection
#define Uses_fpstream
#define Uses_MsgBox
#define Uses_TCollection
#define Uses_TCommandSet
#include <ceditor.h>
#include <inf.h>
#include <edhelp.h>
#define Uses_SETAppAll
#include <setapp.h>
#include <dskwin.h>
#include <dskedito.h>
#include <dskclose.h>
#include <dskhelp.h>
#include <dskclip.h>
#include <edcollec.h>
#include <sdginter.h>

#ifndef BIOS_KEYBOARD
#include "keyboard.h"
#endif

#include <string.h>
#include <stdlib.h>
#include <locale.h>
#include <stdarg.h>
#include <strstream.h>
#include <iomanip.h>
#include <stdio.h>
#include <sys/stat.h>
#include <signal.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <dirent.h>
#ifdef __DJGPP__
#include <dir.h>
#include <conio.h>
#endif
#include <fnmatch.h>

void RemoveFromEditorsHelper(TCEditWindow *p);
void AddToEditorsHelper(TCEditWindow *p, int SelectHL=0);
int IsAnEditor(void *p);
TCEditWindow *IsAllreadyOnDesktop(char *fileName);
void AskForClosedResume(EditorResume *&r,char *fileName);
extern void AskForProjectResume(EditorResume *&r,char *fileName);
void BringListOfWindows(void);
void fexpand(char *);
extern TEditorCollection *edHelper;

const char *cDeskTopFileName=DeskTopFileName;
const EditorsDelta=10;

TDskWinHelp *InfManager=NULL;
TSetEditorApp *editorApp;
#ifdef TEST_SPLINES
int spLines[]={10-1,15-1,20-1,splEndOfList};
#endif
#ifdef USE_TSTRCOL
TStrCol *ReservedWords;
TStrCol *UserWords;
TStrCol *PascalRWords;
TStrCol *ClipperRWords;
#else
TStringCollection *ReservedWords;
TStringCollection *UserWords;
TStringCollection *PascalRWords;
TStringCollection *ClipperRWords;
#endif
extern TCEditWindow *clipWindow;

extern void InsertProjectWindow(void);

//
// closeView() function
//
void closeView(TView *p, void *p1)
{
 if (p)
    message(p, evCommand, cmClose, p1);
}

#define _cpColor \
    "\x71\x70\x78\x74\x20\x28\x24\x17\x1F\x1A\x31\x31\x1E\x71\x00" \
    "\x37\x3F\x3A\x13\x13\x3E\x21\x00\x70\x7F\x7A\x13\x13\x70\x7F\x00" \
    "\x70\x7F\x7A\x13\x13\x70\x70\x7F\x7E\x20\x2B\x2F\x78\x2E\x70\x30" \
    "\x3F\x3E\x1F\x2F\x1A\x20\x72\x31\x31\x30\x2F\x3E\x31\x13\x00\x00" \
    "\x1E\x71" \
    "\x17\x12\x1E\x1F\x1B\x15\x16\x3F\x2B\x1D" "\x1A\x2C\x13\x00\x00\x1C" \
    "\x1E\x71" \
    "\x17\x12\x1E\x1F\x1B\x15\x16\x3F\x2B\x1D\x1A\x2C\x13\x00\x00\x1C" \
    "\x1E\x71" \
    "\x17\x12\x1E\x1F\x1B\x15\x16\x3F\x2B\x1D\x1A\x2C\x13\x00\x00\x1C" \
    /* cCrossCur, cStatusLi, cMPHighL, cRectSel */ \
    "\x70\x7C\x5F\x67\xF0\xF0\xF0\xF0\xF0\xF0" \
    cInfColor

#define _cpBlackWhite \
    "\x70\x70\x78\x7F\x07\x07\x0F\x07\x0F\x07\x70\x70\x07\x70\x00" \
    "\x07\x0F\x07\x70\x70\x07\x70\x00\x70\x7F\x7F\x70\x07\x70\x07\x00" \
    "\x70\x7F\x7F\x70\x07\x70\x70\x7F\x7F\x07\x0F\x0F\x78\x0F\x78\x07" \
    "\x0F\x0F\x0F\x70\x0F\x07\x70\x70\x70\x07\x70\x0F\x07\x07\x00\x00" \
    "\x1E\x71" \
    "\x17\x12\x1E\x1F\x1B\x15\x16\x3F\x2B\x1D\x1A\x2C\x13\x00\x00\x1C" \
    "\x1E\x71" \
    "\x17\x12\x1E\x1F\x1B\x15\x16\x3F\x2B\x1D\x1A\x2C\x13\x00\x00\x1C" \
    "\x1E\x71" \
    "\x17\x12\x1E\x1F\x1B\x15\x16\x3F\x2B\x1D\x1A\x2C\x13\x00\x00\x1C"\
    /* cCrossCur, cStatusLi, cMPHighL, cRectSel */ \
    "\x70\x7C\x5F\x67\xF0\xF0\xF0\xF0\xF0\xF0" \
    cInfBlackWhite

#define _cpMonochrome \
    "\x70\x07\x07\x0F\x70\x70\x70\x07\x0F\x07\x70\x70\x07\x70\x00" \
    "\x07\x0F\x07\x70\x70\x07\x70\x00\x70\x70\x70\x07\x07\x70\x07\x00" \
    "\x70\x70\x70\x07\x07\x70\x70\x70\x0F\x07\x07\x0F\x70\x0F\x70\x07" \
    "\x0F\x0F\x07\x70\x07\x07\x70\x07\x07\x07\x70\x0F\x07\x07\x00\x00" \
    "\x1E\x71" \
    "\x17\x12\x1E\x1F\x1B\x15\x16\x3F\x2B\x1D\x1A\x2C\x13\x00\x00\x1C" \
    "\x1E\x71" \
    "\x17\x12\x1E\x1F\x1B\x15\x16\x3F\x2B\x1D\x1A\x2C\x13\x00\x00\x1C" \
    "\x1E\x71" \
    "\x17\x12\x1E\x1F\x1B\x15\x16\x3F\x2B\x1D\x1A\x2C\x13\x00\x00\x1C"\
    /* cCrossCur, cStatusLi, cMPHighL, cRectSel */ \
    "\x70\x7C\x5F\x67\xF0\xF0\xF0\xF0\xF0\xF0" \
    cInfMonochrome


TPalette& TSetEditorApp::getPalette() const
{
 static TPalette color ( _cpColor, sizeof( _cpColor )-1 );
 static TPalette blackwhite( _cpBlackWhite, sizeof( _cpBlackWhite )-1 );
 static TPalette monochrome( _cpMonochrome, sizeof( _cpMonochrome )-1 );
 static TPalette *palettes[] =
     {
     &color,
     &blackwhite,
     &monochrome
     };
 return *(palettes[appPalette]);
}

static void FixUpName(char *fileName)
{
 if (!fileName) return;
 // Correct the name
 int l=strlen(fileName)-1;
 if (fileName[l]=='.')
    fileName[l]=0;
}

TCEditWindow *TSetEditorApp::openEditor(char *fileName, Boolean visible,
                                        EditorResume *res)
{
 TCEditWindow *ain=NULL;
 if (visible && fileName)
    ain=IsAllreadyOnDesktop(fileName);
 TRect r = deskTop->getExtent();
 TView *p;

 if (ain)
   {
    ain->select();
    p=(TView *)ain;
   }
 else
   {
    FixUpName(fileName);
    p=validView(new TCEditWindow(r,fileName,wnNoNumber));
    if (visible)
      {
       EditorResume *r=res;
       AskForClosedResume(r,fileName);
       AskForProjectResume(r,fileName);
       AddToEditorsHelper((TCEditWindow *)p,1);
       if (r)
          ((TCEditWindow *)p)->ApplyResume(*r);
      }
    else
       p->hide();
    deskTop->insert(p);
   }

 return (TCEditWindow *)p;
}

TSetEditorApp::TSetEditorApp() :
    TProgInit( TSetEditorApp::initStatusLine,
               TSetEditorApp::initMenuBar,
               TSetEditorApp::initDeskTop
             ),
    TApplication()
{
 TCommandSet ts;
 ts.enableCmd( cmSave );
 ts.enableCmd( cmSaveAs );
 ts.enableCmd( cmcCut );
 ts.enableCmd( cmcCopy );
 ts.enableCmd( cmcPaste );
 ts.enableCmd( cmcClear );
 ts.enableCmd( cmcUndo );
 ts.enableCmd( cmcRedo );
 ts.enableCmd( cmcFind );
 ts.enableCmd( cmcReplace );
 ts.enableCmd( cmcSearchAgain );
 ts.enableCmd( cmClosePrj );
 disableCommands( ts );

 TCEditor::editorDialog = doEditDialog;

 // The clipboard is created during the load of the DeskTop
 clipWindow=0;
}


void TSetEditorApp::createClipBoard(void)
{
 clipWindow = openEditor( 0, False );
 if ( clipWindow != 0 )
   {
    TCEditor::clipboard = clipWindow->editor;
    TCEditor::clipboard->canUndo = False;
   }
}


int FileOpenDialog(char *title, char *file)
{
 return
 execDialog( new TFileDialog( file, title, _("~N~ame"), fdOpenButton, 100 ),
             file) != cmCancel;
}

void TSetEditorApp::fileOpen()
{
 char fileName[PATH_MAX];
 strcpy( fileName, "*.*" );

 if (FileOpenDialog(_("File Open"),fileName))
     openEditor( fileName, True );
}

void TSetEditorApp::fileNew()
{
 openEditor( 0, True );
}

void TSetEditorApp::changeDir()
{
 execDialog( new TChDirDialog( cdNormal, 0 ), 0 );
}

void TSetEditorApp::dosShell()
{
#ifndef BIOS_KEYBOARD
    remove_keyboard();
#endif
    suspend();
    system("cls");
    cout << _("Type EXIT to return...");
    system( getenv( "COMSPEC"));
    resume();
#ifndef BIOS_KEYBOARD
    install_keyboard();
#endif
    redraw();
}

void TSetEditorApp::showClip()
{
 clipWindow->select();
 clipWindow->show();
}

void TSetEditorApp::tile()
{
 deskTop->tile( deskTop->getExtent() );
}

void TSetEditorApp::cascade()
{
 deskTop->cascade( deskTop->getExtent() );
}

void CopyHelp2Clip(char *b, long l)
{
 if (clipWindow)
    clipWindow->editor->insertBuffer( b,0,(unsigned)l,False,True);
}

static char *GetWordUnderCursor(unsigned size)
{
 TView *p;

 p=editorApp->deskTop->current;
 if (!p) return 0; // Avoid a search
 if (IsAnEditor(p))
    return ((TCEditWindow *)p)->editor->WordUnderCursor(size);
 return 0;
}

void TSetEditorApp::handleEvent( TEvent& event )
{
 TApplication::handleEvent( event );
 if( event.what != evCommand )
     return;
 else
     switch( event.message.command )
        {
         case cmOpen:
             fileOpen();
             break;
 
         case cmNew:
             fileNew();
             break;
 
         case cmChangeDrct:
             changeDir();
             break;
 
         case cmDosShell:
             dosShell();
             break;
 
         case cmShowClip:
             showClip();
             break;
 
         case cmTile:
             tile();
             break;
 
         case cmCascade:
             cascade();
             break;

         case cmCalculator:
              executeCalc(GetWordUnderCursor(250));
              break;

         case cmInfView:
              InfManager->Goto("editor","");
              InfManager->window->select();
              InfManager->window->show();
              break;

         case cmLastHelp:
              InfManager->window->select();
              InfManager->window->show();
              break;

         case cmAnotherInfView:
             {
              TDskWinHelp *p;

              p=new TDskWinHelp("editor","");
              deskTop->insert(p->window);
              edHelper->addNonEditor(p);
              p->window->select();
              p->window->show();
             }
              break;

         case cmListWin:
              BringListOfWindows();
              break;

         case cmUserScreen:
              ShowUserScreen(event);
              break;

         case cmOpenPrj:
              OpenProject();
              break;

         case cmClosePrj:
              CloseProject(1);
              break;

         case cmSDG:
              SDGInterfaceRun();
              break;

         case cmSDGDialog:
              SDGInterfaceDialog();
              break;

         default:
             return ;
         }
 clearEvent( event );
}

#ifdef __DJGPP__
/* ungetch() is available only on DJGPP */
static void PasarAC(int Sig)
{
 Sig=0;
 ungetch('C');
}

void CtrlCOff(void)
{
 signal(SIGINT,PasarAC);
}
#else
/* On unixes we can simply ignore SIGINT (normally also on DJGPP) */
void CtrlCOff(void)
{
 signal(SIGINT,SIG_IGN);
}
#endif

void TSetEditorApp::ShowUserScreen( TEvent &event )
{
 TProgram::deskTop->setState(sfVisible,False);
 TProgram::application->suspend();
 do
   {
    clearEvent(event);
    event.getKeyEvent();
   }
 while ((event.what & (evKeyDown)) == 0);
 clearEvent(event);
 TProgram::application->resume();
 TProgram::deskTop->setState(sfVisible,True);

 TProgram::deskTop->redraw();
 TProgram::application->redraw();
}

/*****************************************************************************

  The following routines are designed to save and retreive the desktop.
  Comes from TVDemo.cpp

*****************************************************************************/

//
// retrieveDesktop() function ( restores the previously stored Desktop )
//

void TSetEditorApp::retrieveDesktop(const char *name)
{
 if (name)
   {
    // In this way we avoid the destruction of the file
    int h=open(name, O_RDONLY | O_BINARY);
    fpstream *f=new fpstream(h);

    if ( !f )
       messageBox(_("Could not open desktop file"), mfOKButton | mfError);
    else
      {
       TSetEditorApp::loadDesktop(*f);
       if ( !f )
          messageBox(_("Error reading desktop file"), mfOKButton | mfError);
      }
    delete f;
   }

 // Create all the necesary things if there is no desktop file
 if (!edHelper)
    edHelper=new TEditorCollection(EditorsDelta*2,EditorsDelta);

 if (!clipWindow)
   {
    createClipBoard();
    if (clipWindow)
       edHelper->addNonEditor(new TDskWinClipboard(clipWindow));
   }

 if (!InfManager)
   {
    InfManager=new TDskWinHelp("editor","",True);
    if (InfManager && InfManager->window)
      {
       deskTop->insert(InfManager->window);
       edHelper->addNonEditor(InfManager);
      }
   }
}

//
// saveDesktop() function ( saves the DeskTop by calling storeDesktop function )
//

void TSetEditorApp::saveDesktop(char *fName)
{
 fpstream *f = new fpstream(fName, ios::out|ios::bin);

 if ( f )
   {
    TSetEditorApp::storeDesktop(*f);
    if ( !f )
      {
       messageBox(_("Could not create " DeskTopFileName "."), mfOKButton | mfError);
       ::remove(cDeskTopFileName);
       return;
      }
   }
 delete f;
}

//
// storeDesktop() function ( stores the Desktop in a resource file )
//

static char *Signature="TEditorApp desktop file\x1A";

void TSetEditorApp::storeDesktop(fpstream& s)
{
  // Save a signature to identify the file
  s.writeString(Signature);
  // Save the version
  s << TCEDITOR_VERSION;
  s << TCEditor::staticTabSize << uchar(TCEditor::staticAutoIndent) <<
       uchar(TCEditor::staticIntelIndent) << uchar(TCEditor::staticUseTabs) <<
       uchar(TCEditor::staticPersistentBlocks);
  int i,j=historyCount(10);
  s << j;
  for (i=0; i<j; i++)
     s.writeString(historyStr(10,i));
  s << edHelper;
  s << 0;
}

//
// loadDesktop() function
//

void TSetEditorApp::loadDesktop(fpstream &s)
{
 TView  *p;
 char buffer[80];

 s.readString(buffer,80);
 if (strcmp(buffer,Signature)!=0)
   {
    messageBox(_("Wrong desktop file."), mfOKButton | mfError);
    return;
   }
 s >> deskTopVersion;
 if (deskTopVersion<0x20A)
   {
    messageBox(_("The desktop file belongs to another deskTopVersion."), mfOKButton | mfError);
    return;
   }
 s >> TCEditor::staticTabSize;
 uchar aux;
 s >> aux;
 TCEditor::staticAutoIndent  = (aux) ? True : False;
 s >> aux;
 TCEditor::staticIntelIndent = (aux) ? True : False;
 s >> aux;
 TCEditor::staticUseTabs     = (aux) ? True : False;
 s >> aux;
 TCEditor::staticPersistentBlocks = (aux) ? True : False;
 int i,j;
 char *sp;
 s >> j;
 for (i=0; i<j; i++)
    {
     s.readString(buffer,80);
     sp = new char[strlen(buffer)+1];
     strcpy(sp,buffer);
     historyAdd(10,sp);
    }

 if (deskTop->valid(cmClose))
    deskTop->forEach(::closeView, 0);  // Clear the desktop

 if (deskTopVersion>=0x215)
    s >> edHelper;
 else
    edHelper=new TEditorCollection(EditorsDelta*2,EditorsDelta);

 if (deskTopVersion<0x215)
    if (deskTop->valid(cmClose))
      {
       do
        {
         s >> p;
         if (p!=NULL)
           {
            // If the view is outside the screen put in inside
            if ((p->origin.x>=deskTop->size.x) || (p->origin.y>=deskTop->size.y))
               p->origin.x=p->origin.y=0;
            AddToEditorsHelper((TCEditWindow *)p);
           }
         deskTop->insertBefore(validView(p), deskTop->last);
        }
       while (p != 0);
      }
}
/******************** End of save/retrieve desktop functions ****************/

__link( RBackground )
__link( RCEditWindow )
__link( RInfViewer )

//
//   Some of the following functions are just wrappers to hide
// the implementation of the editor's collection. In this way
// other files doesn't need to know about edHelper and your
// class.
//

void AddToEditorsHelper(TCEditWindow *p, int SelectHL)
{
 edHelper->addEditor(p,SelectHL);
}

void UpdateProjectResumeFor(char *fileName, TCEditWindow *p);

void RemoveFromEditorsHelper(TCEditWindow *p)
{
 UpdateProjectResumeFor(p->editor->fileName,p);
 edHelper->removeEditor(p);
}

void RemoveFromEditorsHelper(TInfWindow *p)
{
 edHelper->removeNonEditor(p,dktHelp);
}

int IsAnEditor(void *p)
{
 return edHelper->search(p,dktEditor)>=0;
}

TCEditWindow *IsAllreadyOnDesktop(char *fileName)
{
 ccIndex pos=edHelper->searchEditorName(fileName);
 if (pos<0)
    return NULL;
 TDskWinEditor *st=(TDskWinEditor *)edHelper->at(pos);
 return st->edw;
}

void AskForClosedResume(EditorResume *&r,char *fileName)
{
 if (!fileName)
    return;
 ccIndex pos=edHelper->search(fileName,dktClosed);
 if (pos<0)
    return;
 r=&(((TDskWinClosed *)edHelper->at(pos))->resume);
}

int SearchInHelper(int type, void *p)
{
 return edHelper->search(p,type)>=0;
}

void AddNonEditorToHelper(TDskWin *p)
{
 if (p)
    edHelper->addNonEditor(p);
}

int edTestForFile(const char *name)
{
 struct stat st;

 if (stat(name,&st)==0)
    return S_ISREG(st.st_mode);
 return 0;
}

static char PathOrig[PATH_MAX];
static char FileNameToLoad[PATH_MAX];
static char *PathOrigPos;
extern const char *GetVariable(const char *variable);

char *ExpandFileNameToThePointWhereTheProgramWasLoaded(const char *s)
{
 const char *v;

 if ((v=GetVariable("SET_FILES"))!=NULL)
   {
    strcpy(FileNameToLoad,v);
    strcat(FileNameToLoad,"/");
    strcat(FileNameToLoad,s);
    if (edTestForFile(FileNameToLoad))
       return FileNameToLoad;
   }

 if (PathOrigPos!=NULL)
   {
    *PathOrigPos=0;
    strcat(PathOrig,s);
   }
 else
    strcpy(PathOrig,s);

 return PathOrig;
}


int FindFile(const char * name,char * & fullName)
{
 char *base;

 if (strlen(name)>=PATH_MAX)
    return 0;
 fullName=new char[PATH_MAX];
 if (!fullName)
    return 0;
 strcpy(fullName,name);
 if (!edTestForFile(fullName))
   {
    base=getenv("DJDIR");
    if (!base)
      {
       delete fullName;
       return 0;
      }
    strcpy(fullName,base);
    strcat(fullName,"/include/");
    strcat(fullName,name);
    if (!edTestForFile(fullName))
      {
       delete fullName;
       return 0;
      }
   }
 fexpand(fullName);
 return 1;
}

void OpenFileFromEditor(char *fullName)
{
 editorApp->openEditor(fullName,True);
}

char *ReplaceExtention(char *name, char *ext, char *old)
{
 char *pos;
 pos=strrchr(name,'/');
 if (!pos)
    pos=name;
 pos=strstr(pos,old);
 if (pos)
    strcpy(pos,ext);
 else
    strcat(pos,ext);
 return name;
}


void LoadEditorDesktop(int LoadPrj)
{
 // 1) Look for project files.
 if (LoadPrj)
   {
    DIR *d;
    d=opendir(".");
    char prjName[PATH_MAX];
   
    if (d)
      {
       struct dirent *de;
       int c=0;
       while ((de=readdir(d))!=0)
         {
          if (fnmatch("*" ProjectFileExt,de->d_name,0))
             continue;
          if (c==0)
            {
             strcpy(prjName,de->d_name);
             c++;
            }
          else
            {
             c++;
             break;
            }
         }
       closedir(d);
       // If there are only one project
       if (c==1)
         {// Look again for the desktop
          OpenProject(prjName);
          return;
         }
      }
   }
 // 2) Try with the desktop file here
 if (edTestForFile(cDeskTopFileName))
   {
    editorApp->retrieveDesktop(cDeskTopFileName);
    return;
   }
 // 3) Try with the default desktop file
 char *s=ExpandFileNameToThePointWhereTheProgramWasLoaded(cDeskTopFileName);
 if (edTestForFile(s))
   {
    editorApp->retrieveDesktop((const char *)s);
    return;
   }
 editorApp->retrieveDesktop(NULL);
}

extern void RestoreScreen();

// Taked from the GCC 2.7.2.1 sources
typedef void (*vfp)(void);
extern "C" vfp set_new_handler(vfp handler);

static void *safetypool;

static void mynewhandler(void)
{
 if (safetypool==NULL)
    _exit(1); // We can't call exit because it can need malloc
 delete [] safetypool;
 safetypool=NULL;
 set_new_handler(NULL);
 messageBox(_("Memory is nearly full. Please exit, and restart."), mfOKButton | mfError);
}

int main(int argc, char *argv[])
{
#ifdef __DJGPP__
 // MUST BE ON or some frt files will fail
 __system_flags|=__system_allow_multiple_cmds;
#endif

 safetypool=new char [64000];
 set_new_handler (mynewhandler);

 PathOrigPos=strrchr(argv[0],'/');
 if (PathOrigPos)
   {
    PathOrigPos++;
    *PathOrigPos=0;
    strcpy(PathOrig,argv[0]);
    PathOrigPos=PathOrig+(int)(PathOrigPos-argv[0]);
   }
 else
    PathOrig[0]=0;

 #ifdef USE_TSTRCOL
 ReservedWords = new TStrCol(20,5);
 UserWords     = new TStrCol(20,5);
 PascalRWords  = new TStrCol(20,5);
 ClipperRWords = new TStrCol(20,5);
 #else
 ReservedWords = new TStringCollection(20,5);
 UserWords     = new TStringCollection(20,5);
 PascalRWords  = new TStringCollection(20,5);
 ClipperRWords = new TStringCollection(20,5);
 #endif

 ReservedWords->insert("int");
 ReservedWords->insert("char");
 ReservedWords->insert("unsigned");
 ReservedWords->insert("signed");
 ReservedWords->insert("float");
 ReservedWords->insert("double");
 ReservedWords->insert("short");
 ReservedWords->insert("long");
 ReservedWords->insert("void");

 ReservedWords->insert("for");
 ReservedWords->insert("while");
 ReservedWords->insert("do");
 ReservedWords->insert("if");
 ReservedWords->insert("else");
 ReservedWords->insert("return");
 ReservedWords->insert("continue");
 ReservedWords->insert("goto");

 ReservedWords->insert("static");
 ReservedWords->insert("const");
 ReservedWords->insert("enum");
 ReservedWords->insert("struct");
 ReservedWords->insert("extern");
 ReservedWords->insert("sizeof");
 ReservedWords->insert("union");
 ReservedWords->insert("typedef");
 ReservedWords->insert("inline");
 ReservedWords->insert("register");
 ReservedWords->insert("volatile");

 ReservedWords->insert("switch");
 ReservedWords->insert("case");
 ReservedWords->insert("default");
 ReservedWords->insert("break");

 ReservedWords->insert("new");
 ReservedWords->insert("delete");

 ReservedWords->insert("class");
 ReservedWords->insert("private");
 ReservedWords->insert("protected");
 ReservedWords->insert("public");
 ReservedWords->insert("this");
 ReservedWords->insert("template");
 ReservedWords->insert("throw");
 ReservedWords->insert("catch");
 ReservedWords->insert("virtual");
 ReservedWords->insert("friend");
 ReservedWords->insert("operator");
 ReservedWords->insert("try");

 UserWords->insert("uchar");
 UserWords->insert("ushort");
 UserWords->insert("uint16");
 UserWords->insert("uint32");

 // List of reserved words for Turbo Pascal 5.0, if some of them isn't
 // reserved in GPC please comment this line.
 PascalRWords->insert("absolute");
 PascalRWords->insert("and");
 PascalRWords->insert("array");
 PascalRWords->insert("begin");
 PascalRWords->insert("case");
 PascalRWords->insert("const");
 PascalRWords->insert("div");
 PascalRWords->insert("do");
 PascalRWords->insert("downto");
 PascalRWords->insert("else");
 PascalRWords->insert("end");
 PascalRWords->insert("external");
 PascalRWords->insert("file");
 PascalRWords->insert("for");
 PascalRWords->insert("forward");
 PascalRWords->insert("function");
 PascalRWords->insert("goto");
 PascalRWords->insert("if");
 PascalRWords->insert("implementation");
 PascalRWords->insert("in");
 PascalRWords->insert("inline");
 PascalRWords->insert("interface");
 PascalRWords->insert("interrupt");
 PascalRWords->insert("label");
 PascalRWords->insert("mod");
 PascalRWords->insert("nil");
 PascalRWords->insert("not");
 PascalRWords->insert("of");
 PascalRWords->insert("or");
 PascalRWords->insert("packed");
 PascalRWords->insert("procedure");
 PascalRWords->insert("program");
 PascalRWords->insert("record");
 PascalRWords->insert("repeat");
 PascalRWords->insert("set");
 PascalRWords->insert("shl");
 PascalRWords->insert("shr");
 PascalRWords->insert("string");
 PascalRWords->insert("then");
 PascalRWords->insert("to");
 PascalRWords->insert("type");
 PascalRWords->insert("unit");
 PascalRWords->insert("until");
 PascalRWords->insert("uses");
 PascalRWords->insert("var");
 PascalRWords->insert("while");
 PascalRWords->insert("with");
 PascalRWords->insert("xor");

 // Taked from the Clipper.EXE 5.2e
 ClipperRWords->insert("announce");
 ClipperRWords->insert("begin");
 ClipperRWords->insert("break");
 ClipperRWords->insert("call");
 ClipperRWords->insert("case");
 ClipperRWords->insert("declare");
 ClipperRWords->insert("do");
 ClipperRWords->insert("else");
 ClipperRWords->insert("elseif");
 ClipperRWords->insert("endcase");
 ClipperRWords->insert("enddo");
 ClipperRWords->insert("endif");
 ClipperRWords->insert("exit");
 ClipperRWords->insert("external");
 ClipperRWords->insert("field");
 ClipperRWords->insert("for");
 ClipperRWords->insert("function");
 ClipperRWords->insert("if");
 ClipperRWords->insert("iif");
 ClipperRWords->insert("in");
 ClipperRWords->insert("init");
 ClipperRWords->insert("local");
 ClipperRWords->insert("loop");
 ClipperRWords->insert("memvar");
 ClipperRWords->insert("next");
 ClipperRWords->insert("otherwise");
 ClipperRWords->insert("parameters");
 ClipperRWords->insert("private");
 ClipperRWords->insert("procedure");
 ClipperRWords->insert("public");
 ClipperRWords->insert("recover");
 ClipperRWords->insert("return");
 ClipperRWords->insert("sequence");
 ClipperRWords->insert("static");
 ClipperRWords->insert("step");
 ClipperRWords->insert("text");
 ClipperRWords->insert("to");
 ClipperRWords->insert("then");
 ClipperRWords->insert("using");
 ClipperRWords->insert("with");
 ClipperRWords->insert("while");


 if (LoadKeysForTCEditor(ExpandFileNameToThePointWhereTheProgramWasLoaded("keybind.txt")))
   {
    char dummy;
    cout << LoadKeyForTCEditorError() << endl;
    cin >> dummy;
   }
 TCEditor::SHLSOStack=new SOStack;
 TCEditor::SHLGenList=new TNoCaseSOSStringCollection(5,5,TCEditor::SHLSOStack);
 LoadSyntaxHighLightFile(ExpandFileNameToThePointWhereTheProgramWasLoaded(SHLFile)
			 ,TCEditor::SHLArray,*TCEditor::SHLSOStack,TCEditor::SHLGenList,
                         TCEditor::SHLCant);

 #ifndef BIOS_KEYBOARD
 install_keyboard();
 atexit(allegro_exit);
 #endif

 CtrlCOff();

 // International support
 char *locale_dir,localedir[PATH_MAX];
 setlocale(LC_ALL, "");
 // Use the LOCALEDIR var for the directory
 locale_dir = getenv("LOCALEDIR");

 if (!locale_dir)
   {
    // if LOCALEDIR doesn't exists use DJDIR
    locale_dir = getenv("DJDIR");
    if (locale_dir)
       strcpy(localedir,locale_dir);
    else
      {
       // if DJDIR doesn't exists use .
       // That's only to avoid a GPF in the strcpy and add a little facility
       localedir[0]='.';
       localedir[1]=0;
      }
    strcat(localedir,"/data/locale");
   }
  else
   {
    strcpy(localedir,locale_dir);
   }

 BINDTEXTDOMAIN("editor",localedir);
 TEXTDOMAIN("editor");

 editorApp = new TSetEditorApp();
 LoadEditorDesktop(1);

 // Open all the files indicated in the command line
 int count=argc;
 char tmpPath[PATH_MAX];
 while (count>1)
   {
    strcpy(tmpPath,argv[--count]);
    fexpand(tmpPath);
    editorApp->openEditor( tmpPath , True );
   }

 editorApp->run();
 // That saves the desktop too, even if there isn't a project
 SaveProject();
 destroy(edHelper);

 return 0;
}
