#include <ceditint.h>
#define Uses_TCEditWindow
#define Uses_TStreamable
#define Uses_TStreamableClass
#define Uses_TScrollBar
#define Uses_TRect
#define Uses_TDialog
#define Uses_TWindow
#define Uses_TStringCollection
#define Uses_TSortedListBox
#define Uses_TApplication
#define Uses_TDeskTop
#define Uses_MsgBox
#define Uses_TKeys
#define Uses_TFileDialog
#define Uses_fpstream
#include <ceditor.h>
#include <editcoma.h>

#define Uses_SETAppAll
#include <setapp.h>
#include <dskwin.h>
#include <dskprj.h>
#include <edcollec.h>
#include <sdginter.h>
#include <string.h>
#include <fcntl.h>
#include <stdio.h>

extern void LoadEditorDesktop(int LoadPrj);
static TDskWinPrj *prjWin=NULL;
#define PrjExists() (prjWin!=NULL)
extern void closeView(TView *p, void *p1);
extern char *ReplaceExtention(char *name, char *ext, char *old);
// From editmain.cc
extern TCEditWindow *IsAllreadyOnDesktop(char *fileName);

static int LoadingPrjVersion;

class TEditorProjectListBox : public TSortedListBox
{
public:
  TEditorProjectListBox(const TRect& bounds, ushort aNumCols,
                        TScrollBar *aScrollBar);
  virtual void handleEvent(TEvent &);
  virtual void selectItem(ccIndex item);
  virtual void getText(char *dest, ccIndex item, short maxLen);
  int  addFile(void);
  void delFile(void);
};

class TEditorProjectWindow : public TDialog
{
public:
  TEditorProjectListBox *list;
  TEditorProjectWindow(const TRect &,const char *);
  ~TEditorProjectWindow();
  virtual void close();
  static const int Version;
};

const int TEditorProjectWindow::Version=3;

extern TEditorCollection *edHelper;

typedef struct
{
 char *name;
 char *shortName;
 EditorResume resume;
} PrjItem;

class TPrjItemColl : public TStringCollection
{
public:
 TPrjItemColl(ccIndex aLimit, ccIndex aDelta) :
      TStringCollection(aLimit,aDelta) {};
 void atInsert(ccIndex pos, void *s);
 void freeItem(void *);
 void *keyOf(void *item) { return (void *)((PrjItem *)item)->shortName; };

private:
 PrjItem *createNewElement(char *name);

 const char *streamableName() const
     { return name; }
 void *readItem( ipstream& is );
 void writeItem( void *p, opstream &os );

protected:
 TPrjItemColl( StreamableInit ) : TStringCollection( streamableInit ) {};

public:
 static const char *name;
 static TStreamable *build() {return new TPrjItemColl( streamableInit );};
};

const char *TPrjItemColl::name="TPrjItemColl";

SetDefStreamOperators(TPrjItemColl)

static TPrjItemColl *ProjectList=NULL;


void *TPrjItemColl::readItem( ipstream& is )
{
 char Buffer[PATH_MAX+1];

 is.readString((char *)Buffer,PATH_MAX);
 PrjItem *st=createNewElement(Buffer);
 if (LoadingPrjVersion>2)
    ReadResume(st->resume,is);
 return st;
}

void TPrjItemColl::writeItem( void *p, opstream &os )
{
 PrjItem *pi=(PrjItem *)p;
 os.writeString(pi->name);
 SaveResume(pi->resume,os);
}

TStreamableClass RPrjItemColl( TPrjItemColl::name,
                               TPrjItemColl::build,
                               __DELTA(TPrjItemColl)
                              );

void TPrjItemColl::freeItem(void *p)
{
 PrjItem *s=(PrjItem *)p;
 if (s)
   {
    delete s->name;
    delete s;
   }
}

PrjItem *TPrjItemColl::createNewElement(char *name)
{
 PrjItem *st=new PrjItem;
 if (st)
   {
    if (!(st->name=strdup((char *)name)))
       return NULL;
    char *slash=strrchr(st->name,'/');
    if (slash)
       st->shortName=slash+1;
    else
       st->shortName=st->name;
    // Indicate is empty
    st->resume.prj_flags=0;
   }
 return st;
}

void TPrjItemColl::atInsert(ccIndex pos, void *s)
{
 PrjItem *st=createNewElement((char *)s);
 if (st)
    TStringCollection::atInsert(pos,st);
}


TEditorProjectListBox::TEditorProjectListBox(const TRect& bounds, ushort aNumCols,
                                             TScrollBar *aScrollBar) :
    TSortedListBox(bounds,aNumCols,aScrollBar)
{
}

void TEditorProjectListBox::getText(char *dest,ccIndex item,short maxlen)
{
  strncpy(dest,((PrjItem *)(list()->at(item)))->shortName,maxlen);
  dest[maxlen] = EOS;
}


extern void OpenFileFromEditor(char *fullName);

void TEditorProjectListBox::selectItem(ccIndex item)
{
 PrjItem *st=(PrjItem *)(list()->at(item));

 OpenFileFromEditor(st->name);
}


int TEditorProjectListBox::addFile(void)
{
 char name[PATH_MAX];
 ccIndex pos;
 PrjItem st;
 st.name=name;
 strcpy(name,"*.*");

 if (FileOpenDialog(_("Add File"),st.name))
   {
    if (ProjectList->search(&st,pos))
      {
       messageBox(_("File allready in project"), mfOKButton | mfError);
       return 0;
      }
    ProjectList->atInsert(pos,name);
    setRange(ProjectList->getCount());
    focusItem(pos);
    drawView();
    return 1;
   }
 return 0;
}

void TEditorProjectListBox::delFile(void)
{
 int c=ProjectList->getCount();

 if (c>0)
   {
    ProjectList->atRemove(focused);
    setRange(c-1);
    drawView();
   }
}

void TEditorProjectListBox::handleEvent(TEvent &event)
{
  TSortedListBox::handleEvent(event);
  switch (event.what)
    {
     case evKeyDown:
          switch (event.keyDown.keyCode)
            {
             case kbEnter:
                  if (!list() || list()->getCount() == 0)
                     break;
                  selectItem(focused);
                  clearEvent(event);
                  break;
            }
          break;
     case evCommand:
          switch (event.message.command)
            {
             case cmDelete:
                  delFile();
                  break;
             case cmInsert:
                  addFile();
                  break;
            }
          break;
    }
}

//class TEditorProjectListBox;

TEditorProjectWindow::TEditorProjectWindow(const TRect & rect,
                                           const char *tit) :
        TDialog(rect,tit),
	TWindowInit(TEditorProjectWindow::initFrame)
{
 if (!ProjectList)
    ProjectList=new TPrjItemColl(5,5);
 TRect r = getExtent();
 TScrollBar *scrollbar;
 r.grow(-1,-1);
 scrollbar = standardScrollBar(sbVertical | sbHandleKeyboard);
 list = new TEditorProjectListBox(r,3,scrollbar);
 growMode = gfGrowLoY | gfGrowHiX | gfGrowHiY;
 list->growMode = gfGrowHiX | gfGrowHiY;
 list->newList(ProjectList);
 insert(list);
 flags |= wfGrow | wfZoom;
 options |= ofFirstClick;
 helpCtx = hcEditorProjectWindow;
}

TEditorProjectWindow::~TEditorProjectWindow()
{
 delete ProjectList;
 ProjectList=NULL;
}

void TEditorProjectWindow::close()
{
 hide();
}

TStreamable *TDskWinPrj::build()
{
 return new TDskWinPrj( streamableInit );
}

static char *Signature="Editor project file\x1A";

void TDskWinPrj::write( opstream& os )
{
 os << window->origin << window->size
    << ProjectList  << (int)(TProgram::deskTop->indexOf(window));
}

void *TDskWinPrj::read( ipstream& is )
{
 TRect pos;

 is >> pos.a >> pos.b >> ProjectList >> ZOrder;
 pos.b+=pos.a;
 window=new TEditorProjectWindow(pos,_("Project Window"));
 view=window;

 return this;
}

char *TDskWinPrj::GetText(char *dest, short maxLen)
{
 return strcpy(dest,_("   Project Window"));
}

TDskWinPrj::TDskWinPrj(char *fName)
{
 TRect r=TProgram::deskTop->getExtent();
 FileName=strdup(fName);
 r.a.y=r.b.y-7;
 view=window=new TEditorProjectWindow(r,_("Project Window"));
 type=dktPrj;
 CanBeSaved=0;
 ZOrder=-1;
}

TDskWinPrj::~TDskWinPrj()
{
 delete FileName;
 destroy(window);
}

int TDskWinPrj::GoAction(ccIndex )
{
 TProgram::deskTop->lock();
 setFocusTo=window;
 focusChanged=True;

 return 0;
}


int TDskWinPrj::DeleteAction(ccIndex )
{
 //CloseProject(1); That's imposible because destroy the current object.
 return 0;
}

void LoadProject(char *name)
{
 int h=open(name, O_RDONLY | O_BINARY);
 fpstream *f=new fpstream(h);

 if (!f)
    messageBox(_("Could not open project file"), mfOKButton | mfError);
 else
   {
    char buffer[80];
   
    f->readString(buffer,80);
    if (strcmp(buffer,Signature)!=0)
       messageBox(_("Wrong project file."), mfOKButton | mfError);
    else
      {
       *f >> LoadingPrjVersion >> prjWin;
       if (LoadingPrjVersion>1)
          SDGInterfaceReadData(f);
       if (prjWin)
          prjWin->FileName=strdup(name);
      }
    if (!f)
       messageBox(_("Error reading project file"), mfOKButton | mfError);
   }
 delete f;
}

static void UpdateResume(void *p, void *)
{
 PrjItem *item=(PrjItem *)p;
 TCEditWindow *win=IsAllreadyOnDesktop(item->name);
 if (win)
   {
    win->FillResume(item->resume);
    // Indicate is used
    item->resume.prj_flags|=1;
   }
}

static void SaveOnlyProject(void)
{
 fpstream *f = new fpstream(prjWin->FileName, ios::out|ios::bin);

 if (f)
   {
    // Update the information about the windows
    ProjectList->forEach(UpdateResume,0);
    // Save a signature to identify the file
    f->writeString(Signature);
    // Save the version & project
    *f << TEditorProjectWindow::Version << prjWin;
    SDGInterfaceSaveData(f);
    if (!f)
      {
       messageBox(_("Could not save the project."), mfOKButton | mfError);
       ::remove(prjWin->FileName);
       return;
      }
   }
 delete f;
}

void SaveProject(void)
{
 if (PrjExists())
   {
    SaveOnlyProject();
    char *s=strdup(prjWin->FileName);
    if (s)
      {
       ReplaceExtention(s,DeskTopFileExt,ProjectFileExt);
       editorApp->saveDesktop(s);
       delete s;
      }
   }
 else
    editorApp->saveDesktop((char *)cDeskTopFileName);
}

static int HaveExtention(char *name)
{
 char *slash=strrchr(name,'/');
 char *point=strrchr(name,'.');
 if (slash)
    return point && point>slash;
 return point!=NULL;
}

void InsertInOrder(TDeskTop *dsk,TDskWin *win)
{
 int z=win->ZOrder;
 TView *v=0;

 if (z>=0)
   {
    if (z==0)
       dsk->insertBefore(win->view,0);
    else
      {
       v=dsk->at(z);
       dsk->insertBefore(win->view,v);
      }
   }
 else
   dsk->insert(win->view);
}

void OpenProject(char *name)
{
 char *s,fname[PATH_MAX];

 if (!name)
   {
    strcpy(fname,"*" ProjectFileExt);
    if (FileOpenDialog(_("Open Project"),fname))
      {
       if (!HaveExtention(fname))
          strcat(fname,ProjectFileExt);
       s=fname;
      }
    else
       return;
   }
 else
   s=name;

 if (edTestForFile(s))
   { // Load it
    CloseProject(0);
    editorApp->retrieveDesktop(ReplaceExtention(s,DeskTopFileExt,ProjectFileExt));
    LoadProject(ReplaceExtention(s,ProjectFileExt,DeskTopFileExt));
   }
 else
   { // Is a new one
    CloseProject(1);
    prjWin=new TDskWinPrj(s);
   }
 if (prjWin && prjWin->window)
   {
    InsertInOrder(editorApp->deskTop,prjWin);
    edHelper->addNonEditor(prjWin);
    editorApp->enableCommand(cmClosePrj);
    editorApp->enableCommand(cmSDG);
   }
 else
    prjWin=NULL;
}

// It close a project and the dektop
void CloseProject(int openDesktop)
{
 editorApp->disableCommand(cmClosePrj);
 editorApp->disableCommand(cmSDG);
 if (PrjExists())
   {
    // Save the actual state
    SaveProject();
   }
 // Close all the DeskTop windows
 destroy(edHelper);
 edHelper=0;
 prjWin=0;
 // Load a desktop, but not a project
 if (openDesktop)
    LoadEditorDesktop(0);
}


// That's the interface with the SDG module.
// These routines must provide the buffers with sources from the project

static ccIndex CountFiles;
static ccIndex CantFiles;

char *DskPrjGetNextFile(int &l, int &MustBeDeleted, char *FileName)
{
 FILE *f;
 char *buffer,*pos,*name;
 TCEditWindow *ed;
 char aux[PATH_MAX+30];

 if (CountFiles<CantFiles)
   {
    name=((PrjItem *)(ProjectList->at(CountFiles)))->name;
    CountFiles++;
    ed=IsAllreadyOnDesktop(name);
    if (ed)
      {
       buffer=ed->editor->buffer;
       MustBeDeleted=0;
      }
    else
      {
       // Read the file
       f=fopen(name,"rt");
       if (!f)
         {
          sprintf(aux,"Failed to open the file %s\n",name);
          messageBox(aux, mfOKButton | mfError);
          return NULL;
         }
      
       l=filelength(fileno(f))+1;
       buffer=new char[l];
       if (!buffer)
         {
          fclose(f);
          return NULL;
         }
       fread(buffer,l,1,f);
       buffer[l-1]=0;
       fclose(f);
       MustBeDeleted=1;
      }

    // Let just the filename
    pos=strrchr(name,'/');
    if (pos)
       pos++;
    else
       pos=name;
    strcpy(FileName,pos);
    return buffer;
   }
 return NULL;
}

// Initialize the counter to 0
// 1 if error
int DskPrjSDGInit(void)
{
 if (PrjExists())
   {
    CountFiles=0;
    CantFiles=ProjectList->getCount();
    if (CantFiles)
       return 0;
   }
 return 1;
}

void AskForProjectResume(EditorResume *&r,char *fileName)
{
 ccIndex pos;

 if (!fileName || !PrjExists())
    return;
 if (ProjectList->search(fileName,pos))
   {
    EditorResume *p=&(((PrjItem *)(ProjectList->at(pos)))->resume);
    if (p->prj_flags & 1)
       r=p;
   }
}

void UpdateProjectResumeFor(char *fileName, TCEditWindow *p)
{
 ccIndex pos;

 if (PrjExists() && ProjectList->search(fileName,pos))
   {
    EditorResume &r=((PrjItem *)(ProjectList->at(pos)))->resume;
    p->FillResume(r);
    r.prj_flags|=1;
   }
}

