/*
 * djutils.c
 * Miscellaneous utility functions for DJGPP port of Fileutils 4.0.
 *
 * Some parts written by Richard Dawe <richdawe@bigfoot.com>, some taken from
 * the port of Fileutils 3.16 by Eli Zaretskii <eliz@is.elta.co.il>.
 */

#include <config.h>

#ifdef __DJGPP__

/* Versions of DJGPP > 2.03 support symlinks (currently only DJGPP CVS). If
 * symlinks are supported, we don't need this code. */
#ifndef HAVE_LSTAT

#include <sys/stat.h>

/* DJGPP doesn't have `lstat', since MS-DOS doesn't
 * support links.  Here's a trivial substitute that will do.  */
int lstat (const char *fname, struct stat *st_buf)
{
  return stat (fname, st_buf);
}

#endif /* !HAVE_LSTAT */

#endif /* __DJGPP__ */
